<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.OneValueDataField.php" );
include_once( dirname(__FILE__) . "/../html/class.TextElement.php" );
include_once( dirname(__FILE__) . "/../html/class.InputHiddenElement.php" );
include_once( dirname(__FILE__) . "/../html/module.Constants.php" );





class DateTimeDataField extends OneValueDataField {

	/* -------------------- Members -------------------- */
	var $ms_Presentation;
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function DateTimeDataField( $ps_Value="", $ps_Name=NULL, $ps_Presentation=cc_LongDateTime ) {
		$this->OneValueDataField( $ps_Value, $ps_Name );
		$this->SetPresentation( $ps_Presentation );
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- Get.../Set... -------------------- */
	function SetPresentation( $ps_Presentation ) {
		$this->ms_Presentation = $ps_Presentation;
	}

	function GetPresentation() {
		return $this->ms_Presentation;
	}
	/* -------------------- end Get.../Set... -------------------- */





	/* -------------------- definitions of "abstract" methods -------------------- */
	function GetInputPresentation( $ps_ID=NULL ) {
		global $lang_format_datetime_long, $lang_format_date;
		switch( $this->GetPresentation() ) {
			case cc_Date:
				$ls_Format = $lang_format_date;
				break;
			case cc_LongDateTime:
			default:
				$ls_Format = $lang_format_datetime_long;
				break;
		}
		return new TextElement( date( $ls_Format, $this->GetValue() ) );
	}

	function GetOutputPresentation() {
		global $lang_format_datetime_long;
		return new TextElement( date( $lang_format_datetime_long, $this->GetValue() ) );
	}

	function GetHiddenPresentation( $ps_ID=NULL ) {
		return new InputHiddenElement( array( "name"=>$this->GetNameWithID( $ps_ID ), "value"=>$this->GetValue() ) );
	}
	/* -------------------- end definitions "abstract" methods -------------------- */

}
?>
