<?

include_once( dirname(__FILE__) . "/class.DataField.php" );
include_once( dirname(__FILE__) . "/../html/class.ImageElement.php" );

class ImageDataField extends DataField {
	
	var $ms_Source; // src-attribute of img-tag
	var $ms_AlternateText; // alternative text
	
	function ImageDataField	($ps_src,$ps_alter,$pa_attribute=null){
		$this->SetSource($ps_src);
		$this->SetAlternateText($ps_alter);
		if (is_array($pa_attribute)){
			$this->SetAttributes($pa_attribute);
		}		
	}

	/*-------------------------- Set-, Get- methods ------------------------------*/
	function SetSource( $ps_src ){
		$this->ms_Source = $ps_src;	
	}
	function GetSource(){
		return $this->ms_Source;	
	}
	function SetAlternateText( $ps_alter ){
		$this->ms_AlternateText = $ps_alter;	
	}
	function GetAlternateText(){
		return $this->ms_AlternateText;	
	}
	/*-------------------------- end Set-, Get- methods ------------------------------*/
	
	/* -------------------- definitions of "abstract" methods -------------------- */
	function SetFromArray( $pa_Data ) {
	}
	
	function GetInputPresentation() {
		return $this->GetOutputPresentation();
	}

	function GetOutputPresentation() {
		$la_attributes = $this->GetAttributes();
		$la_attributes["src"] = $this->GetSource();
		$ls_alter=$this->GetAlternateText();
		if($ls_alter){
			$la_attributes["alt"] = $ls_alter;
		}	
		return new ImageElement( $la_attributes );
	}	

	function GetHiddenPresentation( $ps_ID=NULL ) {
		return new HTMLElement( "" );
	}
	
	/* -------------------- end definitions "abstract" methods -------------------- */
}	
?>
	
