<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.ManyValuesDataField.php" );
include_once( dirname(__FILE__) . "/../html/class.SelectElement.php" );
include_once( dirname(__FILE__) . "/../html/class.OptionElement.php" );
include_once( dirname(__FILE__) . "/../html/class.CompoundElement.php" );
include_once( dirname(__FILE__) . "/../html/class.TextElement.php" );





class MultiOptionsDataField extends ManyValuesDataField {

	/* -------------------- Members -------------------- */
	var $ma_Options; // array of options
	var $ms_Separator; // separator to use in output presentation
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function MultiOptionsDataField( $pa_Options=array(), $pa_Values=array(), $ps_Name=NULL ) {
		$this->ManyValuesDataField( $pa_Values, $ps_Name );
		$this->SetOptions( $pa_Options );
		$this->SetSeparator( "<br>\n" );
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- methods to access options -------------------- */
	function SetOptions( $pa_Options ) {
		$this->ma_Options = $pa_Options;
	}

	function GetOptions() {
		return $this->ma_Options;
	}

	function AppendToOptions( $pa_New ){
		foreach( $pa_New as $ls_Key=>$ls_Value )
			$this->ma_Options[$ls_Key] = $ls_Value;
	}

	function SelectAll() {
		$this->SetValues( array_keys($this->GetOptions()) );
	}
	/* -------------------- end methods to access options -------------------- */





	/* -------------------- Set.../Get... -------------------- */
	function SetSeparator( $po_Separator ) {
		$this->mo_Separator = $po_Separator;
	}

	function GetSeparator() {
		return $this->mo_Separator;
	}
	/* -------------------- end Set.../Get... -------------------- */





	/* -------------------- definitions of "abstract" methods -------------------- */
	function GetInputPresentation( $ps_ID=NULL ) {
		$la_Attributes = $this->GetAttributes( $ps_ID );
		$la_Attributes["multiple"]=NULL;
		$la_Attributes["size"]=10;
		$lo_Result = new SelectElement( $la_Attributes );
		foreach( $this->GetOptions() as $ls_Value=>$ls_Text )
			$lo_Result->AppendToContent( new OptionElement( $this->IsValue($ls_Value) ? array( "value"=>$ls_Value,
							"selected"=>NULL ) : array( "value"=>$ls_Value ), new TextElement( $ls_Text ) ) );
		return $lo_Result;
	}

	function GetOutputPresentation() {
		$lo_Result = new CompoundElement();
		$lo_Result->SetSeparator( $this->GetSeparator() );
		foreach( $this->GetOptions() as $ls_Value=>$ls_Text )
			if( $this->IsValue($ls_Value) )
				$lo_Result->AppendToContent( new TextElement( $ls_Text ) );
		return $lo_Result;
	}

	function GetHiddenPresentation( $ps_ID=NULL ) {
		$lo_Result = new CompoundElement();
		foreach( $this->GetValues() as $ls_Value )
			$lo_Result->AppendToContent( new InputHiddenElement( array( "name"=>$this->GetNameWithID( $ps_ID ),
							"value"=>$ls_Value ) ) );
		return $lo_Result;
	}
	/* -------------------- end definitions "abstract" methods -------------------- */

}
?>
