<?
include_once( dirname(__FILE__) . '/class.SetOfRowsData.php' );
include_once( dirname(__FILE__) . '/class.DataRow.php' );

include_once( dirname(__FILE__) .'/../../data_source/class.KeyValue.php'); 
include_once( dirname(__FILE__) .'/../../data_source/class.CompoundValue.php'); 

class TableView {
	var $moDataSource;
	var $moTitle;
	var $moHeader;
	var $moFooter;
	var $moButtons;

	/*
	 * constructor
	 */

	function TableView( &$poDataSource, $poHeader = NULL, $poFooter = NULL, $poButtons = NULL ) {
		global $DEBUG;

		$this->moDataSource = NULL;
		$this->moHeader = NULL;
		$this->moFooter = NULL;
		$this->moTitle = NULL;
		$this->moButtons = NULL;

		$this->setDataSource( $poDataSource );
		$this->setHeader( $poHeader );
		$this->setFooter( $poFooter );
		$this->setButtons( $poButtons );

	}

	/*
	 * Properties
	 */

	function &DataSource( $poDataSource = NULL ){
		global $DEBUG;
		if( !is_null($poDataSource)){
			$laArgs = func_get_args();
			call_user_func_array( array( &$this, 'setDataSource' ), $laArgs );
		}
		return $this->moDataSource;
	}


	function &Header( $poHeader = NULL ){
		if( !is_null( $poHeader ) ) {
			$laArgs = func_get_args();
			call_user_func_array( array( &$this, 'setHeader'), $laArgs );
		}
		return $this->moHeader;
	}


	function &Footer( $poFooter = NULL ){
		if( !is_null( $poFooter ) ) {
			$laArgs = func_get_args();
			call_user_func_array( array( &$this, 'setFooter' ), $laArgs );
		}
		return $this->moFooter;
	}


	function &Title( $poTitle = NULL ){
		global $DEBUG;
		if( !is_null( $poTitle ) ) {
			$laArgs = func_get_args();

			call_user_func_array( array(&$this,'setTitle'), $laArgs );
		}
		return $this->moTitle;
	}

	function &Buttons( $poButtons = NULL ){
		global $DEBUG;
		if( !is_null( $poButtons ) ) {
			$laArgs = func_get_args();

			call_user_func_array( array(&$this,'setButtons'), $laArgs );
		}
		return $this->moButtons;
	}

	/*
	 *  end Properties
	 */


	/*
	 * set/get methods 
	 */

	function &setDataSource( &$poDataSource ){
		if( is_a( $poDataSource, 'CompoundValue' ) ) {
			$this->moDataSource =& $poDataSource;

		} elseif( is_a( $poDataSource, 'KeyValue' ) ) {
			$this->moDataSource = new CompoundValue( func_get_args() );

		} elseif( is_array( $poDataSource ) ) {
			$this->moDataSource = new CompoundValue( $poDataSource );
		}
		return $this->moDataSource;
	}

	function &setHeader( &$poHeader ){
		if( is_a( $poHeader, 'CompoundValue' ) ) {
			$this->moHeader =& $poHeader;
		} elseif( is_a( $poHeader, 'KeyValue' ) ) {
			$this->moHeader = new CompoundValue( func_get_args() );
		} elseif( is_array( $poHeader ) ) {
			$this->moHeader = new CompoundValue( $poHeader );
		}
		return $this->moHeader;
	}


	function &setFooter( &$poFooter ){
		if( is_a( $poFooter, 'CompoundValue' ) ) {
			$this->moFooter =& $poFooter;
		} elseif( is_a( $poFooter, 'KeyValue' ) ) {
			$this->moFooter = new CompoundValue( func_get_args() );
		} elseif( is_array( $poFooter ) ) {
			$this->mFooter = new CompoundValue( $poFooter );
		}
		return $this->mFooter;
	}

	function &setTitle( &$poTitle ){
		global $DEBUG;
		if( is_a( $poTitle, 'CompoundValue' ) ) {
			$this->moTitle =& $poTitle;

		} elseif( is_a( $poTitle, 'KeyValue' ) ) {
			$this->moTitle = new CompoundValue( func_get_args() );

		} elseif( is_array( $poTitle ) ) {
			$this->moTitle = new CompoundValue( $poTitle );
		}

		/*
		if($DEBUG){
			echo "TableView::setTitle<br><pre>\n";
			print_r($this->moTitle);
			echo "</pre><hr>\n";
		}
		*/
		return $this->moTitle;
	}

	function &setButtons( &$poButtons ){
		global $DEBUG;

		if( is_a( $poButtons, 'CompoundValue' ) ) {
			$this->moButtons =& $poButtons;

		} elseif( is_a( $poButtons, 'CompoundDataField' ) ) {
			$this->moButtons =& $poButtons;

		} elseif( is_a( $poButtons, 'DataField' ) ) {
			$this->moButtons = new CompoundDataField( func_get_args() );

		} elseif( is_a( $poButtons, 'KeyValue' ) ) {
			$this->moButtons = new CompoundValue( func_get_args() );

		} elseif( is_array( $poButtons ) ) {
			$this->moButtons = new CompoundValue( $poButtons );
		}
		return $this->moButtons;
	}


	function setFromArray( &$paSource ) {
		global $DEBUG;
		if( is_array( $paSource ) ) {

			if ( $this->moHeader ) {
				$this->moHeader->setFromArray( $paSource );
			}
			if ( $this->moTitle ) {
				$this->moTitle->setFromArray( $paSource );
			}
			if ( $this->moDataSource ) {
				$this->moDataSource->setFromArray( $paSource );
			}
			if ( $this->moFooter ) {
				$this->moFooter->setFromArray( $paSource );
			}
		}
	}

	/*
	 * set/get methods 
	 */


	function &pushFooter( $poValue ){
		global $DEBUG;
		if( !is_a( $this->moFooter, 'CompoundValue' ) ){
			$this->moFooter = new CompoundValue();
		}
		$laContent = array();
		foreach (func_get_args() as $loValue ){
			if (is_object($loValue)){
				$laContent[] = $loValue;
			} else {
				$laContent[] = new KeyValue( '', $loValue );
			}
		}
		return $this->moFooter->addValue( $laContent );
	}

	function pushHeader( $poValue ){
		if( !is_a( $this->moHeader, 'CompoundValue' ) ){
			$this->moHeader = new CompoundValue();
		}
		$laContent = array();
		foreach (func_get_args() as $loValue ){
			if (is_object($loValue)){
				$laContent[] = $loValue;
			} else {
				$laContent[] = new KeyValue( '', $loValue );
			}
		}
		return $this->moHeader->addValue( $laContent );

	}


	function &prepareTitle(){

		global $DEBUG;

		$loTitle =& $this->Title();
		/*
		if($DEBUG){
			echo "TableView::prepareTitle : start<br><pre>\n";
			print_r($loTitle);
			echo "</pre><hr>\n";
		}
		*/
		$lsRet = NULL;
		if( is_a( $loTitle, 'CompoundValue' ) ) {
			$laRet = array();
			$llHasSecond = 0;
			$laRet[0] = new CompoundValue();
			$loIterCel =& $loTitle->getFirstIterator();
			
			while( $loCel =& $loIterCel->getNext() ) {
				if(is_a( $loCel, 'CompoundValue' ) ) {
					$loSecIter = $loCel->getFirstIterator();
					while ( $loSecCel =& $loSecIter->getNext()){ 
						if( is_a( $loSecCel, 'CompoundValue' ) ) {
							$loLast =& $laRet[0]->getLast();
							$liLastInd = $laRet[0]->getCount()-1;
							if( method_exists( $loLast, 'ParentAttribute' ) ){
								$loLast->ParentAttribute( 'colspan', $loSecCel->getCount() );

							}elseif( is_a( $loLast, 'DataValue' ) ) {
								$loDataField =& $loLast->DataField();
								$loDataField->ParentAttribute( 'colspan', $loSecCel->getCount() );

							}elseif( is_a( $loLast, 'KeyValue' ) ) {
								$loDataField  = new HTMLDataField( $loLast->Value());
								$loDataField->ParentAttribute( 'colspan', $loSecCel->getCount());
								$laRet[0]->Value( $liLastInd, new DataValue( '', NULL, $loDataField ));
							}
							if ( !$llHasSecond ) {

								$laRet[1] = new CompoundValue();
								$llHasSecond = 1;
								for( $i=0; $i < $liLastInd; $i++ ){
									$laRet[1]->addValue( new KeyValue('','&nbsp;') );
								}
							}

							$loTreeIter =& $loSecCel->getTreeIterator();
							while( $loItem =& $loTreeIter->getNext()){
								$laRet[1]->addValue( $loItem );
							}

						}else{
							$laRet[0]->addValue( $loSecCel );
						}
					}
				}else{
					$laRet[0]->addvalue( $loCel );
					if ( $llHasSecond ) {
						$laRet[1]->addvalue( new KeyValue('','&nbsp;') );
					}
				}
			}
		}else{
			$laRet = array($loTitle);
		}
		/*
		if($DEBUG){
			echo "TableView::prepareTitle : return<br><pre>\n";
			print_r($laRet);
			echo "</pre><hr>\n";
		}
		*/
		return $laRet;
	}

	function &GetOutputPresentation( $poTitle, $poNoData = NULL, $paFormAttributes = NULL ) {
		global $DEBUG;
		
		if( !( is_null( $poNoData ) || is_null( $this->moDataSource ) ) ) {
			return is_object( $poNoData ) ? $poNoData : new HTMLElement( $poNoData );
		}

		$loRows = new SetOfRowsData();

		$llInputPresentation =  is_array( $paFormAttributes );


#
# title
#
		if( !is_null( $this->moTitle ) ) {

			$loDataRow = new DataRow( TRUE ); ## header
			if( is_a( $this->moTitle,'CompoundValue' ) ) {
			
				$loIterCel =& $this->moTitle->getTreeIterator();

				while( $loCel =& $loIterCel->getNext() ) {
					if( method_exists( $loCel, 'DataField' ) ) {
						$loDataRow->AppendFields( $loCel->DataField() );
						
					}else{
						$loDataRow->AppendFields( new HTMLDataField( $loCel->Value() )  );
					}
				}
				
			} elseif( is_a($this->moTitle,'KeyValue' ) ) {
				$loDataRow->AppendFields( new HTMLDataField( $this->moTitle->Value() )  );
				
			} else {
				$loDataRow->AppendFields( new HTMLDataField( $this->moTitle )  );
			}

			$loRows->AppendRow( $loDataRow );

		}
#
# /title
#

#
# body
#

		if( is_a( $this->moDataSource, 'SetOfRowsData') ) {
			$loRows->AppendRowsFrom( $this->moDataSource );

		} elseif( is_a( $this->moDataSource, 'CompoundValue') ) {
			$loIterRow = $this->moDataSource->getFirstIterator();

			while( $loRow =& $loIterRow->getNext() ){

				$loDataRow = new DataRow( FALSE );

				$loIterCel = $loRow->getTreeIterator();
				
				while ( $loCel =& $loIterCel->getNext() ) {
					if( $llInputPresentation ) {
						$loField = new TextDataField( $loCel->Value(), $loCel->Key() );
					} else {
						$loField = new HTMLDataField( $loCel->Value() );
					}
					$loDataRow->AppendFields( $loField );
				}
				$loRows->AppendRow( $loDataRow );
			}
		}
#
# /body
#
		if( !is_null( $this->moButtons ) ) {
			$loDataRow = new DataRow( FALSE );

			if( is_a( $this->moButtons, 'CompoundValue' ) ) {
				$loIterCel =& $this->moButtons->getFirstIterator();
				while ( $loCel =& $loIterCel->getNext() ){
					if( is_a( $loCel, 'ValueButtonHref' ) ) {
						$loCel = new ButtonURLData( $loCel->Value(), 
																				$loCel->getLinkDataField() );
					} else {
						$loCel = new TextDataField( '&nbsp;' );
					}
					$loDataRow->AppendFields( $loCel->GetInputPresentation() );
				}
			} elseif( is_a( $this->moButtons, 'CompoundDataField' ) ){
				foreach($this->moButtons->GetContent() as $loCell ){
					$laAttributes = $loCell->GetColSpan()==1 ? array() : array( "colspan"=>$loCell->GetColSpan() );
					$laAttributes = array_merge($laAttributes,$loCell->GetParentAttributes());

					$loDataRow->AppendFields( $loCell->GetInputPresentation() );
					
				}
			}
			$loRows->AppendRow( $loDataRow );

		}

		if( $llInputPresentation ) {
			$loPres =& $loRows->GetInputPresentation( $paFormAttributes, $poTitle );
		} else {
			$loPres =& $loRows->GetOutputPresentation( $poTitle );
		}

		
		if( !is_null( $this->moHeader ) ) {
			$loIterRow =& $this->moHeader->getFirstIterator();
			while( $loRow =& $loIterRow->getNext() ){
				$loPres->AppendTop( $loRow->joinValue() );
			}
		}

		if( !is_null( $this->moFooter ) ) {

			$loIterRow =& $this->moFooter->getFirstIterator();
			while( $loRow =& $loIterRow->getNext() ){
				$loPres->AppendHelp( $loRow->joinValue() );
			}
		}

		return $loPres;
	}

	function &GetInputPresentation( $paFromAttributes, $poTitle = NULL, $poNoData = NULL){
		return $this->GetOutputPresentation( $poTitle, $poNoData, TRUE , $paFromAttributes );
	}

}
?>