<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.OneValueDataField.php" );
include_once( dirname(__FILE__) . "/../html/class.TextElement.php" );
include_once( dirname(__FILE__) . "/../html/class.InputTextElement.php" );
include_once( dirname(__FILE__) . "/../html/class.InputHiddenElement.php" );





class TextDataField extends OneValueDataField {

	var $mlInput;

	/* -------------------- Constructor -------------------- */
	function TextDataField( $ps_Value="", $ps_Name=NULL, $pl_Input = TRUE, 
													$paAttributes = array(), $paParentAttributes = array() ) {

		if(is_array( $pl_Input ) ) { /* shift parameters*/
			$paParentAttributes = $paAttributes;
			$paAttributes = $pl_Input;
			$pl_Input = TRUE;
		}
		$this->mlInput = $pl_Input;

		$this->OneValueDataField( $ps_Value, $ps_Name, $paAttributes, $paParentAttributes );
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- definitions of "abstract" methods -------------------- */
	function &GetInputPresentation( $ps_ID=NULL ) {
		if($this->mlInput){
			$la_Attributes = $this->GetAttributes( $ps_ID );
			$la_Attributes["value"] = $this->GetValue();
			return new InputTextElement( $la_Attributes );
		} else {
			return $this->GetOutputPresentation();
		}
	}

	function &GetOutputPresentation() {
		return new TextElement( $this->GetValue() );
	}

	function &GetHiddenPresentation( $ps_ID=NULL ) {
		return new InputHiddenElement( array( "name"=>$this->GetNameWithID( $ps_ID ), "value"=>$this->GetValue() ) );
	}
	/* -------------------- end definitions "abstract" methods -------------------- */

}
?>
