<?
include_once( 'class.GenericButtonData.php');
include_once( 'class.LinkDataField.php' );

class ToolsButtonData extends GenericButtonData {

	var $moLinkData;
	var $msHrefPattern;

	function ToolsButtonData( $psButtonName, $psLabel, $psHref, $paQuery = array() ){

		$this->setLinkData( $psHref, '',  $paQuery );

#
# default settings
#
		if(!$this->QueryValue( 'cur_page' ) ){
			$this->QueryValue( 'cur_page', $this->GetLink() );
		}
		if(!$this->QueryValue( 'head_text' ) ){
			$this->QueryValue( 'head_text', $psLabel );
		}
		if(!$this->QueryValue( 'menu_node_id' ) ){
			$this->QueryValue( 'menu_node_id', 'menu_node_'.$psButtonName );
		}
#
# /default settings
#

		$this->setHrefPattern( "javascript:location.href='%s'; return false;" );
		$lsHref = $this->GetHREF( );

		$this->GenericButtonData( '', $psButtonName, $psLabel, $lsHref, $psButtonName );

	}

#
# get/set methods
#
	function &setLinkData( $poSrc ){

		if( is_a( $poSrc,'LinkDataField' ) ) {
			$this->moLinkData = new LinkDataField( $poSrc );

		} else {
			$this->moLinkData = new LinkDataField( func_get_args() );
		}
		return $this->moLinkData;
	}

	function &getLinkData(){
		return $this->moLinkData;
	}

	function setHrefPattern( $psPattern ){
		$this->msHrefPattern = $psPattern;
		return $this->msHrefPattern;
	}

	function &getHrefPattern(){
		return $this->msHrefPattern;
	}

	function GetHREF( $psPattern=NULL ){
		$lsHref = $this->moLinkData->GetHREF();
		if( is_null( $psPattern ) ) {
			$psPattern = $this->getHrefPattern();
		}
		if( $psPattern ) {
			$lsHref = str_replace( '%s', $lsHref, $psPattern);
		}
		return $lsHref;
	}

	function GetLink(){
		return $this->moLinkData->GetLink();
	}

	function &GetQuery(){
		return $this->moLinkData->GetQuery();
	}
#
# end get/set methods
#


#
# properties
#
	function QueryValue( $lcKey, $lcValue=NULL ){

		$laQuery =& $this->GetQuery();

		if( $lcValue ){
			$laQuery[$lcKey] = $lcValue;

		} else {
			if( array_key_exists( $lcKey, $laQuery ) ) {
				$lcValue = $laQuery[$lcKey];
			} else {
				$lcValue = NULL;
			}
		}

		return $lcValue;
	}

#
# /properties
#

	function updateOnClick(){
		$lsHref = $this->GetHREF();
		$this->setOnClick( $lsHref );
	}

}
?>