<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.HTMLElement.php" );
include_once( dirname(__FILE__) . "/module.Constants.php" );





class CompoundElement extends Element {

	/* -------------------- Members -------------------- */
	var $ma_Content; // elements inside
	var $ms_Separator; // separator between elements
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function CompoundElement( $paContent = NULL) {
		$this->Element();
		$this->SetSeparator( "\n" );
		$this->ClearContent();
		if( is_array( $paContent ) ) {
			$la_Arguments = $paContent;
		}else{
			$la_Arguments = func_get_args();
		}

		if( count( $la_Arguments ) ) {
			call_user_func_array( array( &$this, "AppendToContent" ), $la_Arguments );
		}
		
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- methods to access content elements -------------------- */
	function &AppendToContent( $pm_First ) {
		global $DEBUG;

		foreach( func_get_args() as $lm_Element )
			if ( is_object($lm_Element) )
				$this->ma_Content[] = $lm_Element;
			else
				$this->ma_Content[] = new HTMLElement( $lm_Element );
		return $this->ma_Content[ count($this->ma_Content) - 1 ];
	}

	function &GetContent( $ps_Index=NULL ) {
		if( is_null($ps_Index) )
			return $this->ma_Content;
		if( $ps_Index == cc_LastElement )
			return $this->ma_Content[ count($this->ma_Content) - 1 ];
		return $this->ma_Content[$ps_Index];
	}

	function ClearContent() {
		$this->ma_Content = array();
	}

	function CountContent() {
		return count( $this->ma_Content );
	}
	/* -------------------- end methods to access content elements -------------------- */





	/* -------------------- Get.../Set... -------------------- */
	function SetSeparator( $ps_Separator ) {
		$this->ms_Separator = $ps_Separator;
	}

	function GetSeparator() {
		return $this->ms_Separator;
	}
	/* -------------------- end Get.../Set... -------------------- */





	/* -------------------- GetHTML & related -------------------- */
	function GetContentHTML() {
		$la_Result = array();
		foreach( $this->GetContent() as $lo_Element ){
			$la_Result[] = $lo_Element->GetHTML();
		}

		return implode( $this->GetSeparator(), $la_Result );
	}

	function GetHTML() {
		return $this->GetContentHTML();
	}

	function printHTML(){
		return $this->printContentHTML();
	}

	function printContentHTML(){
		$laContent =& $this->GetContent();
		$liRet = 0;
		$lcSep = $this->GetSeparator();
		foreach( $laContent as $loElement ){
			if( $liRet ){
				echo $lcSep;
			}
			$liRet += $loElement->printHTML();
		}
		return $liRet;
	}
	/* -------------------- end GetHTML & related -------------------- */

}
?>
