<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/




include_once( dirname(__FILE__) . "/class.HTMLElement.php" );
include_once( dirname(__FILE__) . "/class.FieldsetElement.php" );
include_once( dirname(__FILE__) . "/class.LegendElement.php" );
include_once( dirname(__FILE__) . "/class.TableElement.php" );
include_once( dirname(__FILE__) . "/class.FormElement.php" );
include_once( dirname(__FILE__) . "/class.CompoundElement.php" );
include_once( dirname(__FILE__) . "/class.PElement.php" );
include_once( dirname(__FILE__) . "/class.DivElement.php" );





define( "cc_IncludeForm", 1 );





class InputForm extends CompoundElement {

	/* -------------------- Members -------------------- */
	var $ms_CurrentHeader; // current row is a header
	var $mi_LabelIndex; // index of label's cell
	var $ms_TableClass; // CSS class for table
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function InputForm( $pa_FormAttributes, $pm_Title = NULL, $ps_Flags = cc_IncludeForm, 
	                    $ps_TableClass = null ){
		if( $pm_Title ){
			$lo_Legend = new LegendElement( array(), $pm_Title );
		}else{
			$lo_Legend = new HTMLElement(''); ## need for order of items
		}
		if( is_string( $ps_TableClass ) ){
		  $this->ms_TableClass = $ps_TableClass;
		}else{
		  $this->ms_TableClass = 'InputTable';
		}
		$lo_Table = new TableElement( array( "class" => $this->ms_TableClass ) );
		$lo_ButtonsArea = new TableElement( array( "class" => "formArea" ) );
		if( $ps_Flags&cc_IncludeForm )
			$lo_Form = new FormElement( $pa_FormAttributes, 
																	$lo_Table, 
																	$lo_ButtonsArea, 
																	new CompoundElement()
																	);
		else
			$lo_Form = new PElement( array(), 
															 $lo_Table, 
															 $lo_ButtonsArea,
															 new CompoundElement() 
															 ); // no form
		$lo_Help = new CompoundElement();
		$lo_Fieldset = new FieldsetElement( array(), $lo_Legend, $lo_Form, $lo_Help );
		$this->CompoundElement( $lo_Fieldset );
		$this->LabelIndex( 0 );
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- methods for internal use only -------------------- */
	function &GetForm() {
		$lo_Fieldset =& $this->GetContent(0);
		return $lo_Fieldset->GetContent(1);
	}

	function &GetTable() {
		$lo_Form =& $this->GetForm();
		return $lo_Form->GetContent(0);
	}

	function &GetHelp() {
		$lo_Fieldset =& $this->GetContent(0);
		return $lo_Fieldset->GetContent(2);
	}

	function &GetTop() {
		$lo_Fieldset =& $this->GetContent(0);
		return $lo_Fieldset->GetContent(0);
	}

	function &GetButtonsArea() {
		$lo_Form =& $this->GetForm();
		return $lo_Form->GetContent(1);
	}

	function &GetHiddenArea() {
		$lo_Form =& $this->GetForm();

		/*
		echo "<InputForm::GetHiddenArea: <br><pre>\n";
		print_r($lo_Form);
		echo "</pre><hr>\n";
		*/

		return $lo_Form->GetContent(2);
	}

	/* -------------------- end methods for internal use only -------------------- */

	function &LabelIndex( $piIndex=NULL){
		if(is_numeric($piIndex)){
			$this->mi_LabelIndex = $piIndex;
		}
		return $this->mi_LabelIndex;
	}

	function &TableClass( $pcTableClass = NULL){
		if( is_string( $pcTableClass ) ){
			$this->ms_TableClass = $pcTableClass;
		}
		return $this->ms_TableClass;
	}

	/* -------------------- add rows & cells -------------------- */
	function AppendRow( $pa_Attributes, $ps_Header = FALSE ) {
		$this->ms_CurrentHeader = $ps_Header;
		$lo_Table =& $this->GetTable();
		$la_Attributes = array_merge( array( 'class' => 'datacell' ), $pa_Attributes  );
		$lo_Table->AppendRow( $la_Attributes );
	}

	function AppendCell( $pa_Attributes ) {
		$lo_Table =& $this->GetTable();
		$lo_Row =& $lo_Table->GetContent( $lo_Table->CountContent() - 1 );
		$la_Arguments = func_get_args();
		array_splice( $la_Arguments, 1, 0, $this->ms_CurrentHeader );
		$liLabelIndex = $this->LabelIndex();
		if( $liLabelIndex == $lo_Row->CountContent() ){
			$la_Arguments[0]["class"] = "datalabel";
		}
		call_user_func_array( array( &$lo_Row, "AppendCell" ), $la_Arguments );
	}
	/* -------------------- end add rows & cells -------------------- */





	/* -------------------- add buttons -------------------- */
	function AppendButton( $po_Button ) {
		$lo_ButtonsArea =& $this->GetButtonsArea();
		if( !$lo_ButtonsArea->CountContent() ) {
			$lo_ButtonsArea->AppendRow( array() );
		}
		$loRow =& $lo_ButtonsArea->GetContent(0);
		$loRow->AppendCell( array(), $po_Button );
	}
	/* -------------------- end add buttons -------------------- */





	/* -------------------- add hidden fields -------------------- */
	function AppendHidden( $po_First ) {

		global $DEBUG;

		$la_Arguments = array();
		$laArgs = func_get_args();
		foreach ( $laArgs as $loObj ) {
			$la_Arguments[] = new HTMLElement("\n");
			$la_Arguments[] =& $loObj;
		}
		$lo_Hidden =& $this->GetHiddenArea();

		/*
		if($DEBUG){
			echo "InputForm::AppendHidden<br><pre>\n";
			print_r($lo_Hidden);
			echo "</pre><hr>\n";
		}
		*/

		call_user_func_array( array( &$lo_Hidden, "AppendToContent" ), $la_Arguments );
	}
	/* -------------------- end add hidden fields -------------------- */





	/* -------------------- add help -------------------- */
	function AppendHelp( $pm_Text ) {
		$lo_Help =& $this->GetHelp();
		foreach( func_get_args() as $lm_Text )
			$lo_Help->AppendToContent( new PElement( array(), is_object($lm_Text) ? $lm_Text :
						new HTMLElement( $lm_Text ) ) );
	}
	/* -------------------- end add help -------------------- */
	




	/* -------------------- add to top -------------------- */
	function AppendTop( $pm_Text ) {
		$lo_Top =& $this->GetTop();
		$lo_Top->AppendToContent( new PElement( array(), $pm_Text ) );
	}
	/* -------------------- end add to top -------------------- */





	/* -------------------- SetWidths -------------------- */
	function SetWidths( $ps_First, $pi_Ind=NULL ){
		$lo_Table =& $this->GetTable();
		if( is_array( $ps_First ) ) {
			$la_Widths = $ps_First;
			if( is_numeric( $pi_Ind ) ) {
				$lo_Row =& $lo_Table->GetContent( $pi_Ind );
			}else{
				$lo_Row =& $lo_Table->GetContent(0);
			}
		} else {
			$la_Widths = func_get_args();
			$lo_Row =& $lo_Table->GetContent(0);
		}

		if( is_object($lo_Row) ) {
			$la_Cells =& $lo_Row->GetContent();
			for ( $i=0; $i<count($la_Widths) && $i<count($la_Cells); $i++ )
				$la_Cells[$i]->AppendAttributes( array( "width"=>$la_Widths[$i] ) );
		}
	}
	/* -------------------- end SetWidths -------------------- */

}
?>
