<?

include_once( dirname(__FILE__) . "/class.FieldsetElement.php" );
include_once( dirname(__FILE__) . "/class.DivElement.php" );
include_once( dirname(__FILE__) . "/class.PElement.php" );
include_once( dirname(__FILE__) . "/class.LegendElement.php" );
include_once( dirname(__FILE__) . "/class.PagedFormElement.php" );
include_once( dirname(__FILE__) . "/class.CompoundElement.php" );


class PagedInfoForm extends DivElement {

	var $moPagedForm; /* pointer to PagedFormElement */
	var $miCurentOdd; /* current row is odd/*/
	var $moCurrentRow; /* pointer to current row */
	var $moButtons; /* additional buttons */

	function PagedInfoForm (  $paFormAttributes, $pm_Title, $poBodyElement = NULL, $paParams = array()  ) {
		global $DEBUG;

		$loLegend = new LegendElement( array(), $pm_Title );
		$loTop = new CompoundElement( );

		$loForm = new PagedFormElement( $paFormAttributes, $poBodyElement, array( "class"=>"InfoTable") );

		$loButtons = new CompoundElement( );
		$loHelp = new CompoundElement( );
		$loAnchor = new HTMLElement( '' );

		$this->DivElement( array('name'=>'paging','id'=>'paging'),
											 new FieldsetElement( array() ,
																						$loAnchor, 
																						$loLegend, 
																						$loTop, 
																						$loForm, 
																						$loButtons,
																						$loHelp 
																						)
											 );

		$loFlds =& $this->GetContent( 0 );
		$this->moPagedForm =& $loFlds->GetContent( 3 );
		$this->miCurrentOdd = 0;

		$this->mlCurrentHeader = FALSE;
	}

	function &FormIndex( $piFormIndex = NULL ){
		return $this->moPagedForm->FormIndex( $piFormIndex );
	}

	function &SearchElement( $poSearchElement = NULL ){
		return $this->moPagedForm->SearchElement( $poSearchElement );
	}

	function &setSearchElement( &$poSearchElement ){
		return $this->moPagedForm->setSearchElement( $poSearchElement );
	}

	function &GroupActionElement( $poElement = NULL ){
		return $this->moPagedForm->GroupActionElement( $poElement );
	}

	function &setGroupActionElement( &$poElement ){
		return $this->moPagedForm->setGroupActionElement( $poElement );
	}


	function &BodyElement( $poBodyElement = NULL ){
		return $this->moPagedForm->BodyElement( $poBodyElement );
	}


	function &GetAnchor(){
		$loFlds =& $this->GetContent( 0 );
		return $loFlds->GetContent(0);
	}

	function &GetLegend(){
		$loFlds =& $this->GetContent( 0 );
		return $loFlds->GetContent(1);
	}

	function &GetTop(){
		$loFlds =& $this->GetContent( 0 );
		return $loFlds->GetContent(2);
	}

	function &getPagedForm(){
		$loFlds =& $this->GetContent( 0 );
		$this->moPagedForm =& $loFlds->GetContent( 3 );
		return $this->moPagedForm;
	}

	function &getButtons() {
		$loFlds =& $this->GetContent( 0 );
		return $loFlds->GetContent(4);
	}


	function &GetHelp() {
		$loFlds =& $this->GetContent( 0 );
		return $loFlds->GetContent(5);
	}

	function isBodyTable() {
		return is_a( $this->moPagedForm->BodyElement(), 'TableElement' );
	}

	function &getBodyTable() {
		if( $this->isBodyTable()){
			return $this->BodyElement();
		} else {
			return NULL;
		}
	}

	function Anchor( $pcAnchor = NULL){
		if( !is_null( $pcAnchor ) ) {
			if( is_a( $pcAnchor, 'AElement' )){
				$loNewAnchor = $pcAnchor;
			} else {
				$loNewAnchor = new AElement(array('name'=>$pcAnchor));
			};
			$loFlds =& $this->GetContent( 0 );
			$loFlds->SetContent( 0, $loNewAnchor );
		}
		$loAnchor =& $this->GetAnchor(); 
		if( is_a( $loAnchor, 'AElement' ) ) {
			return $loAnchor->GetAttribute('name');
		}else{
			return '';
		}
	}

	function updateBodyContent( $paTableAttributes = NULL ) {
		global $confixx_interface_version;
		if( $confixx_interface_version == 'powp' ) {
			$this->moPagedForm->updatePowpContent( $paTableAttributes );

		} else {
			$this->moPagedForm->updateContent( $paTableAttributes );
		}
	}

	function appendToParameters( $paParams ) {
		$this->moPagedForm->appendToParameters( $paParams );
	}

	function AppendHidden( ){
		$laArguments = func_get_args();
		$this->moPagedForm->AppendToContent( $laArguments );
	}

	function AppendButtons( $poButton ){
		$loButtons =& $this->getButtons();
		foreach( func_get_args() as $loButton ){
			if(is_a($loButton,'CompoundHtml')){
				foreach ($loButton->GetContent() as $loItem ){
					$loButtons->AppendToContent( $lItem );
				}
			}else{
				$loButtons->AppendToContent( $loButton );
			}
		}
	}

	/* -------------------- add help -------------------- */
	function AppendHelp( $pmText ) {
		$loHelp =& $this->GetHelp();
		foreach( func_get_args() as $lmText )
			$loHelp->AppendToContent( new PElement( array(), is_object($lmText) ? $lmText :
																							new HTMLElement( $lmText ) ) 
																);
	}
	/* -------------------- end add help -------------------- */





	/* -------------------- add to top -------------------- */
	function AppendTop( $pmText ) {
		$loTop =& $this->GetTop();
		$loTop->AppendToContent( new PElement( array(), $pmText ) );
	}
	/* -------------------- end add to top -------------------- */


	/* -------------------- SetWidths -------------------- */
	function SetWidths( $psFirst ){

		$loTable =& $this->getBodyTable();
		if( !$loTable ) {
			return FALSE;
		}

		$loRow =& $loTable->GetContent(0);
		if( is_object($loRow) ) {
			$laWidths = func_get_args();
			$laCells =& $loRow->GetContent();
			for ( $i=0; $i<count($laWidths) && $i<count($laCells); $i++ ) {
				if( is_null($laWidths[$i]) ) {
					$laCells[$i]->UnsetAttribute( "width" );
				}	else {
					$laCells[$i]->AppendAttributes( array( "width"=>$la_Widths[$i] ) );
				}
			}
		}
		return TRUE;
	}
	/* -------------------- end SetWidths -------------------- */


	/* -------------------- add cells/rows to table -------------------- */
	function &AppendRow( $paAttributes = array(), $plHeader = FALSE ) {
		global $DEBUG;

		$loTable =& $this->getBodyTable();

		if( !$loTable ) {
			$this->moCurrentRow = NULL;
			return NULL;
		}
		if( $plHeader ) {
			$laAttributes =& $paAttributes;
		} else {
			if( $this->miCurrentOdd ) {
				$laAttributes = array_merge( $paAttributes, array( "class"=>"oddrowbg" ) );
			}	else {
				$laAttributes = array_merge( $paAttributes, array( "class"=>"evenrowbg" ) );
			}
			$this->miCurrentOdd ^= 1;
		}
		$this->moCurrentRow =& $loTable->AppendRow( $laAttributes );
		$this->moCurrentRow->isHeader( $plHeader );

		return $this->moCurrentRow;
	}

	function &appendHeaderRow( $paAtrributes = array() ){
		return $this->AppendRow( $paAtrributes, TRUE );
	}

	function &AppendCell( $paAttributes ) {
		global $DEBUG;
		
		$loTable =& $this->getBodyTable();
		if( !$loTable ) {
			return NULL;
		}
		if( !$this->moCurrentRow ) {
			$this->moCurrentRow =& $loTable->GetContent( cc_LastElement );
		}
		$laArguments = func_get_args();
		
		array_splice( $laArguments, 1, 0, $this->moCurrentRow->isHeader() );

		$loRet =& call_user_func_array( array( &$this->moCurrentRow, 'AppendCell' ), $laArguments );

		return $loRet;
	}
	/* -------------------- end add cells/rows to table -------------------- */


}
?>