<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.FieldsetElement.php" );
include_once( dirname(__FILE__) . "/class.LegendElement.php" );
include_once( dirname(__FILE__) . "/class.PagedTableElement.php" );
include_once( dirname(__FILE__) . "/class.PElement.php" );
include_once( dirname(__FILE__) . "/class.CompoundElement.php" );
include_once( dirname(__FILE__) . "/class.FormElement.php" );





class PagedInfoTable extends FieldsetElement {

	/* -------------------- Members -------------------- */
	var $ms_CurrentHeader; // current row is header - so, add <th>, not <td>
	var $ms_Odd; // current row is odd
	var $ms_Buttons; // TRUE if at least one button was added
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function PagedInfoTable( $pm_Title, $po_DataSource, $pa_FormAttributes=array() ) {
		$lo_Legend = new LegendElement( array(), $pm_Title );
		$lo_Top = new CompoundElement( );
		$lo_Table = new PagedTableElement( $po_DataSource, $pa_FormAttributes, array( "class"=>"InfoTable") );
		$lo_Help = new CompoundElement( );
		$this->FieldsetElement( array(), $lo_Legend, $lo_Top, $lo_Table, $lo_Help );
		$this->ms_CurrentHeader = FALSE;
		$this->ms_Odd = 1;
		$this->ms_Buttons = FALSE;
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- Set.../Get... -------------------- */
	function GetNeedSearch() {
		$lo_Table =& $this->GetPagedTable();
		return $lo_Table->GetNeedSearch();
	}

	function SetNeedSearch ( $ps_NeedSearch ) {
		$lo_Table =& $this->GetPagedTable();
		$lo_Table->SetNeedSearch( $ps_NeedSearch );
	}
	/* -------------------- end Set.../Get... -------------------- */





	/* -------------------- methods for internal use only -------------------- */
	function &GetForm() {
		$loTable =& $this->GetPagedTable();
		return $loTable->GetMainForm();
	}

	function &GetTop() {
		return $this->GetContent(1);
	}

	function &GetTable() {
		$loTable =& $this->GetPagedTable();
		return $loTable->GetTable();
	}

	function &GetPagedTable() {
		return $this->GetContent(2);
	}

	function &GetHelp() {
		return $this->GetContent(3);
	}
	/* -------------------- end methods for internal use only -------------------- */





	/* -------------------- add cells/rows to table -------------------- */
	function AppendRow( $pa_Attributes, $ps_Header = FALSE ) {
		global $DEBUG;
		$this->ms_CurrentHeader = $ps_Header;
		$lo_Table =& $this->GetTable();
		if( !$ps_Header ) {
			if( $this->ms_Odd )
				$la_Attributes = array_merge( $pa_Attributes, array( "class"=>"oddrowbg" ) );
			else
				$la_Attributes = array_merge( $pa_Attributes, array( "class"=>"evenrowbg" ) );
			$this->ms_Odd ^= 1;
		}
		else
			$la_Attributes = $pa_Attributes;
		$lo_Table->AppendRow( $la_Attributes );
		
	}

	function AppendCell( $pa_Attributes ) {
		global $DEBUG;
		
		$lo_Table =& $this->GetTable();
		$lo_Row =& $lo_Table->GetContent( cc_LastElement );
		$la_Arguments = func_get_args();
		
		array_splice( $la_Arguments, 1, 0, $this->ms_CurrentHeader );
		call_user_func_array( array( &$lo_Row, "AppendCell" ), $la_Arguments );
	}
	/* -------------------- end add cells/rows to table -------------------- */





	/* -------------------- buttons -------------------- */
	// call this method only when all other rows are added
	function AppendButton( $po_Button ) {
		$lo_Table =& $this->GetTable();
		if( ! $this->ms_Buttons ) {
			$lo_Row =& $lo_Table->GetContent(0);
			$this->AppendRow( array() );
			$this->AppendCell( array( "colspan"=>$lo_Row->GetColSpan(), "align"=>"right" ) );
			$this->ms_Buttons = TRUE;
		}
		$lo_Row =& $lo_Table->GetContent( cc_LastElement );
		$lo_Cell =& $lo_Row->GetContent(0);
		$lo_Cell->AppendToContent( $po_Button );
	}
	/* -------------------- end buttons -------------------- */





	/* -------------------- hidden fields -------------------- */
	function AppendHidden( $po_Element ) {
		$la_Arguments = func_get_args();
		$lo_Form =& $this->GetForm();
		call_user_func_array( array( &$lo_Form, "AppendToContent" ), $la_Arguments );
	}
	/* -------------------- end hidden fields -------------------- */





	/* -------------------- add help -------------------- */
	function AppendHelp( $pm_Text ) {
		$lo_Help =& $this->GetHelp();
		foreach( func_get_args() as $lm_Text )
			$lo_Help->AppendToContent( new PElement( array(), is_object($lm_Text) ? $lm_Text :
						new HTMLElement( $lm_Text ) ) );
	}
	/* -------------------- end add help -------------------- */





	/* -------------------- add to top -------------------- */
	function AppendTop( $pm_Text ) {
		$lo_Top =& $this->GetTop();
		$lo_Top->AppendToContent( new PElement( array(), $pm_Text ) );
	}
	/* -------------------- end add to top -------------------- */





	/* -------------------- SetWidths -------------------- */
	function SetWidths( $ps_First ){
		$lo_Table =& $this->GetTable();
		$lo_Row =& $lo_Table->GetContent(0);
		if( is_object($lo_Row) ) {
			$la_Widths = func_get_args();
			$la_Cells =& $lo_Row->GetContent();
			for ( $i=0; $i<count($la_Widths) && $i<count($la_Cells); $i++ ) {
				if( is_null($la_Widths[$i]) )
					$la_Cells[$i]->UnsetAttribute( "width" );
				else
					$la_Cells[$i]->AppendAttributes( array( "width"=>$la_Widths[$i] ) );
			}
		}
	}
	/* -------------------- end SetWidths -------------------- */

}
?>
