<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.TagElement.php" );
include_once( dirname(__FILE__) . "/class.HTMLElement.php" );
include_once( dirname(__FILE__) . "/module.Constants.php" );





class TagWithEndElement extends TagElement {

	/* -------------------- Members -------------------- */
	var $ma_Content; // elements between start and end tags
	var $ms_Separator; // separator between elements
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function TagWithEndElement ( $ps_Tag, $pa_Attributes ) {
		$this->TagElement( $ps_Tag, $pa_Attributes );
		$this->ClearContent();
		$la_Arguments = func_get_args();
		array_splice ( $la_Arguments, 0, 2 );
		if( count($la_Arguments) )
			call_user_func_array( array( &$this, "AppendToContent" ), $la_Arguments );
		$this->SetSeparator( "\n" );
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- methods to access content -------------------- */
	function &AppendToContent( $pm_First ) {
		global $DEBUG;

		foreach( func_get_args() as $lm_Element )
			if( is_object( $lm_Element ) )
				$this->ma_Content[] = $lm_Element;
			else
				$this->ma_Content[] = new HTMLElement( $lm_Element );

		return $this->ma_Content[ count($this->ma_Content) - 1 ];

	}

	function PrependToContent( $pm_First ) {
		foreach( func_get_args() as $lm_Element )
			if( is_object( $lm_Element ) )
				array_unshift( $this->ma_Content, $lm_Element );
			else
				array_unshift( $this->ma_Content, new HTMLElement( $lm_Element ) );
	}

	function InsertToContent( $ps_Index, $pm_First ) {
		$la_Arguments = func_get_args();
		array_shift( $la_Arguments );
		$la_ToAdd = array();
		foreach( $la_Arguments as $lm_Element )
			if( is_object($lm_Element) )
				$la_ToAdd[] = $lm_Element;
			else
				$la_ToAdd[] = new HTMLElement( $lm_Element );
		array_splice( $this->ma_Content, $ps_Index, 0, $la_ToAdd );
	}

	function &GetContent( $ps_Index=NULL ) {
		global $DEBUG;
		
		if( is_null($ps_Index) )
			return $this->ma_Content;
		if( $ps_Index == cc_LastElement )
			return $this->ma_Content[ count($this->ma_Content) - 1 ];
		if($ps_Index >= 0 && $ps_Index < count($this->ma_Content) ){
			return $this->ma_Content[$ps_Index];
		} else {
			return NULL;
		}
	}

	function &SetContent( $pa_newContent, $poItem = NULL){
		if(is_array($pa_newContent)){
			$this->ma_Content = $pa_newContent;
		} elseif( is_numeric($pa_newContent) && is_object( $poItem ) ) {
			$this->ma_Content[$pa_newContent] = $poItem;
		}
		return $this->ma_Content;
	}
	
	function ClearContent() {
		$this->ma_Content = array();
	}

	function CountContent() {
		return count( $this->ma_Content );
	}
	
	/* -------------------- end methods to access content -------------------- */





	/* -------------------- Get.../Set... -------------------- */
	function SetSeparator( $ps_Separator ) {
		$this->ms_Separator = $ps_Separator;
	}

	function GetSeparator() {
		return $this->ms_Separator;
	}
	/* -------------------- end Get.../Set... -------------------- */





	/* -------------------- GetHTML & related -------------------- */
	function GetContentHTML() {

		global $DEBUG;

		$la_Result = array();
		foreach( $this->GetContent() as $lo_Element ) {
			if (method_exists($lo_Element, "GetHTML")) {
				$la_Result[] = $lo_Element->GetHTML();
			} else {
				echo "<p><b> Internal error:</b> class '" . get_class($lo_Element) ."'/'".get_class($this).
					"' has no GetHTML() method defined</p>\n";
				echo "TagWithEndElement::GetContentHTML<br><pre>\n";
				print_r($this);
				echo "</pre><hr>\n";
				
			}
		}
		return implode( $this->GetSeparator(), $la_Result );
	}

	function printContentHTML(){
		$laContent =& $this->GetContent();
		$liRet = 0;
		$lcSep = $this->GetSeparator();
		foreach( $laContent as $loElement ) {
			if( method_exists( $loElement, 'printHTML' ) ){
				if( $liRet ){
					echo $lcSep;
				}
				$liRet += $loElement->printHTML();

			}else{
				echo "<p><b> Internal error:</b> class '" . get_class($loElement) ."'/'".get_class($this).
					"' has no printHTML() method defined</p>\n";
				echo "TagWithEndElement::printContentHTML<br><pre>\n";
				print_r( $this );
				echo "</pre><hr>\n";
			}
		}
		return $liRet;
	}

	function GetHTML() {
		return "<" . $this->GetTag() . $this->GetAttributesHTML() . ">" . $this->GetContentHTML() . "</" . $this->GetTag()
			. ">";
	}

	function printHTML(){
		$lcTag = $this->GetTag();
		echo '<' . $lcTag . $this->GetAttributesHTML() . '>';
		$liRet = $this->printContentHTML();
		echo '</'. $lcTag . '>';
		return $liRet;
	}
	/* -------------------- end GetHTML & related -------------------- */

}
?>
