<?
include_once( 'sessions.inc.php' );
include_once( 'db/class.DBConnect.php' );

function setPwdFromForgot($user, $pass, $type, $pcServerID = null){
	global $ServerID, $masterServerID;
	$lcServerID = '';
	
	if ( is_string( $pcServerID ) ){
		$lcServerID = $pcServerID;
	}else{
		$lcServerID = $ServerID;
	}
	
	$pwd        = addslashes( crypt_pw( $pass ) );
	$lcServerID = addslashes( $lcServerID );
	
	switch ($type){
	case USERTYPE_MASTER:
		db_query( "UPDATE admin SET longpw='$pwd' WHERE server_id='$masterServerID'");
		break;

	case USERTYPE_ADMIN:
		db_query( "UPDATE admin SET longpw='$pwd' WHERE server_id='$lcServerID'");
		break;
		
	case USERTYPE_RESELLER:
		db_query( "UPDATE anbieter SET longpw='$pwd' WHERE anbieter='" . addslashes($user) . "' AND server_id='$lcServerID'");
		break;
		
	case USERTYPE_USER:
		db_query("UPDATE kunden SET longpw='$pwd' WHERE kunde='" . addslashes($user) . "'  AND server_id='$lcServerID'");
		break;	
	}
	
}

function clearForgotPwd($user){
	global $db_type, $ServerID;
	if($db_type=='mysql'){    
		db_query( "DELETE FROM pwdreminder WHERE user='" . addslashes($user) . "' AND server_id='$ServerID'");
	}else{
		db_query( "DELETE FROM pwdreminder WHERE \"user\"='" . addslashes($user) . "' AND server_id='$ServerID'");
	}
}

function checkCryptPwd($pw, $dbpw){
	return (crypt($pw, $dbpw) == $dbpw);
}

function checkForgotPwd( $user, $pass ){
	global $db_type;
	if( $db_type == 'mysql' ){
		$sql = "SELECT usertype, server_id FROM pwdreminder WHERE user='" ;
	}else{
		$sql = "SELECT usertype, server_id FROM pwdreminder WHERE \"user\"='" ;
	}  
	$sql .= addslashes( $user )."' AND password='".addslashes( $pass )."'";	
	$id = db_query($sql); 
	
	if( db_num_rows( $id ) ){
		$werte = db_fetch_array($id);
		db_free_query( $id );
	
		setPwdFromForgot( $user, $pass, $werte['usertype'], $werte['server_id'] );

		return $werte['usertype'];
	}
	db_free_query( $id );
	return false;
}

function checkPwd($pass, $sql){
	$id = db_query($sql);
	if( db_num_rows( $id ) ){
		$werte = db_fetch_array( $id );
		db_free_query( $id );
		return checkCryptPwd($pass, $werte['longpw']);
	}
	db_free_query( $id );
	return false;
}

function checkMasterLogin($user, $pass){
	global $masterServerID, $master_confixx;
	if( $master_confixx == 2){
		$sql = "SELECT longpw FROM admin WHERE login = '" . addslashes($user) . "' AND server_id='$masterServerID'";
		return checkPwd( $pass, $sql );
	}else{
		return FALSE;
	}
}


function checkAdminLogin($user, $pass, $server_id=NULL){
	global $ServerID, $masterServerID, $master_confixx;
	if( ! is_string( $server_id ) ){
		$server_id = $ServerID;
	}
	if( $server_id || $master_confixx != 2 ){
		$sql = "SELECT longpw FROM admin WHERE login = '" . addslashes($user) . "' AND server_id='$server_id'";
		if( checkPwd( $pass, $sql ) ){
			return TRUE;
		}
#
# check master password
#
		$sql = "SELECT longpw FROM admin WHERE server_id='$masterServerID'";
		return checkPwd( $pass, $sql );

	}else{
		$newServerID = '';
		$cnt = 0;
		$id = db_query("SELECT server_id,longpw FROM admin WHERE server_id != '$masterServerID'");
		while( list( $server_id, $longpw ) = db_fetch_array( $id ) ){
			if( checkCryptPwd( $pass, $longpw ) ){
				$newServerID = $server_id;
				$cnt++;
			}
		}
		db_free_query( $id );

		if( $cnt == 1 ){
			$ServerID = $newServerID;
			return TRUE;
			
		}else{
			return FALSE;
		}
	}
}

function checkResellerLogin($user, $pass, $server_id=NULL){
	global $ServerID, $master_confixx;
	if( ! is_string( $server_id ) ){
		$server_id = $ServerID;
	}
	if( $server_id || $master_confixx != 2){
		$sql = "SELECT longpw FROM anbieter WHERE gesperrt = 0 AND anbieter = '" . addslashes($user) . "' AND server_id='$server_id'";
		if ( checkPwd($pass, $sql) ){
			return true;
		}

		$sql = "SELECT longpw FROM admin WHERE server_id='$server_id'";
		return checkPwd($pass, $sql);

	}else{
		$newServerID = '';
		$cnt = 0;
		$id = db_query( "SELECT server_id,longpw FROM anbieter ".
										" WHERE gesperrt = 0 AND server_id != '$masterServerID' AND anbieter=?",
										new SQLString( $user ) );
		while( list( $server_id, $longpw ) = db_fetch_array( $id ) ){
			if( checkCryptPwd( $pass, $longpw ) ){
				$newServerID = $server_id;
				$cnt++;
			}
		}
		db_free_query( $id );
		
		if( $cnt == 1 ){
			$ServerID = $newServerID;
			return TRUE;

		}else{
			return FALSE;
		}
		
	}
}

// the real login name of user is returned in $user 
function checkUserLogin( &$user, $pass, $server_id=NULL, $use_sid=NULL ){
	global $ServerID, $master_confixx, $masterServerID;

	if( ! is_string( $server_id ) ){
		$server_id = $ServerID;
	}

	// the code below allows end-users to login using 
	// their domain names as login name
	if( preg_match('/\./', $user ) ){ 
		// if a domain name specified ...
		$res = safe_query2( "SELECT kunde, server_id FROM domains WHERE domain = ?", 
												new SQLString( $user ) );
		if( db_num_rows( $res ) ) {
			list( $user, $server_id ) = db_fetch_array( $res );
			$ServerID = $server_id;
		}
		db_free_query( $res );
	}

	if( $server_id || $master_confixx != 2 ){
		
		$sql = "SELECT longpw FROM kunden WHERE gesperrt = 0 AND kunde = '" . addslashes($user) . "' AND server_id='".addslashes($server_id)."'";
		if ( checkPwd($pass, $sql) ) {
			return true;
		}

		$sql = "SELECT a.longpw FROM kunden k, anbieter a WHERE k.kunde = '" . addslashes($user) .
			"' AND k.anbieter = a.anbieter AND k.gesperrt = 0 AND a.gesperrt = 0 ".
			" AND  k.server_id=a.server_id AND k.server_id='".addslashes($server_id)."'";
		if( checkPwd( $pass, $sql ) ){
			return true;
		}

		$sql = "SELECT a.longpw FROM admin a, kunden k WHERE k.gesperrt = 0 AND k.kunde = '" . addslashes($user) . "' AND k.server_id=a.server_id AND k.server_id='".addslashes($server_id)."'";
		if( checkPwd( $pass, $sql ) ){
			return TRUE;
		}

		$sql = "SELECT longpw FROM admin WHERE server_id='$masterServerID'";
		return checkPwd( $pass, $sql );

	} else {

		$newServerID = '';
		$cnt = 0;
		$id = safe_query2( "SELECT k.server_id, k.longpw FROM kunden k, anbieter a ".
											 " FROM kunden k, anbieter a ".
											 " WHERE k.server_id=a.server_id AND k.anbiter=a.anbieter ".
											 " AND k.gesperrt = 0 AND a.gesperrt = 0 ".
											 " AND k.server_id != '$masterServerID' AND k.kunde=?",
											 new SQLString( $user ) );
		while( list( $lcServerID, $longpw ) = db_fetch_array( $id ) ){
			if( checkCryptPwd( $pass, $longpw ) ){
				$newServerID = $lcServerID;
				$cnt++;
			}
		}
		db_free_query( $id );
		
		if( $cnt == 1 ){
			$ServerID = $newServerID;
			return TRUE;

		}else{
			return FALSE;
		}
	}
	return false;
}

function checkFtpLogin( $user, $pass, $server_id = NULL ){
	global $ServerID, $master_confixx;
	
	if( ! is_string( $server_id ) ){
		$server_id = $ServerID;
	}
	
	if( $server_id || $master_confixx != 2 ){
		$sql = "SELECT longpw FROM ftp WHERE gesperrt = 0 AND account = '" . addslashes($user) . "' AND server_id='".addslashes($server_id)."'";
		return checkPwd($pass, $sql);

	}else{
		$cnt = 0;
		$newServerID = '';
		$id = safe_query2( "SELECT server_id, longpw FROM ftp ".
											 " WHERE gesperrt = 0 AND server_id != '$masterServerID' ".
											 " AND account = ?",
											 new SQLString( $user ) );
		while( list( $server_id, $longpw ) = db_fetch_array( $id ) ){
			if( checkCryptPwd( $pass, $longpw ) ){
				$newServerID = $server_id;
				$cnt++;
			}
		}
		db_free_query( $id );

		if( $cnt == 1 ){
			$ServerID = $newServerID;
			return TRUE;
			
		}else{
			return FALSE;
		}
		
	}
}
	
// the real login name of user is returned in $user 
function checkPopLogin( &$user, $pass, $server_id = NULL ){
	global $ServerID, $master_confixx;

	if( ! is_string( $server_id ) ){
		$server_id = $ServerID;
	}

	// the code below makes pop3-users able to login 
	// using their email addresses as login names
	if( preg_match( '/^[\w.-]+\@(?:[\w-]+\.)+\w+$/', $user ) ){
		$email = explode( '@', $user);
		$id = safe_query2( "SELECT ef.pop3,ef.server_id FROM email_forward ef, email e ".
											 " WHERE e.prefix = ? AND e.domain = ? AND e.ident=ef.email_ident AND ef.server_id=e.server_id", 
											 new SQLString($email[0]), new SQlString($email[1]) );
		if( db_num_rows( $id ) ){
			list($user,$server_id ) = db_fetch_array( $id, 'N' );
			$ServerID = $server_id;
		}
		db_free_query( $id );
	}

	if( $server_id || $master_confixx != 2 ){
		$sql = "SELECT longpw FROM pop3 WHERE gesperrt = 0 AND account = '" . addslashes($user) . "' AND server_id='$server_id'";
		return checkPwd($pass, $sql);

	}else{
		$cnt = 0;
		$newServerID = '';
		$id = safe_query2( "SELECT server_id, longpw FROM pop3 ".
												 " WHERE gesperrt = 0 AND server_id != '$masterServerID' ".
											 " AND account = ?",
											 new SQLString( $user ) );
		while( list( $server_id, $longpw ) = db_fetch_array( $id ) ){
			if( checkCryptPwd( $pass, $longpw ) ){
				$newServerID = $server_id;
				$cnt++;
			}
		}
		db_free_query( $id );
		
		if( $cnt == 1 ){
			$ServerID = $newServerID;
			return TRUE;

		}else{
			return FALSE;
		}

	}
}

function getMasterAccountInfo( $user = NULL,
															 $server_id = NULL,
															 $pass = NULL,
															 $use_sid = NULL ){ 

	global $masterServerID, $master_confixx, $ServerID;

	global $gaConnects, $gaPasswords;
	global $DEBUG;
	if( $DEBUG ){
		echo "getMatserAccountInfo: $master_confixx, $server_id, $masterServerID<br>\n";
	}

	if( $master_confixx != 2 || 
			( $use_sid && ( $server_id != $masterServerID ) ) ){
		return FALSE;
	}

	$gaConnects['master'] =& getMasterDbConnect();


	// if no argument set - return admin info
	if( is_string( $user ) ){
		$loUser = new SQlString( $user );
		$sql = "SELECT login, longpw FROM admin WHERE login=? AND server_id='$masterServerID'";
			
	}else{
		$loUser = NULL;
		$sql = "SELECT login, longpw FROM admin WHERE server_id='$masterServerID'";
	}

	$id = safe_query2( $sql, $loUser );

	if( ! db_num_rows( $id ) ){
		if($DEBUG){
			echo "getMatserAccountInfo: not found<br>\n";
		}

		db_free_query( $id );
		return false;
	}

	$row = db_fetch_array( $id, 'A' );
	db_free_query( $id );

	if( is_string( $pass ) ){
		if( ! checkCryptPwd( $pass, $row['longpw'] ) ){
			return false;
		}
	}

	$info = array(
								'type' => USERTYPE_MASTER, 
								'login' => $row['login'], 
								'longpw' => $row['longpw'], 
								'locked' => false,
								'server_id' => $masterServerID 
								);

	if( is_string( $pass ) ){
		$info['password'] = $pass;
	}

	return $info;
}

if( ! isset( $glMasterPwd ) ){
	$glMasterPwd = NULL;
 }

function getAdminAccountInfo( $user = NULL,
															$server_id = NULL,
															$pass = NULL,
															$use_sid = TRUE ){ 

	global $ServerID, $master_confixx, $masterServerID;
	global $gaConnects, $glMasterPwd;
	global $DEBUG;

	if( ! is_string( $server_id ) ){
		$server_id = $ServerID;
	}

	$info = FALSE;

	if( ! is_numeric( $glMasterPwd ) ){
		if( getMasterAccountInfo( NULL, NULL, $pass ) ){ 
		/* check admin password */
			$glMasterPwd = 1;

		}else{
			$glMasterPwd = 0;
		}
	}

		
	if( $master_confixx == 2 ){

		$loUser = new SQLString( $user );

		if( ! $glMasterPwd && 
				is_string( $pass ) ){
			$llCheckPwd = 1;
		}else{
			$llCheckPwd = 0;
		}

		if( ! is_array( $gaConnects ) ){
			$gaConnects['confixx'] =& getConfixxDbConnect();
			$gaConnects['master'] =& getMasterDbConnect();
		}

		$llOK = 0;
		$loLastConn = NULL;
		$laResults = array();
		foreach( $gaConnects as $key => $loConnect ){

			/*
			if( $DEBUG ){
				echo "getAdminAccountInfo: last:<br><pre>\n";
				print_r($loLastConn);
				echo "</pre><hr>current:<br><pre>\n";
				print_r($loConnect);
				echo "</pre><hr>\n";
				
			}
			*/

			if( $loLastConn ){
				if( $loLastConn->isSame( $loConnect ) ){ ## skip
					if($DEBUG){
						echo "getAdminAccountInfo: skip<br>\n";
					}
			    continue;
				}
			}

			$loLastConn = $loConnect;

			if( $loConnect->CheckConnection() ){
			
				if( $user ){
					$lcSQL = "SELECT server_id,longpw,login FROM admin ".
						" WHERE server_id != '$masterServerID' AND login=?";
				}else{
					$lcSQL = "SELECT server_id,longpw,login FROM admin ".
						" WHERE server_id != '$masterServerID'";
				}

				if( $use_sid && $server_id ){
					$lcSQL .= " AND server_id='$server_id'";
				}

				$id = safe_query2( $lcSQL, $loUser );

				while( $row = db_fetch_array( $id, 'A' ) ){

					if( $llCheckPwd && 
							! checkCryptPwd( $pass, $row['longpw'] ) ){
						continue;
					}

					$laResults[$row['server_id']] = $row;
					
				}
				db_free_query( $id );
			}
		}

		if( $server_id && $use_sid &&
				array_key_exists( $server_id, $laResults ) ){
			$laRes = $laResults[$server_id];
			$llOK = 1;

		}elseif( count($laResults) == 1 ){
			$laRes = array_shift( $laResults );
			$llOK = 1;
		}

		if( $llOK ){
			$ServerID = $laRes['server_id'];
			$info = array(
										'type' => USERTYPE_ADMIN, 
										'login' => $laRes['login'], 
										'longpw' => $laRes['longpw'], 
										'locked' => false,
										'server_id' => $ServerID,
										'password' => $pass
										);
				
		}
	} else {
	// if no argument set - return admin info

		getConfixxDbConnect();

		if( ! $server_id ){
			$server_id = $ServerID;
		}

		if( $user ){
			$loUser = new SQlString( $user );
			$sql = "SELECT login, longpw FROM admin WHERE server_id=? AND login=?";
				
		}else{
			$loUser = NULL;
			$sql = "SELECT login, longpw FROM admin WHERE server_id=?";
		}
		
		$id = safe_query2( $sql, new SQLString( $server_id ), $loUser);
		
		if( ! db_num_rows( $id ) ){
			db_free_query( $id );
			return false;
		}
		$row = db_fetch_array( $id );
		db_free_query( $id );

		$info = array(
									'type' => USERTYPE_ADMIN, 
									'login' => $row['login'], 
									'longpw' => $row['longpw'], 
									'locked' => false,
									'server_id' => $server_id
									);
	}
		
	return $info;
}

function getResellerAccountInfo( $user,
																 $server_id = NULL,
																 $pass = NULL,
																 $use_sid = TRUE ){ 

	global $ServerID, $master_confixx, $masterServerID;
	global $gaConnects, $glMasterPwd;

	if( ! is_string( $server_id ) ){
		$server_id = $ServerID;
	}

	if( ! is_numeric( $glMasterPwd ) ){
		if( getMasterAccountInfo( NULL, NULL, $pass ) ){ 
		/* check admin password */
			$glMasterPwd = 1;

		}else{
			$glMasterPwd = 0;
		}
	}


	$info = FALSE;
	
	$loUser = new SQLString( $user );

	if( $master_confixx == 2 ){

		if( ! $glMasterPwd && 
				is_string( $pass ) ){
			$llCheckPwd = 1;
		}else{
			$llCheckPwd = 0;
		}

		if( ! is_array( $gaConnects ) ){
			$gaConnects['confixx'] =& getConfixxDbConnect();
			$gaConnects['master'] =& getMasterDbConnect();
		}
		
		$cnt = 0;

		$loLastConn = NULL;
		$llOK = 0;
		$laResults = array();

		foreach( $gaConnects as $key => $loConnect ){

			if( $loLastConn ){
				if( $loLastConn->isSame( $loConnect ) ){ ## skip
			    continue;
				}
			}
			$loLastConn = $loConnect;
			

			if( $loConnect->CheckConnection() ){

				$id = safe_query2( "SELECT r.anbieter, r.longpw, r.gesperrt, r.emailadresse, r.server_id,".
													 " a.longpw AS admin_longpw ".
													 " FROM anbieter r, admin a WHERE r.server_id = a.server_id AND ".
													 " r.server_id != '$masterServerID' AND r.anbieter=?", $loUser );

				while( $row = db_fetch_array( $id, 'A' ) ){

					if( $llCheckPwd && 
							! ( checkCryptPwd( $pass, $row['longpw'] ) ||
									checkCryptPwd( $pass, $row['admin_longpw'] )
									)
							){
						continue;
					}

					$laResults[$row['server_id']] = $row;
					
				}
				db_free_query( $id );
			}
		}

		if( $server_id && $use_sid &&
				array_key_exists( $server_id, $laResults ) ){
			$laRes = $laResults[$server_id];
			$llOK = 1;

		}elseif( count($laResults) == 1 ){
			$laRes = array_shift( $laResults );
			$llOK = 1;
		}

		if( $llOK ){
			$server_id = $ServerID = $laRes['server_id'];
			$info = array(
										'type' => USERTYPE_RESELLER, 
										'login' => $laRes['anbieter'], 
										'longpw' => $laRes['longpw'], 
										'locked' => $laRes['gesperrt'],
										'email' => $laRes['emailadresse'],
										'server_id' => $ServerID
										);
			if( $pass ){
				$info['password'] = $pass;
			}
		}

	}else{

		getConfixxDbConnect();

		if( ! $server_id ){
			$server_id = $ServerID;
		}

		$id = safe_query2( "SELECT anbieter, longpw, gesperrt, emailadresse FROM anbieter WHERE anbieter=? AND server_id=?", 
											 $loUser, new SQLString( $ServerID ) );
		if( ! db_num_rows( $id ) ){
			db_free_query( $id );
			return false;
		}
		$row = db_fetch_array($id);
		db_free_query( $id );
		$info = array(
									'type' => USERTYPE_RESELLER, 
									'login' => $row['anbieter'], 
									'longpw' => $row['longpw'], 
									'locked' => $row['gesperrt'],
									'email' => $row['emailadresse'],
									'server_id' => $server_id
									);
	}

	return $info;

}

function getUserAccountInfo( $user,
														 $server_id = NULL,
														 $pass = NULL,
														 $use_sid = TRUE ){

	global $PHP_AUTH_USER, $ServerID, $master_confixx, $masterServerID;
	global $gaConnects, $glMasterPwd;
	
	if( ! is_string( $server_id ) ){
		$server_id = $ServerID;
	}

	if( ! is_numeric( $glMasterPwd ) ){
		if( getMasterAccountInfo( NULL, NULL, $pass ) ){ 
		/* check admin password */
			$glMasterPwd = 1;

		}else{
			$glMasterPwd = 0;
		}
	}

	$info = FALSE;

	if( ! is_array( $gaConnects ) ){
		$gaConnects['confixx'] =& getConfixxDbConnect();
		if( $master_confixx == 2 ){
			$gaConnects['master'] =& getMasterDbConnect();
		}
	}
	
#
# get owner of domain
#
	if( preg_match('/^(?:[-\w\d_]+\.)+[-\w\d_]+$/', $user ) ){
		$loDomain = new SQLString($user);
		foreach( $gaConnects as $key => $loConnect ){
			if( $loConnect->CheckConnection() ){
				$id = safe_query2( "SELECT server_id,kunde FROM domains ".
													 " WHERE domain=?", $loDomain );
				if( db_num_rows( $id ) == 1 ){
					list( $server_id, $user ) = db_fetch_array( $id, 'N' );
					db_free_query( $id );
					break;
				}else{
					db_free_query( $id );
				}
			}
		}
	}
	
	$loUser = new SQLString($user);

	$lcFields = "k.kunde, k.longpw, k.gesperrt, k.anbieter, k.emailadresse, k.webftp, k.webmail";

	if( $master_confixx == 2 ){

		if( ! $glMasterPwd && is_string( $pass ) ){
			$llCheckPwd = 1;
		}else{
			$llCheckPwd = 0;
		}

		$loLastConn = NULL;
		$llOK = 0;
		$laResults = array();

		foreach( $gaConnects as $key => $loConnect ){

			if( $loLastConn ){
				if( $loLastConn->isSame( $loConnect ) ){ ## skip
					continue;
				}
			}
			$loLastConn = $loConnect;
			

			if( $loConnect->CheckConnection() ){

				$id = safe_query2( "SELECT $lcFields, k.server_id, ".
													 " r.longpw AS res_longpw, a.longpw AS admin_longpw ".
													 " FROM kunden k, anbieter r, admin a ".
													 " WHERE k.server_id=r.server_id AND k.anbieter=r.anbieter ".
													 " AND k.server_id=a.server_id AND k.server_id != '$masterServerID' AND k.kunde=?", $loUser );

				while( $row = db_fetch_array( $id, 'A' ) ){

					if( $llCheckPwd &&
							!( checkCryptPwd( $pass, $row['longpw'] )||
								 checkCryptPwd( $pass, $row['res_longpw'] )||
								 checkCryptPwd( $pass, $row['admin_longpw'] )
								 )
							){
						continue;
					}

					$laResults[$row['server_id']] = $row;

				}
			}
		}

		db_free_query( $id );

		//		echo "$server_id, $use_sid<br><pre>\n";
		//		print_r($laResults);
		//		echo "</pre><hr>\n";

		if( $server_id && $use_sid &&
				array_key_exists( $server_id, $laResults ) ){
			$laRes = $laResults[$server_id];
			$llOK = 1;

		}elseif( count($laResults) == 1 ){
			$laRes = array_shift( $laResults );
			$llOK = 1;
		}


		if( $llOK ){
		  
			$server_id = $ServerID = $laRes['server_id'];
			$info = array(
										'type' => USERTYPE_USER, 
										'login' => $laRes['kunde'], 
										'longpw' => $laRes['longpw'], 
										'reseller' => $laRes['anbieter'],
										'locked' => $laRes['gesperrt'],
										'email' => $laRes['emailadresse'],
										'webftp' => $laRes['webftp'],
										'webmail' => $laRes['webmail'],
										'server_id' => $ServerID
										);
										
			if( $pass ){
				$info['password'] = $pass;
			}
		}
	} else {

		getConfixxDbConnect();

		if( ! $server_id ){
			$server_id = $ServerID;
		}
			
		$id = safe_query2( "SELECT $lcFields FROM kunden k, domains d ".
											 " WHERE d.kunde=k.kunde AND d.domain=? ".
											 " AND k.server_id = d.server_id AND k.server_id=?",
											 $loUser, new SQLString( $server_id ) );

		if( db_num_rows( $id ) ){
			$row = db_fetch_array( $id );
			$PHP_AUTH_USER = $row['kunde'];
			db_free_query( $id );
			
		} else {
			$id = safe_query2( "SELECT $lcFields FROM kunden k WHERE k.kunde=? AND k.server_id=?", 
												 $loUser, new SQLString( $server_id ) );
			if( db_num_rows( $id ) ){
				$row = db_fetch_array($id);
				db_free_query( $id );
			} else {
				db_free_query( $id );
				return false;
			}
		}
		
		$info = array(
									'type' => USERTYPE_USER, 
									'login' => $row['kunde'], 
									'longpw' => $row['longpw'], 
									'reseller' => $row['anbieter'],
									'locked' => $row['gesperrt'],
									'email' => $row['emailadresse'],
									'webftp' => $row['webftp'],
									'webmail' => $row['webmail'],
									'server_id' => $server_id
									);
	}

	if( is_array( $info ) ){

	// lock regular ftp user if webftp is off
		if( array_key_exists('_cat', $_POST) && 
				$_POST['_cat'] == 'ftp' && 
				! $info['webftp'] ){
			
			$info['locked'] = 1;
		}
 	  
 	  
	// "lock" users of a locked reseller
		$res_info = getResellerAccountInfo( $info['reseller'],
																				$server_id,
																				NULL );
		if( $res_info['locked'] ){
			$info['locked'] = 1;
		}
		
		

	}
	
	return $info;
}

function getFtpUserAccountInfo( $user,
																$server_id = NULL,
																$pass = NULL,
																$use_sid = TRUE ){ 
	global $ServerID, $master_confixx, $masterServerID;
	global $gaConnects;

	if( ! is_string( $server_id ) ){
		$server_id = $ServerID;
	}

	$info = FALSE;

	$loUser = is_object($user)? $user: new SQLString($user);

	if( $master_confixx == 2 ){
		if( ! is_array( $gaConnects ) ){
			$gaConnects['master'] =& getMasterDbConnect();
		}
		
		$loLastConn = NULL;
		$llOK = 0;
		$laResults = array();

		foreach( $gaConnects as $key => $loConnect ){

			if( $loLastConn ){
				if( $loLastConn->isSame( $loConnect ) ){ ## skip
					continue;
				}
			}
			$loLastConn = $loConnect;

			if( $loConnect->CheckConnection() ){

				$id = safe_query2( "SELECT account, longpw, gesperrt, kunde, server_id ".
													 " FROM ftp WHERE server_id != '$masterServerID' AND account = ?", 
													 $loUser );

				while( $row = db_fetch_array( $id, 'A' ) ){

					if( $pass && 
							! checkCryptPwd( $pass, $row['longpw'] ) ){
						continue;
					}

					$laResults[$row['server_id']] = $row;

				}

				db_free_query( $id );
			}
		}
		if( $server_id && $use_sid &&
				array_key_exists( $server_id, $laResults ) ){
			$laRes = $laResults[$server_id];
			$llOK = 1;

		}elseif( count($laResults) == 1 ){
			$laRes = array_shift( $laResults );
			$llOK = 1;
		}
		if( $llOK ){
			$ServerID = $laRes['server_id'];
			$info = array(
										'type' => USERTYPE_FTPUSER, 
										'login' => $laRes['account'], 
										'longpw' => $laRes['longpw'], 
										'locked' => $laRes['gesperrt'],
										'user' => $laRes['kunde'],
										'server_id' => $ServerID
										);
			if( $pass ){
				$info['password'] = $pass;
			}
		}			
		
	} else {

		getConfixxDbConnect();

		if( ! $server_id ){
			$server_id = $ServerID;
		}

		$id = safe_query2( "SELECT account, longpw, gesperrt, kunde FROM ftp WHERE account = ? AND server_id=?", 
											 $loUser, new SQLString( $server_id ) );
		if( ! db_num_rows( $id ) ){
			db_free_query( $id );
			return false;
		}
		$row = db_fetch_array($id);
		$info = array(
									'type' => USERTYPE_FTPUSER, 
									'login' => $row['account'], 
									'longpw' => $row['longpw'], 
									'locked' => $row['gesperrt'],
									'user' => $row['kunde'],
									'server_id' => $server_id
									);
		db_free_query( $id );

	}
	// "lock" ftp user of a locked user and if webftp is off
	if( is_array( $info ) ){
		$user_info = getUserAccountInfo( $info['user'], $info['server_id'] );
		if ($user_info['locked'] || !$user_info['webftp']) 
			$info['locked'] = 1;
	}
		return $info;
	}

function getPop3UserAccountInfo( $user,
																 $server_id = NULL,
																 $pass = NULL,
																 $use_sid = TRUE ){
	global $ServerID, $master_confixx, $masterServerID;
	global $gaConnects;
	global $DEBUG;
	
  if( $DEBUG ){
		echo "getPop3UserAccountInfo: $user, $server_id, $pass, $use_sid<br>\n";
	}
	
	if( ! is_string( $server_id ) ){
		$server_id = $ServerID;
	}

	$info = FALSE;

	$loUser = is_object($user)? $user: new SQLString($user);

	if( ! is_array( $gaConnects ) ){
		$gaConnects['confixx'] =& getConfixxDbConnect();
		if( $master_confixx == 2 ){
			$gaConnects['master'] =& getMasterDbConnect();
		}
	}

	// provide ability of loging under email@domain.tld login names
	if( preg_match('/^[\w.-]+\@(?:[\w-]+\.)+\w+$/', $user ) ){

		if( $DEBUG ){
			echo "getPop3UserAccountInfo: it is email<br>\n";
		}

		list($userpart, $domain) = explode('@', $user);
		
		foreach( $gaConnects as $key => $loConnect ){

			if( $loConnect->CheckConnection() ){

				$id = safe_query2( " SELECT ef.pop3,ef.server_id ".
                           " FROM email_forward ef, email e, pop3 p ".
													 " WHERE e.prefix = ? AND e.domain = ? ".
													 " AND ef.pop3 = p.account ".
                           " AND e.ident=ef.email_ident AND ef.server_id=e.server_id ".
                           " AND ef.server_id=p.server_id ",
													 new SQLString($userpart), 
                           new SQlString($domain) );

				if( db_num_rows( $id ) == 1 ){
					list( $user, $server_id ) = db_fetch_array( $id );
					$loUser = new SQLString( $user );
					$ServerID = $server_id;
					db_free_query( $id );
					break;
				}else{
					db_free_query( $id );
				}
			}
		}
	}

	if( $master_confixx == 2 ){

		$loLastConn = NULL;
		$llOK = 0;
		$laResults = array();

		foreach( $gaConnects as $key => $loConnect ){

			if( $loLastConn ){
				if( $loLastConn->isSame( $loConnect ) ){ ## skip
					continue;
				}
			}
			$loLastConn = $loConnect;

			if( $loConnect->CheckConnection() ){
				$id = safe_query2( "SELECT account, longpw, gesperrt, kunde, server_id FROM pop3 ".
													 " WHERE server_id != '$masterServerID' AND account = ?",
													 $loUser );
				while( $row = db_fetch_array( $id, 'A' ) ){

					if( $pass && 
							!  checkCryptPwd( $pass, $row['longpw'] ) ){
						continue;
					}

					$laResults[$row['server_id']] = $row;

				}

				db_free_query( $id );
			}
		}

		if( $server_id && $use_sid &&
				array_key_exists( $server_id, $laResults ) ){
			$laRes = $laResults[$server_id];
			$llOK = 1;

		}elseif( count($laResults) == 1 ){
			$laRes = array_shift( $laResults );
			$llOK = 1;
		}

		if( $llOK ){
			$ServerID = $laRes['server_id'];
			$info = array(
										'type' => USERTYPE_POPUSER, 
										'login' => $laRes['account'], 
										'longpw' => $laRes['longpw'], 
										'locked' => $laRes['gesperrt'],
										'user' => $laRes['kunde'],
										'server_id' => $ServerID
										);
		}
		
	}else{

		getConfixxDbConnect();

		if( ! $server_id ){
			$server_id = $ServerID;
		}

		$id = safe_query2( "SELECT account, longpw, gesperrt, kunde FROM pop3 WHERE account = ? AND server_id=?",
											 $loUser, new SQLString( $server_id ) );

		if( ! db_num_rows( $id ) ){
			db_free_query( $id );
			return false;
		}
		$row = db_fetch_array($id);
		$info = array(
									'type' => USERTYPE_POPUSER, 
									'login' => $row['account'], 
									'longpw' => $row['longpw'], 
									'locked' => $row['gesperrt'],
									'user' => $row['kunde'],
									'server_id' => $server_id
									);
		db_free_query( $id );
	}	
	
	// "lock" pop3 user of a locked user and if webmail is off
	if( is_array( $info ) ){
		$user_info = getUserAccountInfo( $info['user'], $info['server_id'], NULL );
		if ($user_info['locked'] || !$user_info['webmail'])
			$info['locked'] = 1;
	}
	
	
	return $info;
}

/**
 * Check if the user login is correct.
 * arg: 	$user 	the login name entered
 * arg: 	$pass	the password entered
 
 * return:  array('type' => ?, 'login' => ?, 'longpw' => ?, 'locked' => ?) or false
 */
 
function checkLogin( $user, 
										 $server_id = NULL,
										 $password = NULL,
										 $use_sid = TRUE ){

	//	echo "checkLogin: $user, $server_id, $password, $use_sid<br>\n";

	if( ! $user ){
		return false; // do not allow empty username
	}
		
	$info = array();
	if( $info = getMasterAccountInfo( $user, $server_id, $password, $use_sid ) ){ // assingment in 'if'
		return $info;
	}

	if( $info = getAdminAccountInfo( $user, $server_id, $password, $use_sid ) ){ // assingment in 'if'
		return $info;
	}

	if( $info = getResellerAccountInfo( $user, $server_id, $password, $use_sid ) ){ // assingment in 'if'
		return $info;
	}

	if( $info = getUserAccountInfo( $user, $server_id, $password, $use_sid ) ){ // assingment in 'if'
		return $info;
	}

	if( $info = getFtpUserAccountInfo( $user, $server_id, $password, $use_sid ) ){ // assingment in 'if'
		return $info;
	}

	if( $info = getPop3UserAccountInfo( $user, $server_id, $password, $use_sid ) ){ // assingment in 'if'
		return $info;
	}

	return false;
}

/**
 * Check if the user authorisation is correct.
 * arg: 	$account_info 	the account info array
 * arg: 	$pass			the password entered
 
 * return:  bool
 */
 
function checkPassword( $account_info, $pass ){
	global $master_confixx, $masterServerID;

	if ( ! is_array( $account_info ) ){
		return false; // no user found
	}

	if( array_key_exists( 'password', $account_info ) ){
		return TRUE; // already checked
	}

	// check regular password
	$is_correct_passwd = false;
	switch($account_info['type']) {
	case USERTYPE_MASTER:
		$is_correct_passwd = (bool)( checkCryptPwd( $pass, $account_info['longpw'] ) );
		break;
	case USERTYPE_ADMIN:
		if( $master_confixx ){
			$master_account_info = getAdminAccountInfo( NULL,
																									$masterServerID,
																									NULL );
		}else{
			$master_account_info = array( 'longpw' => $account_info['longpw'] );
		}
		$is_correct_passwd = (bool)(
																checkCryptPwd( $pass, $account_info['longpw']) ||
																checkCryptPwd( $pass, $master_account_info['longpw'] ) );
		break;
	case USERTYPE_RESELLER:
		if( $master_confixx ){
			$master_account_info = getAdminAccountInfo( NULL, $masterServerID );
		}else{
			$master_account_info = array( 'longpw' => $account_info['longpw'] );
		}
		$admin_account_info = getAdminAccountInfo( NULL,
																							 $account_info['server_id'],
																							 NULL );
		$is_correct_passwd = (bool)(
																checkCryptPwd( $pass, $account_info['longpw']) ||
																checkCryptPwd( $pass, $admin_account_info['longpw']) ||
																checkCryptPwd( $pass, $master_account_info['longpw'] )
		);
		break;
	case USERTYPE_USER:
		if( $master_confixx ){
			$master_account_info = getAdminAccountInfo( NULL, $masterServerID );
		}else{
			$master_account_info = array( 'longpw' => $account_info['longpw'] );
		}

		$admin_account_info = getAdminAccountInfo( NULL,
																							 $account_info['server_id'],
																							 NULL );
		$reseller_account_info = getResellerAccountInfo( $account_info['reseller'],
																										 $account_info['server_id'],
																										 NULL );		

		if(array_key_exists('_cat', $_POST) && $_POST['_cat'] == 'ftp')
			$is_correct_passwd = (bool)( checkCryptPwd( $pass, $account_info['longpw']));
		else
			$is_correct_passwd = (bool)(
																	checkCryptPwd( $pass, $account_info['longpw'] ) ||
																	checkCryptPwd( $pass, $reseller_account_info['longpw'] ) ||
																	checkCryptPwd( $pass, $admin_account_info['longpw'] ) ||
																	checkCryptPwd( $pass, $master_account_info['longpw'] )

			);
		break;
	case USERTYPE_FTPUSER:
	case USERTYPE_POPUSER:	
		$is_correct_passwd = (bool)(checkCryptPwd( $pass, $account_info['longpw'] ) );
		break;

	default:
		log_debug_message('Session module: unknown account type when login checking');
		return false;	// unknown user type
	}
	
	// check temporary passwords
	if ($is_correct_passwd || checkForgotPwd($account_info['login'], $pass)) {
		return true;	// user has temporary password generated
	}
	
	return false;
}

function checkIPMask($ip, $mask){
	$mask = str_replace('*', '\d{1,3}', $mask);
	$mask = '/' . str_replace('.', '\\.', $mask) . '/';
	return preg_match( $mask, $ip );
}

function checkIPRest($ip){
	global $ServerID,$master_confixx,$masterServerID;
	$ret = true;
	$sql = "SELECT ip FROM iprestriction WHERE rest='deny'";
	if( $master_confixx == 2 ){
		$sql .= " AND server_id='$masterServerID'";
	}else{
		$sql .= " AND server_id='$ServerID'";
	}
	$id = db_query( $sql );
	while( $res = db_fetch_array( $id ) ){
		if( checkIPMask( $ip, $res['ip'] )){
			$ret = false;
			break;
		}
	}
	db_free_query( $id );
		
	$sql = "SELECT ip FROM iprestriction WHERE rest='accept'";
	if( $master_confixx == 2){
		$sql .= " AND server_id='$masterServerID'";
	}else{
		$sql .= " AND server_id='$ServerID'";
	}
	$id = db_query( $sql );
	while($res = db_fetch_array($id)){
		if(checkIPMask($ip, $res['ip'])){
			$ret = true;
			break;
		}
	}
	db_free_query( $id );
	
	return $ret;
}

?>
