<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/class.User.php" );
include_once ( dirname(__FILE__) . "/module.Database.php" );





define ( "cc_RequestOK", 1 );
define ( "cc_RequestAbort", 2 );
define ( "cc_RequestError", 3 );





/* -------------------- ff_AcceptRequest -------------------- */
function ff_AcceptRequest ( $ps_ID, $pa_Request, $pa_Reseller, $pa_Admin, &$po_User ) {
  global $ServerID;

  $lo_DB =& get_db_connection();
	if ( ! $pa_Reseller["webshop"] ) {
		message ( ERROR, ltext("webshop_requests_noperm_error") );
		return cc_RequestAbort;
	}

	if ( $pa_Request["status"]=="accepted" ) {
		message ( ERROR, ltext ( "webshop_requests_accepted_error", $pa_Request["firstname"], $pa_Request["name"],
					$pa_Request["emailadresse"] ) );
		return cc_RequestError;
	}

	if ( $pa_Request["status"]=="declined" ) {
		message ( ERROR, ltext ( "webshop_requests_declined_error", $pa_Request["firstname"], $pa_Request["name"],
					$pa_Request["emailadresse"] ) );
		return cc_RequestError;
	}

	if ( !strlen($pa_Request["emailtext"]) || !strlen($pa_Request["emailemailadresse"]) ) {
		$lo_Query =& $lo_DB->Select( "SELECT * FROM angebote WHERE server_id='$ServerID' AND ident = " . db_full_quote($pa_Request["aident"]) );
		$la_EMail =& $lo_Query->nextrow();
		if ( !$la_EMail || !strlen($la_EMail["emailtext"]) || !strlen($la_EMail["emailemailadresse"]) ) {
			if ( !strlen($pa_Reseller["emailtext"]) || !strlen($pa_Reseller["emailemailadresse"]) ) {
				message ( ERROR, ltext ( "webshop_requests_email_error", $pa_Request["firstname"], $pa_Request["name"],
							$pa_Request["emailadresse"] ) );
				return cc_RequestError;
			}
			$la_EMail = $pa_Reseller;
		}
	}
	else
		$la_EMail = $pa_Request;

	if ( is_null($po_User) ) {
		$po_User = new User();
		$po_User->SetReportErrors ( FALSE );
		$po_User->InitializeServices ($pa_Reseller);
		$po_User->InitializePersonal ();
	}

	$po_User->SetServicesData ( $pa_Request );
	$po_User->FixTraffic();
	if ( !$po_User->ValidateServices() ) {
		message ( ERROR, ltext ( "webshop_requests_services_error", $pa_Request["firstname"], $pa_Request["name"],
					$pa_Request["emailadresse"] ) );
		return cc_RequestError;
	}

	$po_User->SetPersonalData ( $pa_Request );
	if ( !$po_User->ValidatePersonal() ) {
		message ( ERROR, ltext ( "webshop_requests_personal_error", $pa_Request["firstname"], $pa_Request["name"],
					$pa_Request["emailadresse"] ) );
		return cc_RequestError;
	}

	$po_User->InitializeIP();

	$po_User->InitializeDomains( "SELECT requesteddomain.*, regrequest.dns FROM requesteddomain, regrequest WHERE
			regrequest.server_id='$ServerID' AND requesteddomain.server_id='$ServerID' AND requesteddomain.regrequestid = " . db_full_quote($pa_Request["id"]) . " AND regrequest.id = " .
			db_full_quote($pa_Request["id"]) );
	if ( !$po_User->ValidateDomains ( $pa_Reseller ) ) {
		message ( ERROR, ltext ( "webshop_requests_domains_error", $pa_Request["firstname"], $pa_Request["name"],
					$pa_Request["emailadresse"] ) );
		return cc_RequestError;
	}

	if ( !$po_User->ValidateRegistration ( $pa_Reseller ) ) {
		message ( ERROR, ltext ( "webshop_requests_reg_error", $pa_Request["firstname"], $pa_Request["name"],
					$pa_Request["emailadresse"] ) );
		return cc_RequestError;
	}

	$po_User->RegisterUser ( $pa_Reseller, $pa_Admin );
	$lo_DB->Execute ( "UPDATE regrequest SET status = 'accepted' WHERE server_id='$ServerID' AND id = " . db_full_quote($ps_ID) );

	list ( $ls_Subject, $ls_Text ) = $po_User->ProcessEMail ( $la_EMail );
	mail ( $po_User->GetPersonal("emailadresse"), $ls_Subject, $ls_Text, "From: ".$la_EMail["emailname"]." <".
			$la_EMail["emailemailadresse"].">\nReply-To: ".$la_EMail["emailemailadresse"] );
	if ( strlen($la_EMail["emailbcc"]) )
		mail ( $la_EMail["emailbcc"], "[confixx] User-Access (copy) " . $po_User->GetPersonal("emailadresse"), $ls_Text,
				"From: ".$la_EMail["emailname"]." <".$la_EMail["emailemailadresse"].">\nReply-To: ".
				$la_EMail["emailemailadresse"] );

	message ( NOTE, ltext ( "webshop_requests_reg_ok", $pa_Request["firstname"], $pa_Request["name"],
				$pa_Request["emailadresse"] ) );
	return cc_RequestOK;
}
/* -------------------- end ff_AcceptRequest -------------------- */





/* -------------------- ff_GenerateWebshopCode -------------------- */
function ff_GenerateWebshopCode() {
  global $ServerID;
	$lo_DB =& get_db_connection();
	srand( time() );
	do {
		$ls_Result = "";
		for( $i=0; $i<10; $i++ )
			$ls_Result .= rand( 0, 9 );
		$lo_Query =& $lo_DB->Select( "SELECT COUNT(*) FROM anbieter WHERE server_id='$ServerID' AND webshopcode = " . db_full_quote($ls_Result) );
		$la_Row =& $lo_Query->nextrow();
	} while( $la_Row[0] );
	return $ls_Result;
}
/* -------------------- end ff_GenerateWebshopCode -------------------- */
?>
