<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once (  dirname(__FILE__) . DIRECTORY_SEPARATOR . "../class.Pager.php" );
include_once (  dirname(__FILE__) . DIRECTORY_SEPARATOR . "../class.InputTextColumn.php" );
include_once (  dirname(__FILE__) . DIRECTORY_SEPARATOR . "../class.SelectColumn.php" );
include_once (  dirname(__FILE__) . DIRECTORY_SEPARATOR . "../class.TextColumn.php" );
include_once (  dirname(__FILE__) . DIRECTORY_SEPARATOR . "../module.Database.php" );





class AtDomainsPager extends Pager
{
    /* -------------------- Members -------------------- */
    var $ma_Domains; // array of domains for user (for caching)
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function AtDomainsPager ( &$po_Source )
    {
	$this->ma_Domains = NULL;
	$this->Pager ( $po_Source );
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- abstract" methods -------------------- */
    function ShouldShowSummary()
    {
	return TRUE;
    }

    function ShouldShowAddForm()
    {
	$ls_Limit = $this->mo_Source->GetLimit();
	return $ls_Limit == -1 ? TRUE : $this->mo_Source->GetTotal() < $ls_Limit;
    }

    function GetSummary()
    {
	$ls_Total = $this->mo_Source->GetTotal();
	$ls_Limit = $this->mo_Source->GetLimit();
	return $ls_Limit == -1 ? ltext( "ad_summary1", array($ls_Total) ) :
		ltext( "ad_summary2", array($ls_Total,$ls_Limit) );
    }

    function GetAddColumns()
    {
	return array( new InputTextColumn( "name", ltext( "ad_username" ), "", array( "style"=>"width:100%;" ), "20%" ),
		new SelectColumn( $this->GetDomains(), "id_from", ltext( "ad_from" ), "", array( "style"=>"" ),
			"30%" ),
		new InputTextColumn( "todomain", ltext( "ad_to" ), "", array( "style"=>"width:100%" ), "40%" ) );
    }

    function GetBrowseColumns()
    {
	$la_Result = array( new InputTextColumn( "name", ltext( "ad_username" ), "", array( "style"=>"width:100%;text-align:right;" ), "20%" ),
		new TextColumn( NULL, "@", "@", array(), "1%" ),
		new SelectColumn( $this->GetDomains(), "id_from", ltext( "ad_from" ), "", array( "style"=>"" ),
			"30%" ),
		new InputTextColumn( "todomain", ltext( "ad_to" ), "", array( "style"=>"width:100%" ), "39%" ) );
	$la_Result[0]->SetSortable (TRUE);
	$la_Result[2]->SetSortable (TRUE);
	$la_Result[3]->SetSortable (TRUE);
	return $la_Result;
    }

    function GetSearchColumns()
    {
	$la_Options = $this->GetDomains();
	array_unshift ( $la_Options, array( -1, ltext("ll_any") ) );
	return array( new InputTextColumn( "search_name", ltext( "ad_username" ), "", array( "style"=>"width:100%" ), "20%" ),
		new SelectColumn( $la_Options, "search_id_from", ltext( "ad_from" ), "", array( "style"=>"" ),
			"30%" ),
		new InputTextColumn( "search_todomain", ltext( "ad_to" ), "", array( "style"=>"width:100%" ), "40%" ) );
    }

    function GetHiddenFields()
    {
	return array();
    }
    /* -------------------- end "abstract" methods -------------------- */





    /* -------------------- additional methods -------------------- */
    function GetDomains()
    {
	global $PHP_AUTH_USER;
	global $ServerID;
	if ( ! is_null($this->ma_Domains) )
	    return $this->ma_Domains;
	$lo_DB =& get_db_connection();
	$lo_Query =& $lo_DB->Select ( "SELECT id, domain FROM domains WHERE kunde='" . db_quote($PHP_AUTH_USER) . "' AND server_id='$ServerID'" );
	return $this->ma_Domains = $lo_Query->getAll();
    }
    /* -------------------- end additional methods -------------------- */

}
