<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/../class.Pager.php" );
include_once ( dirname(__FILE__) . "/../class.InputTextColumn.php" );
include_once ( dirname(__FILE__) . "/../class.SelectColumn.php" );
include_once ( dirname(__FILE__) . "/class.MenuBlocksColumn.php" );
include_once ( dirname(__FILE__) . "/class.MenuBlocksEdit.php" );
include_once ( dirname(__FILE__) . "/../class.TextAreaColumn.php" );
include_once ( dirname(__FILE__) . "/../class.InputHiddenColumn.php" );





class MenuBlocksPager extends Pager
{
    /* -------------------- Members -------------------- */
    var $ms_PageNumber; // current page, starting from 0
    var $ms_ItemsPerPage; // items per page
    var $ms_StartItem;  // start  item
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function MenuBlocksPager ( &$po_Source )
    {
    $this->ms_PageNumber = $po_Source->ms_PageNumber;
	if ( ff_GetFromPostGet("ItemsPerPage") )
		$this->ms_ItemsPerPage = intval(ff_GetFromPostGet ("ItemsPerPage"));
	elseif( ff_GetFromPostGet("step") )
		$this->ms_ItemsPerPage = intval( ff_GetFromPostGet("step") );
	elseif ( array_key_exists( get_class(&$this)."_ItemsPerPage", $_COOKIE ) )
		$this->ms_ItemsPerPage = intval($_COOKIE[get_class(&$this)."_ItemsPerPage"]);
	else
		$this->ms_ItemsPerPage = 10;
	$this->ms_StartItem = $this->ms_PageNumber*$this->ms_ItemsPerPage;
	$this->Pager ( $po_Source );
	$this->setText ( "noresults", ltext("cm_nomenus") );	
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- "abstract" methods -------------------- */
    function ShouldShowSummary()
    {
	return FALSE;
    }

    function ShouldShowAddForm()
    {
	return TRUE;
    }

    function GetSummary()
    {
	return "";
    }

    function GetAddColumns()
    {
	return array(
		new InputTextColumn( "label", ltext("cm_text"), "", array( "style" => "width:100%" ), "54%"  ),
		new SelectColumn( $this->GetUserTypes(), "usertype", ltext("cm_usertype"), "", array(), "36%" ) );
    }

    function GetBrowseColumns()
    {
	$la_Result = array(
		new InputTextColumn( "label", ltext("cm_text"), "", array( "style" => "width:100%" ), "54%" ),
		new SelectColumn( $this->GetUserTypes(), "usertype", ltext("cm_usertype"), "", array(), "12%" ),
		new MenuBlocksEdit( "menuedit.php", array("page" => $this->ms_PageNumber), ltext("cm_edit"), NULL, "&nbsp;", "", array(), "12%" ),
		new MenuBlocksColumn( "menuitems.php", NULL, "", "itemscount", "&nbsp;", "", array(), "12%" ) );
	$la_Result[0]->SetInput (FALSE);
	$la_Result[1]->SetInput (FALSE);
	$la_Result[0]->SetSortable (TRUE);
	$la_Result[1]->SetSortable (TRUE);
	return $la_Result;
    }

    function GetEditColumns()
    {
	return array(
		new InputTextColumn ( "label", ltext("cm_text"), "", array( "style" => "width:100%" ) ),
		new TextAreaColumn ( "overview", ltext("cm_overview"), "",
			array( "style" => "width:100%", "rows" => "10" ) ),
		new SelectColumn( $this->GetUserTypes(), "usertype", ltext("cm_usertype"), "" ) );
    }

    function GetSearchColumns()
    {
	$la_Options = array_merge( array( "" => ltext("ll_any") ), $this->GetUserTypes() );
	return array(
		new InputTextColumn( "search_label", ltext("cm_text"), "", array( "style" => "width:100%" ), "54%" ),
		new SelectColumn( $la_Options, "search_usertype", ltext("cm_usertype"), "", array(), "36%" ) );
    }

    function GetHiddenFields()
    {
	return array( new InputHiddenColumn ( "menublock_id", "", ff_GetFromPostGet("menublock_id") ) );
    }

    function GetListURL()
    {
	return "custommenu.php?page=".$this->ms_PageNumber."&start=".$this->ms_StartItem;		
    }

    function GetEditURL()
    {	
	return "menuedit.php";
    }
    /* -------------------- end "abstract" methods -------------------- */




    /* -------------------- GetUserTypes -------------------- */
    function GetUserTypes()
    {
	return array( "reseller" => ltext("cm_reseller"), "user" => ltext("cm_user") );
    }
    /* -------------------- end GetUserTypes -------------------- */

}
?>
