<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/../class.SQLValuesSource.php" );





class SubscriptionValuesSource extends SQLValuesSource
{
    /* -------------------- Members -------------------- */
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function SubscriptionValuesSource (  $ps_IDName=0, $ps_PageNumber = NULL, $ps_ItemsPerPage = NULL )
    {
	$this->SQLValuesSource ( $ps_IDName, $ps_PageNumber, $ps_ItemsPerPage );
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- definitions of "abstract" methods -------------------- */
    function GetBrowseSQL()
    {
	global $PHP_AUTH_USER;
	global $ServerID;
	return "SELECT * FROM angebote WHERE server_id='$ServerID' AND anbieter = " . db_full_quote($PHP_AUTH_USER) . $this->GetOrder();
    }

    // to help GetBrowseSQL & GetSearchSQL
	function GetOrder()
	{
	  global $ServerID;
		$ls_Reverse = $this->GetSortReverse() ? " DESC " : "";
		switch ( $this->GetSortColumn() )
		{
			case "identifier":
				return " ORDER BY identifier $ls_Reverse ";
			case "price":
				return " ORDER BY price $ls_Reverse ";
			case "durationtext":
				return " ORDER BY
					CASE durationitem
					WHEN 'days' THEN duration
					WHEN 'weeks' THEN duration*7
					WHEN 'monthes' THEN duration*30
					ELSE duration*365
					END $ls_Reverse ";
			case "webshop":
				return " ORDER BY webshop $ls_Reverse ";
			case "ident":
				return " ORDER BY ident $ls_Reverse ";
			case "name":
			default:
				return " ORDER BY name $ls_Reverse ";
		}
	}

    function GetDefaultSort()
    {
	return "name";
    }

    function GetCountBrowseSQL()
    {
	global $PHP_AUTH_USER;
	global $ServerID;
	return "SELECT COUNT(*) FROM angebote WHERE server_id='$ServerID' AND anbieter = " . db_full_quote($PHP_AUTH_USER);
    }

    function AddElement()
    {
	return NULL;
    }

	function EditElements()
	{
		return NULL;
	}

    function DeleteElements ( &$pa_IDs )
    {
      global $ServerID;
    	$lo_DB =& get_db_connection();
    	$ls_IDs = implode( ",", db_full_quote_array($pa_IDs) );
    	$lo_DB->Execute ( "DELETE FROM angebote WHERE server_id='$ServerID' AND ident IN ( $ls_IDs )" );
    }

    function ValidateAdd()
    {
	return NULL;
    }

    function ValidateEdit()
    {
	return NULL;
    }

    function ValidateDelete ( &$pa_IDs )
    {
	return NULL;
    }
    /* -------------------- end definitions of "abstract" methods -------------------- */

}
?>
