<?
########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR . "Smarty.class.php");

class CSmarty extends Smarty 
{
	var $use_sub_dirs = false;
	//var $template
	
	var $messages = array();
	
	var $texts = array();
	
	var $usertype = '';
	var $module = '';
	var $tpl = '';
	
	function CSmarty()
	{
		$this->template_dir = SMARTY_DIR . $this->template_dir;
		$this->compile_dir = SMARTY_DIR . $this->compile_dir;
		$this->Smarty();
	}
	
	function addMessage($type, $text)
	{
		//if (!in_array($message, $this->messages))
		if(!array_key_exists($text, $this->messages))
		{
			$this->messages[$text] = array($type, $text);
		}
	}
	
	function setText($key, $text)
	{
		$this->texts[$key] = $text;
	}
	
	function setUserType($type)
	{
		$this->usertype = $type;	
	}
	
	function setModule($mod)
	{
		$this->module = $mod;
	}
	
	function setTpl($tpl)
	{
		$this->tpl = $tpl;	
	}
	
	function makeMessages()
	{
		if (count($this->messages))
		{
			$messarr = array();
			foreach ($this->messages as $mess)	
			{
				$m = array();
				switch ($mess[0])
				{
					case NOTE:
						$m['type'] = ltext('errtype_notice');
						break;
					case WARN:
						$m['type'] = ltext('errtype_warning');
						break;
					case ERROR:
						$m['type'] = ltext('errtype_error');
						break;
					default:
						$m['type'] = ltext('errtype_notice');
				}
				$m['message'] = $mess[1];
				$messarr[] = $m;
			}
			$this->assign('ERRORS', $messarr);
		}
	}
	
	function show($usertype = '', $module = '', $tpl = '')
	{
		if(!$usertype)
		{
			$usertype = $this->usertype;	
		}
		if(!$module)
		{
			$module = $this->module;	
		}
		if(!$tpl)
		{
			$tpl = $this->tpl;
		}
		if(!$usertype || !$tpl)
		{
			echo "Set usertype, module and tpl!<br>";
			return false;	
		}
		$this->assign('LANG_HTML_CHARSET', $GLOBALS['lang_html_charset']);
		$this->assign('STR_SKIN_NAME', $GLOBALS['strSkinName']);
		$this->assign('USERTYPE', $usertype);
		$this->assign('MODULE', $module);
		$this->assign('TPL', $tpl);
		$this->assign('TEXTS', $this->texts);
		$this->makeMessages();
		$this->display('page.tpl');
	}
	
}


?>
