<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.OptionsDataField.php' );
include_once( '../include/elements/data/class.YesNoDataField.php' );
include_once( '../include/elements/data/class.ButtonData.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/elements/html/module.Constants.php' );

db_master_connect();

if( ! isset( $server_id ) ){
	$server_id = $masterServerID;
 }


/* -------------------- HTML -------------------- */
$data  = new SetOfRowsData();
$field = new OptionsDataField( array(), $lang_short, 'language' );

$languages = get_langs();

for( $i=0; $i<count($languages['short']); $i++ )
	$field->AppendToOptions( array( $languages['short'][$i]=>$languages['nat'][$i] ) );

$loServerID = new SQLString( $server_id );

$id = safe_query2( "SELECT a.oldskins, a.treemenu, a.hostname, s.name FROM admin a ".
									 " LEFT JOIN server s ON s.server_id=a.server_id WHERE a.server_id=?",
									 $loServerID );
list($oldskins,$treemenu,$hostname,$name) = db_fetch_array( $id, 'N' );
db_free_query( $id );

$data->AppendRow( new HTMLDataField( ltext( 'alsp_cell_language',
																						array( $name, $hostname )
																						) 
																		 ), 
									$field );

$lrId = safe_query2( "SELECT list_size FROM admin WHERE server_id=?",
                    $loServerID );
list( $page_size ) = db_fetch_array( $lrId, 'N' );
db_free_query( $lrId );

$field = new OptionsDataField( array(), $page_size, "page_size" );

foreach ( $list_steps as $liKey => $lcStep )
	$field->AppendToOptions( array( $liKey => $lcStep ) );

$data->AppendRow( new HTMLDataField( ltext("ll_perpage") ), $field );
	
$field = new OptionsDataField( array(), "", "skin" );

$sql = "SELECT id, show_name, path FROM custom_skins WHERE (owner_type = 'preinstalled' OR owner_type = 'admin') AND server_id=?";

if( $server_id == $masterServerID ){
	$sql .= " AND version = 'powp'";
}elseif( ! $oldskins ){
	$sql .= " AND version <> 'classic20'";
}

$id = safe_query2( $sql, $loServerID );
while( $res = db_fetch_array($id) ) {
	$field->AppendToOptions( array( $res['id']=>$res['show_name'] ) );
	if( $res['path'] == $strSkinName )
		$field->SetValue( $res['id'] );
}
db_free_query( $id );

$data->AppendRow( new HTMLDataField( "Design" ), $field );
if ( FALSE ) { ### yet time
	$data->AppendRow( new HTMLDataField( ltext("alsp_cell_treemenu") ), new YesNoDataField( array("1"=>""), array("0"=>""),
			$treemenu, "treemenu" ) );
} ### /yet time

$data->AppendButton( ltext("alsp_button1"), "javascript:doChange()", cc_IDOk );

$data->AppendHidden( new TextDataField( $server_id, 'server_id' ) );
if( isset( $ret_path ) ){
	$data->AppendHidden( new TextDataField( $ret_path, 'ret_path' ) );
 }

$page = new MainPageElement( $data->GetInputPresentation( array( 'action'=>'allgemein_sprache2.php', 'method'=>'post' ),
																													ltext('ma_masterlanguage',array($name,$hostname)) ) );
$page->OutputHTML();
/* -------------------- end HTML -------------------- */
?>
