<?
########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

include_once( 'auth.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.YesNoDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/elements/data/class.LongTextDataField.php' );

global $DEBUG;
//$DEBUG=1;

if($DEBUG){
	echo "einstellungen_dnsspezial_anbieter_aendern.php: _POST<br><pre>\n";
	print_r( $_POST );
	echo "</pre><hr>_GET<br><pre>\n";
	print_r( $_GET );
	echo "</pre><hr>\n";
 }

db_master_connect();

if( isset( $action ) && $action == 'save' ){

	$loText = new SQLString( $zusatz );
	$loRes = new SQLString( $anbieter );
	$loServerID = new SQlString( $server_id );

	safe_query2( "UPDATE anbieter SET dnsspezial = ? WHERE anbieter = ? AND server_id=?",
							 $loText, $loRes, $loServerID );
	
	$id = safe_query2( "SELECT kunde, ip, server_id FROM ipadressen ".
										 " WHERE anbieter=? AND server_id=?",
										 $loRes, $loServerID );

	$laIPs = array();

	while( list( $kunde, $ip, $lcServerID ) = db_fetch_array( $id, 'N' ) ){
		if( ! array_key_exists( $lcServerID, $laIPs ) ){
			$laIPs[$lcServerID] = array();
		}
		$laIPs[$lcServerID][$kunde] = $ip;
	}
	db_free_query( $id );


	if( $ueberschreiben == 'ja' ){

		$sql = "SELECT dns.server_id, dns.domain, dns.kunde, dns.lastchange, ".
			" a.ip_pns, a.ip_sns, r.pns, r.sns, r.standardip, k.ip ".
			" FROM dns, admin a, anbieter r, kunden k ".
			" WHERE dns.server_id=r.server_id AND k.server_id=dns.server_id ".
			" AND dns.server_id=a.server_id ".
			" AND dns.kunde = k.kunde AND k.anbieter=r.anbieter AND dns.anbieter=?".
			" AND dns.server_id=?";
		
		$id = safe_query( $sql, $loRes, $loServerID );

		while( $row = db_fetch_array( $id, 'A' ) ){
			$domain     = $row['domain'];
			$kunde      = $row['kunde'];
			$lastchange = $row['lastchange'];

			## serial
			$sn_date = substr ($lastchange, 0, 8);
			if( $sn_date != date( 'Ymd' ) ){
				$seriennummer = date('Ymd').'01';

			} else {
				$sn_id = substr( $lastchange, -2 ) + 1;
				if( strlen( $sn_id ) ==1 ){
					$sn_id = "0".$sn_id;
				}
				$seriennummer = date( 'Ymd' ).$sn_id;
			}
			## /serial

			## domain
			$zonefile = str_replace ( '##domain##', $domain, $zusatz );
			## /domain

			$pns = $row['pns'];
			$sns = $row['sns'];
			$pnsdom = substr( $pns, ( strpos( $pns, '.') + 1 ) );
			$snsdom = substr( $sns, ( strpos( $sns, '.') + 1 ) );
			$ip_pns = $row['ip_pns'];
			$ip_sns = $row['ip_sns'];

			$ip = $row['ip'];

			if( array_key_exists( $row['server_id'],$laIPs) &&
					array_key_exists( $kunde, $laIPs[$row['server_id']])){
				$ip = $laIPs[$row['server_id']][$kunde];
			}

			if( ! $ip ){
				$ip = $row['standardip'];
			}

			$zonefile = str_replace ( '##ip##', $ip, $zonefile);
		
			$zonefile = str_replace ( '##ns1##', $pns, $zonefile);
			$zonefile = str_replace ( '##ns2##', $sns, $zonefile);

			if($snsdom == $domain){
				$zonefile = $sns.".      86400  IN   A         ".$ip_sns."\n".$zonefile;
			}
	
			if($pnsdom == $domain){
				$zonefile = $pns.".      86400  IN   A         ".$ip_pns."\n".$zonefile;
			}

			safe_query2( "UPDATE dns SET zonefile = ? , lastchange = ? , neu = 1 ".
									 " WHERE domain = ? AND server_id=? ",
									 new SQLString( $zonefile ), new SQLInteger( $seriennummer ),
									 new SQLString( $domain ), new SQLString( $row['server_id'] )
									 );

		}
		db_free_query( $id );

		safe_query2( "UPDATE allgemein SET dns=1 WHERE server_id=?", $loServerID );

	}
	db_close();

	$fehlertitel = ltext('eihtanaesp_errortitle1');
	$fehlertext = ltext('eihtanaesp_error1');

	if( isset( $ret_path ) && $ret_path ){
		include( $ret_path );
	}else{
		include( 'einstellungen_dnsspezial_domain.php');
	}

	exit();

 }


$loServerID = new SQLString( $server_id );
$loRes = new SQLString( $anbieter );

$id = safe_query2( "SELECT a.confixx_domain, s.name,a.dns FROM admin a ".
									 " LEFT JOIN server s ON s.server_id=a.server_id ".
									 " WHERE a.server_id =?", $loServerID );
list($lcHostname,$lcName,$dns ) = db_fetch_array( $id, 'N' );
db_free_query( $id );

$id = safe_query2( "SELECT dnsspezial FROM anbieter WHERE anbieter = ? AND server_id=?", 
									 $loRes, $loServerID );
list($dnsspezial) = db_fetch_array( $id, 'N' );
db_free_query( $id );

if( ! $dnsspezial ){
	$id = safe_query2( "SELECT dnstemplate FROM admin WHERE server_id=?",
										 $loServerID );
	list($dnsspezial) = db_fetch_array($id, 'N' );
	db_free_query( $id );
}

$data = new SetOfRowsData();

$zonefile_field = new LongTextDataField( $dnsspezial, "zusatz" );
$zonefile_field->SetAttributes(array( 'cols'=>'60', 'rows'=>'10'));
$data->AppendRow( $zonefile_field );

$options_field = new YesNoDataField( array( 'ja'=>ltext('eidntpdoae_cell_text1') ), 
																		 array( 'nein'=>ltext('eidntpdoae_cell_text2') ), 
																		 'nein',
																		 'ueberschreiben',
																		 cc_RadioGroupPresentation );
$data->AppendRow( $options_field );
$data->AppendButton( ltext('eihtanae_button1'),
										 "javascript:doChange()",
										 cc_IDOk );
$data->AppendHidden( new TextDataField( $anbieter, 'anbieter' ) );
$data->AppendHidden( new TextDataField( $server_id, 'server_id' ) );
$data->AppendHidden( new TextDataField( 'save', 'action' ) );
if( isset( $server ) ){
	$data->AppendHidden( new TextDataField( $server, 'server' ) );
 }
if( isset( $ret_path ) ) {
	$data->AppendHidden( new TextDataField( $ret_path, 'ret_path' ) );
 }


$form = $data->GetInputPresentation( array( 'action' => "einstellungen_dnsspezial_anbieter_aendern.php",
																						'method'=>'post',
																						'name'=>'form1' ),
																		 ( $server_id? 
																			 ltext('eidntpdoae_cell_title1_master',$anbieter,$lcName,$lcHostname):
																			 ltext('eidntpdoae_cell_title2_master',$anbieter ) 
																			 ) 
																		 );

$form->AppendHelp('<b>'.ltext("eidntpdoae_title2").'</b>');

$form->AppendHelp('##domain## - '.ltext("eidntpdoae_title3"));
$form->AppendHelp('##ip## - '.ltext("eidntpdoae_title4"));
$form->AppendHelp('##ns1## - '.ltext("eidntpdoae_title5"));
$form->AppendHelp('##ns2## - '.ltext("eidntpdoae_title6"));

$page = new MainPageElement( $form );
$page->OutputHTML(js_f_call_help('dnshelp_title4', 'dnshelp_descr4'));

db_close();
?>