<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( 'defines.php');
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.LinkDataField.php' );
include_once( '../include/elements/data/class.YesNoDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/data/class.IconDataField.php' );
include_once( '../include/elements/data/class.PagedTableView.php' );
include_once( '../include/elements/data/class.ToolsButtons.php' );
include_once( '../include/elements/data/class.ToolsButtonData.php' );
include_once( '../include/elements/data/class.GenericButtonData.php' );
include_once( '../include/elements/data/class.CheckDataField.php' );
include_once( '../include/data_source/class.SQLQuery.php' );
include_once( '../include/data_source/class.CompoundValue.php' );
include_once( '../include/data_source/class.ValueLocale.php' );
include_once( '../include/data_source/class.ValueFromArray.php' );
include_once( '../include/data_source/class.ValueFormated.php' );
include_once( '../include/data_source/class.CallBackValue.php' );
include_once( '../include/data_source/class.ConversedDBValue.php' );
include_once( '../include/data_source/class.DataValue.php' );
include_once( '../include/elements/html/class.CompoundElement.php' );
include_once( '../include/elements/html/class.PPButtonElement.php' );
include_once( '../include/elements/html/class.ButtonURLElement.php' );
include_once( '../include/elements/html/class.SimpleSearchElement.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/elements/html/class.ButtonElement.php' );
include_once( '../include/class.PathBar.php' );

global $DEBUG;
//$DEBUG=1;

$lcUser          = 'res0';
$gcUserSeparator = '@';
$gcRetPath       = 'kunden_start.php';

if( $DEBUG ){
	echo "kunden_start.php: menu_node_id: $menu_node_id<br>\n";
	echo "_POST<br><pre>\n";
	print_r( $_POST );
	echo "</pre><hr>_GET<br><pre>\n";
	print_r( $_GET );
	echo "</pre><hr>\n";
}

switch( $action ){
 case 'circular':
	 $action = '';
	 include('kunden_rundschreiben.php');
	 exit;
 case 'delete':
	 $action = '';
	 if( isset( $users ) && is_array( $users ) ){
  	 include('kunden_aendern_loeschen.php');
  	 exit();
	 }else{
	 	 $fehlertext = ltext('kuaelo_nothing');
	 }
}

	
$loPathBar = new PathBar();
$laFirstItem = array('main_menu_page' => 'kunden_start.php',
										 'head_id' => 'overview',
										 'head_text' => ltext('m_overview'),
										 'menu_node_id' => 'menu_node_users_overview'
										 );
$loPathBar->pushPathBar( $laFirstItem );
	

db_master_connect();

$loReseller = new SQLString( $lcUser );

$gcHeadText = htmlspecialchars( ltext( 'mk_edituser' ) );
$gaActions = array( 'personendaten' => array( cc_PersonalIcon, 
																							ltext( 'kuae_cell_person' ),
																							'kunden_neu3.php'
																							),
										'leistungen' => array( cc_ServicesIcon, 
																					 ltext( 'kuae_cell_features' ),
																					 'kunden_neu2.php' 
																					 ),
										'domains' => array( cc_DomainsIcon, 
																				ltext( 'kuae_cell_domain'),
																				'kunden_domains.php'
																				),
											/*										 'ip' => array( cc_IPsIcon, ltext( 'kuae_cell_ip')), */
										'passwort' => array( cc_PasswordIcon, 
																				 ltext( 'kuae_cell_password' ),
																				 'kunden_aendern_pw.php'
																				 ),
										);

//===================================================================
//
// Change user
	
$loTextInput = new TextDataField( $kunde, 'kunde', array('size'=> '25', 'maxlength'=> '50'));

$loFirstRow = new CompoundDataField( new HTMLDataField( ltext('kuae_cell_user') ) ,
																			 $loTextInput );
$loFirstRow->SetSeparator('&nbsp;&nbsp;');

$loUserTools = new ToolsButtons( $loFirstRow );

$loButtons = new CompoundDataField();

foreach( $gaActions as $lcKey => $laAttr ){

	$lcID = 'change_'.$lcKey; 
	$lcCurPage = $laAttr[2];
	$lcHeadText = $laAttr[1];
	$loButtons->AppendToContent( new GenericButtonData( '',
																											$lcID, 
																											$lcHeadText, 
																											"javascript:setValue('aktion','$lcKey');".
																											"setValue('cur_page','$lcCurPage');".
																											"setValue('head_id','$lcKey');".
																											"setValue('head_text','$lcHeadText');".
																											"submitForm('menu_node_id','$lcKey')",
																											$lcID
																											)
															 );
}
$loButtons->SetSeparator(' ');

$loUserTools->AppendToContent( $loButtons );
$loUserTools->SetSeparator( '<br>' );
$loUserTools->Anchor( 'change' );
$loUserTools->Legend(ltext('kuae_title1'));

$loUserTools->Hiddens( array( 'aktion' => '', 
															'server_id' => $server_id,
															'menu_node_id' => '',
															'cur_page' => 'kunden_aendern_fwd.php',
															'head_id' => '',
															'head_text' => $gcHeadText 
															) 
											 );

$loUserEdit = $loUserTools->GetInputPresentation( array( 'action' => 'kunden_aendern_fwd.php',
																												 'name' => 'change_user'));

$loA2 = new ButtonElement( ltext("ll_back"),
													 "javascript:displayDiv('tls_main',1);".
													 "displayDiv('paging',1);".
													 "displayDiv('back',0)",
													 cc_IDBack  ); 

	
$loBackLink = new DivElement ( array('name'=>'back',
																		 'id'=>'back',
																		 'style' => 'display:none'),
															 $loA2 
															 );


//
//
//===================================================================
// 
// List of users

initPagingSettings( $_POST, array( 'name_to_search' => $name_to_search ) );

$lcSQL = "SELECT COUNT(*) FROM kunden";
$res = safe_query2( $lcSQL );
list( $total_number ) = db_fetch_array( $res );
db_free_query( $res );

$listFormIndex = 1;
	
$laOrders = array( 'user'     => 'k.number', 
									 'name'     => 'k.firstname', 
									 'state'    => 'k.neu', 
									 'reseller' => 'reseller', 
									 'server'   => 'server',
									 'status'   => 'k.gesperrt'
									 );
                     
if( ! isset( $order ) || ! array_key_exists( $order, $laOrders ) ){	
	$order = 'user';
 }
if( ! isset( $direction) ){
	$direction = 'asc';
 }
  
$lcSqlOrder  = " ORDER BY ".$laOrders[$order]; 
$lcSqlOrder .= $direction == 'desc' ? " DESC" : ""; 

$lcFields = "MIN(k.kunde) AS kunde, MIN(k.anbieter) AS reseller,".
	" MIN(k.name) AS name, MIN(k.firstname) AS firstname,".
	" MIN(k.gesperrt) AS gesperrt, MIN(k.neu) AS neu, k.number,".
	" COUNT(d.domain) as domains,".
	" s.name as server, a.confixx_domain as server_hostname, ".
	" k.server_id as server_id, a.login AS admin_login ";

$lcFrom = "kunden k ".
	" LEFT JOIN domains d ON k.kunde = d.kunde AND d.richtigedomain IN (1,7)  AND d.server_id=k.server_id".
	" LEFT JOIN server s ON k.server_id = s.server_id ".
	" LEFT JOIN admin a ON k.server_id = a.server_id ";
  
if( isset( $name_to_search ) && strlen( $name_to_search ) ){

	$loName = new SQLValue( $name_to_search, 'S' );


	$lcWhere = "( k.kunde LIKE '%?%' OR k.name LIKE '%?%' OR firma LIKE '%?%' OR".
		" d.domain LIKE '%?%'  OR s.name LIKE '%?%' OR ".
		" a.confixx_domain LIKE '%?%' OR k.anbieter LIKE '%?%' )";

	$lcSQL = "SELECT COUNT(*) FROM $lcFrom WHERE $lcWhere ".
		" GROUP BY k.kunde, k.server_id";

	$loQuery = new SQLQuery( $lcSQL, array( $loName, $loName, $loName, $loName,$loName, $loName, $loName) );
	$loQuery->doQuery();
	list( $total_number ) = $loQuery->fetchArray('N');
	$loQuery->finish();

	$lcSQL = "SELECT $lcFields FROM $lcFrom WHERE $lcWhere ".
		" GROUP BY k.kunde, k.server_id ".$lcSqlOrder;
	$loQuery->Query( $lcSQL );

 } else {
	$lcSQL = "SELECT $lcFields FROM $lcFrom ".
		" GROUP BY k.kunde, k.server_id ".$lcSqlOrder;
				          
	$loQuery = new SQLQuery( $lcSQL );
 }

$loDS = new ConversedDBValue( $loQuery, $page_size, $start_index - 1 );
$loDS->TotalNumber( $total_number );

$gcLocked = ltext( 'kuaeku_status_locked' );
$gcUnlocked = ltext( 'kuaeku_status_active' );

//===========================================================
//
// call back functions to prepare database's data 

function prepareLocked( $plLocked ){
	global $gcLocked, $gcUnlocked;
	return $plLocked? $gcLocked: $gcUnlocked; 
}

$gcNew = ltext( 'kuaeku_status_new' );
$gcNormal = ltext( 'kuaeku_status_normal' );
$gcToDelete = ltext( 'kuaeku_status_todelete' );

function prepareStatus( $piNeu ){
	global $gcNew, $gcNormal, $gcToDelete;
	switch($piNeu){
	case 1:
		return $gcNew;
	case 2:
		return $gcToDelete;
	default:
		return $gcNormal; 
	}
}


// end call back functions
//
//=======================================================
$laContent =array();
$lcDirIcon = $direction == 'desc' ? cc_DescIcon : cc_AscIcon; 
$lcNewDir  = $direction == 'desc' ? 'asc' : 'desc';
$laHeaders = array( 'state'          => array( 'name' => 'kuaeku_cell_state',    'sort' => 1 ), 
										'status'         => array( 'name' => 'kuaeku_cell_status',   'sort' => 1 ), 
										'user'           => array( 'name' => 'kuaeku_cell_user',     'sort' => 1 ), 
										'name'           => array( 'name' => 'kuaeku_cell_name',     'sort' => 1 ), 
										'domains_number' => array( 'name' => '',                     'sort' => 0 ), 
										'domains'        => array( 'name' => 'kuaeku_cell_domains',  'sort' => 0 ), 
										'reseller'       => array( 'name' => 'kuaeku_cell_reseller', 'sort' => 1 ), 
										'server'         => array( 'name' => 'kust_server',          'sort' => 1 ), 
										'change'         => array( 'name' => 'll_change',            'sort' => 0 ) 
                    );

foreach( $laHeaders as $lcKey => $laValue ){ 
	if( $laValue['sort'] ){ 
		if( $order == $lcKey ){ 
			$loContent = new CompoundDataField( new HTMLDataField( ltext( $laValue['name'] ) ), 
																					new IconDataField( $lcDirIcon ) 
                                          ); 
			$loContent->SetSeparator( '' ); 
		}else{ 
			$loContent = new HTMlDataField( ltext( $laValue['name'] ) ); 
		} 
		$laContent[] = new DataValue( $lcKey, NULL, new LinkDataField( "javascript:setValue('order', '$lcKey',$listFormIndex);". 
																																	 "setValue('start_index',1,$listFormIndex);". 
																																	 "submitForm('direction','$lcNewDir',$listFormIndex)", 
																																	 '', array(), $loContent 
																																	 ) 
																	); 
	}else{ 
		$laContent[] = $laValue['name'] ? new ValueLocale( $laValue['name'] ) : null; 
	} 
}
  
$loTitle = new CompoundValue( $laContent ); 
//////////////////////////////////////////////////////////////////

$loTemplate = new CompoundValue( new CompoundValue( new ValueFormated( 'neu', NULL, 'prepareStatus'),
																										new ValueFromArray( 'kunde' )
																										),
																 new CompoundValue( new ValueFormated( 'gesperrt', NULL, 'prepareLocked'),
																										new ValueFromArray( 'kunde' ),
																										new ValueFromArray( 'server_id' )
																										),
																 new CompoundValue(
																									 new ValueFromArray( 'kunde' ),
																									 new ValueFromArray( 'server_id' )
																									 ),
																 new CompoundValue(	 new ValueFromArray( 'firstname' ),
																										 new ValueFromArray( 'name' )
																										 ),
																	 
																 new CompoundValue(	 new ValueFromArray( 'domains' ),
																										 new ValueFromArray( 'kunde' ),
																										 new ValueFromArray( 'server_id' )
																										 ),
																 new CompoundValue(	 new ValueFromArray( 'kunde' ),
																										 new ValueFromArray( 'server_id' )
																										 ),
																 new CompoundValue(	 new ValueFromArray( 'reseller' ),
																										 new ValueFromArray( 'server_id' )
																										 ),
																 new CompoundValue(	 new ValueFromArray( 'server' ),
																										 new ValueFromArray( 'server_hostname' ),
																										 new ValueFromArray( 'server_id' ),
																										 new ValueFromArray( 'admin_login' )
																										 ),
																 
																 new CompoundValue(	 new ValueFromArray( 'kunde' ),
																										 new ValueFromArray( 'server_id' )
																										 ),
																 new CompoundValue(	 new ValueFromArray( 'kunde' ),
																										 new ValueFromArray( 'server_id' )
																										 )
																 );

$loCheckBox = new CheckDataField( 1, 'selectAll' );
$loCheckBox->Attribute('onclick', "javascript:checkedAll('users', this.checked, 1)");
$loSelValue = new DataValue( 'selectAll', 1, $loCheckBox );
$loSelValue->setTypeOfPresentation( 'Input' );
$loTitle->addValue($loSelValue);
	
	
$laWidths = array( '5%', '5%', '10%', '17%', '5%', '24%', '10%','11%','8%', '5%' );

$loDS->Template( $loTemplate );

//=====================================================================
//
// call back functions to make visible objects

function &createStateIcon( $poSrc ){
	$loTitle =& $poSrc->Value(0);
	$lcTitle = $loTitle->Value();
	$liNeu = $loTitle->UnformatedValue();

	switch( $liNeu ){
	case 1:
		$lcIcon = cc_StateNewIcon;
		break;
	case 2:
		$lcIcon = cc_StateDeleteIcon;
		break;
	default:
		$lcIcon = cc_StateOkIcon;
	}
	
	$loIcon = new IconDataField( $lcIcon, 
															 array( 'alt' => $lcTitle,
																			'title' => $lcTitle ), 
															 array( 'align'=>'center') );

	return $loIcon;
}

function &createStatusLink( $poSrc ){

	global $gcHeadText;
	global $gcUserSeparator;
	global $gcRetPath;
	
	$loTitle    =& $poSrc->Value(0);
	$lcTitle    = $loTitle->Value();
	$liGesperrt = $loTitle->UnformatedValue();

	$loUser    =& $poSrc->Value(1);
	$loServer  =& $poSrc->Value(2);
	$lcUrlUser = urlencode( $loUser->Value() );
	$lcQuery   = "kunde=$lcUrlUser&aktion=sperren&server_id=".$loServer->Value();

	$lcIcon = $liGesperrt? cc_LockedIcon: cc_ActiveIcon;

	$loLink = new LinkDataField( 'kunden_aendern_fwd.php', 
															 $lcQuery, 
															 array( 'action' => 'sperren',
																			'menu_node_id' => 'sperren',
																			'ret_path' => $gcRetPath,
																			'cur_page' => 'kunden_aendern_fwd.php',
																			'head_text' => $gcHeadText ), 
															 new IconDataField( $lcIcon ) );
	
	$loLink->AppendAttributes( array( 'title' => $lcTitle ) );
	$loLink->AppendParentAttributes( array( 'align' => 'center' ) );
	
	return $loLink;
}
	
function &createLink( &$poObject){
	global $gcUserSeparator;
	list($lcKunde,$lcServerID) = $poObject->listValue();
	
	$lcUrlUser = urlencode( $lcKunde );
	
	$loLink = new LinkDataField( 'adminredirect.php',
															 '',
															 array( 'type' => USERTYPE_USER,
																		  'admin' => $lcUrlUser,
																			'server_id' => $lcServerID
																			),
															 new TextDataField( $lcUrlUser) );
	
	$loLink->AppendAttributes( array( 'target' => '_blank') );
		
	return $loLink;
}

function &createAction( &$poObject ){
	global $gaActions, $gcHeadText, $gcUserSeparator;
	
	list($lcKunde,$lcServerID) = $poObject->listValue();
		
	$loActions = new LinkDataField( "javascript:setValue('kunde','$lcKunde');".
																	"setValue('server_id','$lcServerID');".
																	"displayDiv('tls_main',0);".
																	"displayDiv('paging',0);".
																	"displayDiv('back',1);".
																	"void(document.location='#change')", 
																	'', 
																	array(), 
																	new IconDataField( cc_ChangeIcon ) );
	$loActions->Attribute( 'title', ltext('ll_change')  );
	$loActions->ParentAttribute( 'align','center');
	
	return $loActions;
}
	
function &createCheckbox( &$poObject ){
	global $gcUserSeparator;

	list( $lcKunde, $lcServerId ) = $poObject->listValue();

	$loBox = new YesNoDataField( array( $lcKunde.$gcUserSeparator.$lcServerId => NULL ), 
															 array( '0'=>NULL ),
															 '',
															 'users[]' );
	return $loBox->GetInputPresentation();
}

function &createServer( &$poObject ){
	list( $lcServer, $lcHost, $lcServerID, $lcAdminLogin ) = $poObject->listValue();

	$loLink = new LinkDataField( 'adminredirect.php',
															 '',
															 array( 'type' => USERTYPE_ADMIN,
																			'admin' => $lcAdminLogin,
																			'server_id' => $lcServerID
																			),
															 new HTMLDataField( $lcServer )
															 );

	$loLink->AppendAttributes( array( 'target' => '_blank') );

	return $loLink;
}

function &createResellerLink( &$poSrc ){
	global $gcUserSeparator;

	list($lcReseller,$lcServerID) = $poSrc->listValue();
	$lcUrlRes = urlencode( $lcReseller);
	$loLink = new LinkDataField( 'adminredirect.php',
															 '',
															 array( 'type' => USERTYPE_RESELLER,
																			'admin' => $lcUrlRes,
																			'server_id' => $lcServerID
																			),
															 new TextDataField( $lcReseller ) );

	$loLink->AppendAttributes( array( 'target' => '_blank') );
		
	return $loLink;
}

$gcDomainTitle = str_replace('&amp;','&',ltext( 'kuae_cell_domain' ));

function &createDomainsLink( &$poSrc ){

	global $gcDomainTitle;
	global $gcUserSeparator;

	list($liCount, $lcUser, $lcServerID ) = $poSrc->listValue();

	$loLink = new LinkDataField( "javascript:setValue('kunde','$lcUser');".
															 "setValue('server_id','$lcServerID');".
															 "setValue('cur_page','kunden_domains.php');".
															 "setValue('menu_node_id','eidt_domains');".
															 "setValue('head_text','$gcDomainTitle');".
															 "submitForm('aktion','domains')", 
															 '', 
															 array(), 
															 new TextDataField( $liCount, 'domains') );
	$loLink->Attribute( 'title', $gcDomainTitle );
	$loLink->ParentAttribute( 'align', 'right' );
	return $loLink;
}
	
function &createName( &$poSrc ){
	list($lc_firstName,$lc_lastName) = $poSrc->listValue();
	return new HTMLDataField($lc_firstName.' '. $lc_lastName);
}
	

function &createDomainList( &$poObject ) {

  	list($lcKunde,$lcServerId) = $poObject->listValue();

    $lrId = safe_query2( " SELECT domain, richtigedomain FROM domains ".
                         " WHERE richtigedomain IN (1,7) AND kunde=? ".
                         " AND server_id=? ORDER BY domain", 
                         new SQLString( $lcKunde ), new SQLString($lcServerId ) );

    $i = 0;
    $loList = new CompoundDataField();
     
    while( ( $laRow = db_fetch_array( $lrId ) ) && $i < 3 ){
      if( $laRow['richtigedomain'] !=7 ){
				$loLinkTmp = new LinkDataField( 'http://'.$laRow['domain'], '', array(), $laRow['domain'] );
				$loLinkTmp->Attribute( 'target', '_blank');
      }else{
        $loLinkTmp = new HTMLDataField( '<i>'.$laRow['domain'].'</i>' );
      }
      $loList->AppendToContent( $loLinkTmp );
      $i++;
    }

    db_free_query($lrId); 
    if( $i >= 3){
  		$loList->AppendToContent( new HTMLDataField( '...' ) );
    }
		$loList->SetSeparator( ', ' );
		return $loList;
}

// end call back functions
//
//============================================================

//	$loCheckBox = new CheckDataField( '', 'users[]');
//	$loCheckBox->ParentAttribute('align','center');
//	$loSelValue = new DataValue( 'kunde', $loCheckBox  );
//	$loSelValue->setTypeOfPresentation( 'Input' );


$loDS->Conversion( new CompoundValue( new ValueFormated( 'state', NULL, 'createStateIcon' ), 
																			new ValueFormated( 'status', NULL, 'createStatusLink' ),
																			new ValueFormated( 'user', NULL, 'createLink' ),
																			new ValueFormated( 'name', NULL, 'createName' ),
																			new ValueFormated( 'count', NULL, 'createDomainsLink' ),
																			new CallBackValue( 'domains', NULL, 'createDomainList' ),
																			new ValueFormated( 'reseller', NULL, 'createResellerLink' ),
																			new ValueFormated( 'server', NULL, 'createServer' ),
																			new ValueFormated( 'action', NULL, 'createAction' ),
																			new ValueFormated( 'checkbox', NULL, 'createCheckbox' )
																			)
									 );

$loDS->doQuery();
$loPTV = new PagedTableView( $loDS, $total_number );

$loPTV->Title( $loTitle	);
$loPTV->Widths( $laWidths );
$loPTV->setParameter( 'menu_node_id', $menu_node_id );
$loPTV->setParameter( 'cur_page', $cur_page );
$loPTV->setParameter( 'head_text', $head_text );
$loPTV->Anchor( 'list' );
$loPTV->setParameter( 'order', $order );
$loPTV->setParameter( 'direction', $direction );
	
if (isset($name_to_search)&&strlen($name_to_search)) {
	$loPTV->NoItemsMessage(ltext('ll_empty_search'));
 }	else {
	$loPTV->NoItemsMessage(ltext('ll_empty_list'));
 }
		
$loPTV->FormIndex(1);

$tbl = $loPTV->GetOutputPresentation( array( 'action' => 'kunden_start.php#list',
																						 'name' => 'list_res' ), 
																			ltext( "mk_edituser" ) );

//==================================================
//
// search

$dsSearch = new CompoundValue( new ValueFromArray( 'name_to_search', $name_to_search ),
															 new ValueLocale( 'll_search' ),
															 new ValueLocale( 'll_show_all' )
															 );
$loSearch = new SimpleSearchElement( array(), 
																		 new InputTextElement( array( 'name' => 'name_to_search', 
																																	'size' => '16',
																																	'value' => $name_to_search,
																																	'MAXLENGTH'=> '32' )
																													 ) 
																		 );


$loGroup = new DivElement(array('class'=>'buttons'));
	

$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:submitForm('start_index',1,1)", 
																							 'bid-search' 
																							 )
													);
$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:setValue('name_to_search','',1);submitForm('start_index',1,1)", 
																							 'bid-show-all'
																							 ) 
													);

$head_text = ltext('mk_mailing');
$loGroup->AppendToContent( new PPButtonElement( $head_text,
																								"javascript:setValue('menu_node_id','circular',1);".
																								"setValue('cur_page','kunden_rundschreiben.php',1);".
																								"setValue('head_text','$head_text',1);".
																								"submitForm('action','circular',1)",
																								'bid-circular'
																								)
													 );
$head_text = ltext('ll_delete');
$loGroup->AppendToContent( new PPButtonElement( $head_text,
																								"javascript:setValue('menu_node_id','delete_res',1);".
																								"setValue('cur_page','kunden_aendern_loeschen.php',1);".
																								"setValue('head_text','$head_text',1);".
																								"submitForm('action','delete',1)",
																								'bid-delete' 
																								)
													 );

	
$loSearch->setDataSource( $dsSearch, array( 'name_to_search' => $name_to_search ) );

$llUpdate = FALSE;
if( ( isset( $name_to_search ) && strlen( $name_to_search ) ) || $total_number > 0) {
	$tbl->setSearchElement( $loSearch );
	$llUpdate = TRUE;
 }

if ($total_number>0) {
	$tbl->setGroupActionElement( $loGroup );
	$llUpdate = TRUE;
 }

if(	$llUpdate ){
	$tbl->updateBodyContent();
 }

$page = new MainPageElement( $loUserEdit, $loBackLink, $tbl );

$page->OutputHTML( array( '../../js/paged_form.js' ) );

?>
