<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( 'defines.php' );

include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.LinkDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/data/class.IconDataField.php' );
include_once( '../include/elements/data/class.PagedTableView.php' );
include_once( '../include/elements/data/class.GenericButtonData.php' );
include_once( '../include/elements/data/class.CheckDataField.php' );
include_once( '../include/elements/data/class.OptionsDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/data/class.ToolsButtons.php' );
include_once( '../include/elements/data/class.ToolsButtonData.php' );


include_once( '../include/data_source/class.SQLQuery.php' );
include_once( '../include/data_source/class.CompoundValue.php' );
include_once( '../include/data_source/class.ValueLocale.php' );
include_once( '../include/data_source/class.ValueFromArray.php' );
include_once( '../include/data_source/class.ValueFormated.php' );
include_once( '../include/data_source/class.ConversedDBValue.php' );
include_once( '../include/data_source/class.DataValue.php' );


include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/elements/html/class.CompoundElement.php' );
include_once( '../include/elements/html/class.PPButtonElement.php' );
include_once( '../include/elements/html/class.ButtonURLElement.php' );
include_once( '../include/elements/html/class.ButtonElement.php' );
include_once( '../include/elements/html/class.SimpleSearchElement.php' );

include_once( 'gui/module.GuiPP_HeadMenu.php' );

include_once( '../include/elements/html/module.Constants.php' );

global $DEBUG;
//$DEBUG=1;


if($DEBUG){
	echo "settings_ip.php: _POST:<br><pre>\n";
	print_r($_POST);
	echo "</pre><hr>_GET:<br><pre>\n";
	print_r( $_GET );
	echo "</pre><hr>\n";
}

$loPathBar = new PathBar();
$laFirstItem = array('main_menu_page' => 'settings_ip.php',
										 'head_id' => 'overview',
										 'head_text' => ltext('m_overview'),
										 'menu_node_id' => 'menu_node_ips_overview'
										 );
$loPathBar->pushPathBar( $laFirstItem );


db_master_connect();

if( isset($action) && $action ){
	switch( $action ){
	case 'reread':
		$lcSql = "UPDATE allgemein SET lokaleips = 1";
		if( $server_id ){
			$lcSql .= " WHERE server_id=?";
		}
		safe_query2( $lcSql, new SQLString( $server_id ) );
		$fehlertitel = ltext( 'eiipauup_errortitle' );
		$fehlertext = ltext( 'eiipauup_error1' );
		break;
	case 'activate':
		safe_query2( "UPDATE ipadressen SET status=1 WHERE server_id=? AND ip=?",
								 new SQLString($server_id), new SQLString($ip) );
		break;
	case 'deactivate':
		$loIP = new SQLString( $ip );
		$loServerID = new SQLString( $server_id );
		$id = safe_query2( "SELECT kunde FROM kunden WHERE ip=? AND server_id=?",
											 $loIP, $loServerID);
		$cnt = db_num_rows( $id );
		if( $cnt ){
			$laUsers = array();
			while( list($user) = db_fetch_array($id, 'N' ) ){
				$laUsers[] = $user;
			}
			db_free_query( $id );
			$fehlertitel = ltext( 'eiipauup_errortitle' );
			$fehlertext = ltext( 'eiipauup_error2', array( join(', ',$laUsers ) ) );
			
		}else{
			db_free_query( $id );
			$id = safe_query2("SELECT standardip FROM admin WHERE server_id=?",
												$loServerID );
			list($standardip) = db_fetch_array( $id );
			db_free_query( $id );
			if( $standardip == $ip ){

			}else{
				safe_query2( "UPDATE ipadressen SET status=0, anbieter='', kunde='' ".
										 " WHERE server_id=? AND ip=?",
										 $loServerID, $loIP );
				
				$fehlertitel = ltext("eiiplo_errortitle");
				$fehlertext = ltext("eiiplo_error1");
			}
		}
	}
}

initPagingSettings( $_POST, array( 'ip_to_search' => $ip_to_search,
																	 'server_to_search' => $server_to_search ) );

//================================================================
//
//

$gcHeadText = htmlspecialchars( ltext( 'seip_reread' ) );



$dsServers = new CompoundDBValue( "SELECT a.server_id, s.name, a.hostname ".
																	" FROM admin a LEFT JOIN server s ON s.server_id=a.server_id WHERE a.server_id != '$masterServerID' ".
																	" ORDER BY s.name, a.hostname");
$dsServers->doQuery();
$laOptions = array();
$loIter =& $dsServers->getFirstIterator();

$laOptions[''] = ltext('ll_all');

while( $loItem =& $loIter->getNext() ){
	list($lcServerID,$lcName,$lcHostname) = $loItem->listValue();
	
	$lcPrompt = $lcHostname;
	$laOptions[$lcServerID] = $lcPrompt;
 }


$loSrvrs = new OptionsDataField( $laOptions, $server_id,'server_id' ); 

$loToolsData = new SetOfRowsData();
$loToolsData->AppendRow( new HTMLDataField( ltext('alse_cell_server')),
												 $loSrvrs,
												 new ButtonData( ltext( 'eiipau_button2' ) )
												 );
$loToolsData->AppendHidden( new textdataField( 'reread', 'action' ) );
$loTools = $loToolsData->GetInputPresentation(array('action'=>'settings_ip.php'));


//
//
//==============================================

$lcSQL = "SELECT count(ip) FROM ipadressen";
$res = db_query( $lcSQL );
list( $total_number ) = db_fetch_array( $res );
db_free_query( $res );

//Sort settings 
$listFormIndex = 1;
if( ! isset( $direction ) ) 
	$direction = 'asc';
if( ! isset( $order ) ) 
	$order = 'ip';
$lcDirIcon = ( $direction =='desc' ) ? cc_DescIcon : cc_AscIcon;
$lcNewDir =  ( $direction =='desc' ) ? 'asc' : 'desc';

$laContent = array();

if (!isset($direction)) $direction = 'asc';
if (!isset($order)) $order = 'ip';
$lcDirIcon = ( $direction =='desc' ) ? cc_DescIcon : cc_AscIcon;
$lcNewDir =  ( $direction =='desc' ) ? 'asc' : 'desc';

switch ( $order ) {
 case 'ip':
	 $lcOrder = " ORDER BY i.ip_num";
	 break;
 case 'server':
	 $lcOrder = " ORDER BY s.name, i.server_id";
	 break;
 case 'user':
	 $lcOrder  = " ORDER BY i.kunde";
	 break;
 case 'status':
	 $lcOrder  = " ORDER BY i.status";
	 break;
 }
if ( $direction == 'desc' ){
	$lcOrder .= " DESC";
 }

if( isset($ip_to_search) && $ip_to_search ){
	$loWhereOr = new SQLFieldSet ();
	$loWhereOr->addField( 'i.ip', '%'.$ip_to_search.'%', 'C' );
	$loWhereOr->addField( 'i.kunde', '%'.$ip_to_search.'%', 'C' );
	$loWhereOr->addField( 's.name', '%'.$ip_to_search.'%', 'C' );
																
	$lcWhereOr = $loWhereOr->getSQLWhere( ' OR ' );
}else{
	 $lcWhereOr = '';
 }


$loWhereAnd = new SQLFieldSet (new SQLField('i.server_id','a.server_id','U'));

if( isset($server_to_search) && $server_to_search ){
	$loWhereAnd->addField( 'i.server_id', $server_to_search, 'C' );
 }

$lcWhere = " WHERE ".$loWhereAnd->getSQLWhere( ' AND ' );

if( $lcWhereOr ){
	if( $lcWhere ){
		$lcWhere .= " AND ( $lcWhereOr )";
	}else{
		$lcWhere = " WHERE ".$lcWhereOr;
	}
 }

$lcSQL = "SELECT count(*) FROM (ipadressen i, admin a) LEFT JOIN server s ".
	" ON s.server_id=a.server_id $lcWhere";
$loQuery = new SQLQuery( $lcSQL );
$loQuery->doQuery();
list($total_number) = $loQuery->fetchArray( 'N' );
$loQuery->finish();

$lcSQL = "SELECT i.status,i.ip,i.server_id,i.kunde,a.confixx_domain,s.name,a.standardip ".
	" FROM (ipadressen i, admin a ) LEFT JOIN server s ON s.server_id=a.server_id ".
	$lcWhere.' '.$lcOrder;
$loQuery->Query( $lcSQL );


if( $order == 'status' ) {
	$laContent['status'] = new CompoundDataField( new HTMLDataField( ltext( 'seed_cell_status' )),
																								new IconDataField( $lcDirIcon ));
	$laContent['status']->SetSeparator('');
 } else {
	$laContent['status'] = new HTMlDataField( ltext( 'seed_cell_status' ) );
 }

if( $order == 'ip' ) {
	$laContent['ip'] = new CompoundDataField( new HTMLDataField( ltext( 'seed_cell_ip' )),
																						new IconDataField( $lcDirIcon ));
	$laContent['ip']->SetSeparator('');
 } else {
	$laContent['ip'] = new HTMlDataField( ltext( 'seed_cell_ip' ) );
 }

if( $order == 'user' ) {
	$laContent['user'] = new CompoundDataField( new HTMLDataField( ltext( 'eiip_cell_user' )),
																							new IconDataField( $lcDirIcon ));
	$laContent['user']->SetSeparator('');
 } else {
	$laContent['user'] = new HTMlDataField( ltext( 'eiip_cell_user' ) );
 }

if( $order == 'server' ) {
	$laContent['server'] = new CompoundDataField( new HTMLDataField( ltext( 'seed_cell_server' )),
																							new IconDataField( $lcDirIcon ));
	$laContent['server']->SetSeparator('');
 } else {
	$laContent['server'] = new HTMlDataField( ltext( 'seed_cell_server' ) );
 }


$loDS = new ConversedDBValue( $loQuery, $page_size, $start_index - 1 );
$loDS->TotalNumber( $total_number );

$loTemplate = new CompoundValue ( new CompoundValue( new ValueFromArray( 'status' ), 
																										 new ValueFromArray( 'ip' ),
																										 new ValueFromArray( 'server_id'),
																										 new ValueFromArray( 'kunde'),
																										 new ValueFromArray( 'standardip')
																										 ),
																	new ValueFromArray( 'ip' ),
																	new ValueFromArray( 'kunde'),
																	new CompoundValue( new ValueFromArray( 'name' ), 
																										 new ValueFromArray( 'confixx_domain')
																										 ),
																	new CompoundValue( new ValueFromArray( 'ip' ),
																										 new ValueFromArray( 'server_id')
																										 )
																	);
$loCheckBox = new CheckDataField( 1, 'selectAll' );
$loCheckBox->Attribute('onclick', "javascript:checkedAll('server', this.checked, 1, $listFormIndex)");
$loSelValue = new DataValue( 'selectAll', 1, $loCheckBox );
$loSelValue->setTypeOfPresentation( 'Input' );


$loTitle = new CompoundValue( new DataValue( 'status', 
																						 NULL, 
																						 new LinkDataField( "javascript:setValue('order','status',$listFormIndex);".
																																"setValue('start_index',1,$listFormIndex);".
																																"submitForm('direction','$lcNewDir',$listFormIndex)",
																																'',
																																array(),
																																$laContent['status']
																																)
																						 ),
															new DataValue( 'ip', 
																						 NULL, 
																						 new LinkDataField( "javascript:setValue('order','ip',$listFormIndex);".
																																"setValue('start_index',1,$listFormIndex);".
																																"submitForm('direction','$lcNewDir',$listFormIndex)",
																																'',
																																array(),
																																$laContent['ip']
																																)
																						 ),
															new DataValue( 'user', 
																						 NULL, 
																						 new LinkDataField( "javascript:setValue('order','user',$listFormIndex);".
																																"setValue('start_index',1,$listFormIndex);".
																																"submitForm('direction','$lcNewDir',$listFormIndex)",
																																'',
																																array(),
																																$laContent['user']
																																)
																						 ),
															new DataValue( 'server', 
																						 NULL, 
																						 new LinkDataField( "javascript:setValue('order','server',$listFormIndex);".
																																"setValue('start_index',1,$listFormIndex);".
																																"submitForm('direction','$lcNewDir',$listFormIndex)",
																																'',
																																array(),
																																$laContent['server']
																																)
																						 )
															);

$laWidths = array( '10', '30%', '20', '40' );

$loDS->Template( $loTemplate );

$laContent = array();

if( $order == 'status' ) {
	$laContent['status'] = new CompoundDataField( new HTMLDataField( ltext( 'seip_cell_status' )),
																								new IconDataField( $lcDirIcon ));
	$laContent['status']->SetSeparator('');
 } else {
	$laContent['status'] = new HTMlDataField( ltext( 'seip_cell_status' ) );
 }

if( $order == 'user' ) {
	$laContent['user'] = new CompoundDataField( new HTMLDataField( ltext( 'eiip_cell_user' )),
																							new IconDataField( $lcDirIcon ));
	$laContent['user']->SetSeparator('');
 } else {
	$laContent['user'] = new HTMlDataField( ltext( 'eiip_cell_user' ) );
 }

if( $order == 'ip' ) {
	$laContent['ip'] = new CompoundDataField( new HTMLDataField( ltext( 'eiip_cell_ip' )),
																						new IconDataField( $lcDirIcon ));
	$laContent['ip']->SetSeparator('');
 } else {
	$laContent['ip'] = new HTMlDataField( ltext( 'eiip_cell_ip' ) );
 }

if( $order == 'server' ) {
	$laContent['server'] = new CompoundDataField( new HTMLDataField( ltext( 'seip_cell_server' )),
																								new IconDataField( $lcDirIcon ));
	$laContent['server']->SetSeparator('');
 } else {
	$laContent['server'] = new HTMlDataField( ltext( 'seip_cell_server' ) );
 }

$loCheckBox = new CheckDataField( '', 'servers[]');
$loCheckBox->ParentAttribute('align','center');
$loSelValue = new DataValue( 'server', $loCheckBox  );
$loSelValue->setTypeOfPresentation( 'Input' );


function &createStatusLink( &$poSrc ) {

	global $order, $direction;

	list( $liStatus, $lcIP, $lcServerID, $lcUser, $lcStandardIP ) = $poSrc->listValue();
	switch( $liStatus ){
	case 0:
		$lcTitle = ltext('seip_status_to_on');
		$lcIcon = cc_OffIcon;
		$loLink = new LinkDataField( 'settings_ip.php',
																 '',
																 array( 'action' => 'activate',
																			  'server_id' => $lcServerID,
																				'ip' => $lcIP,
																				'anbieter' => 'res0',
																				'order' => $order,
																				'direction' => $direction
																				),
																 new IconDataField( $lcIcon )
																 );


		break;
	case 1:
		$lcTitle = ltext('seip_status_to_off');
		$lcIcon = cc_OnIcon;
		if( $lcUser || ( $lcIP == $lcStandardIP ) ){
			$loLink = new IconDataField( $lcIcon );
			$lcTitle = '';
		}else{
			$loLink = new LinkDataField( 'settings_ip.php',
																	 '',
																	 array( 'action' => 'deactivate',
																					'server_id' => $lcServerID,
																					'ip' => $lcIP,
																					'order' => $order,
																					'direction' => $direction
																					),
																	 new IconDataField( $lcIcon )
																 );
		}
		break;
	default:
		$lcTitle = ltext('seip_status_unknown');
		$lcIcon = cc_UnknownIcon;
		$loLink = new IconDataField( $lcIcon );
		break;
	}
	if( $lcTitle ){
		$loLink->AppendAttributes( array( 'title' => $lcTitle ) );
	}
	$loLink->ParentAttribute( 'align', 'center' );
	return $loLink;

}

function &createServer( &$poSrc ){

	list( $lcName, $lcHostname ) = $poSrc->listValue();
	$loName = new TextDataField( $lcName." ($lcHostname)");
	return $loName;
}

$loDS->Conversion( new CompoundValue( new ValueFormated( 'status', NULL, 'createStatusLink' ),
																			NULL,
																			NULL,
																			new ValueFormated( 'server', NULL, 'createServer' )
																			)
									 );

$loDS->doQuery();

$loPTV = new PagedTableView( $loDS, $total_number );

$loPTV->Title( $loTitle	);
$loPTV->Widths( $laWidths );
$loPTV->setParameter( 'menu_node_id', $menu_node_id );
$loPTV->setParameter( 'cur_page', $cur_page );
$loPTV->setParameter( 'head_text', $head_text );
	
$loPTV->setParameter( 'order', $order );
$loPTV->setParameter( 'direction', $direction );

$loPTV->Anchor( 'list' );
$loPTV->FormIndex( $listFormIndex );

if( ( isset( $ip_to_search ) && $ip_to_search  ) ||
	( isset( $server_to_search ) && $server_to_search ) ) {
	$loPTV->NoItemsMessage( ltext( 'll_empty_search' ) );
 }	else {
	$loPTV->NoItemsMessage( ltext( 'll_empty_list' ) );
 }


$tbl = $loPTV->GetOutputPresentation( array( 'action' => 'settings_ip.php#list',
																						 'method' => 'post',
																						 'name' => 'list_ip' ), 
																			ltext( 'seip_title2' ) );

$dsSearch = new CompoundValue();

$dsSearch->addValue( new KeyValue('ip_to_search',$ip_to_search) );
//
// select server
//
$dsSearch->addValue( new ValueLocale( 'alse_cell_server' ));

$loIter =& $dsServers->getFirstIterator();

$loServerSelect = new CompoundValue();
while( $loItem =& $loIter->getNext() ){
	
	list($lcServerID,$lcName,$lcHostname) = $loItem->listValue();
	
	$lcPrompt = $lcHostname;
	$loServerSelect->addValue( new KeyValue( 'server_to_search', $lcServerID ),
														 new KeyValue( 'name', $lcPrompt )
														 );
 }

$loServerSelect->addValue( new KeyValue( 'server_to_search', '' ),
													 new ValueLocale('ll_all' ) );
														 
$dsSearch->addValue( $loServerSelect );
$dsSearch->addValue( new ValueLocale( 'll_search' ) );
$dsSearch->addValue( new ValueLocale( 'll_show_all' ) );


$loSearch = new SimpleSearchElement( array(),
																		 new InputTextElement( array( 'name' => 'ip_to_search', 
																																	'size' => '16',
																																	'value' => $ip_to_search,
																																	'MAXLENGTH'=> '64' )
																													 ) ,
																		 new HTMLElement( '' ), // prompt
																		 new SelectElement(array( 'name' => 'server_to_search' )), 
																		 new PPButtonElement( '',
																													"javascript:submitForm('start_index',1,$listFormIndex)",
																													'bid-search'
																													),
																		 new PPButtonElement( '',
																													"javascript:setValue('ip_to_search','',$listFormIndex);".
																													"javascript:setValue('server_to_search','',$listFormIndex);".
																													"javascript:submitForm('start_index',1,$listFormIndex)",
																													'bid-search'
																													)
																		 );
$loSearch->setDataSource( $dsSearch, array( 'ip_to_search' => $ip_to_search,
																						'server_to_search' => $server_to_search) );

$tbl->setSearchElement( $loSearch );

$tbl->updateBodyContent();


$page = new MainPageElement( $loTools, $tbl ); 

$page->OutputHTML(array( '../../js/paged_form.js' ));

?>