<?
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( "auth.php" );
include_once( "../include/class.Traffic.php" );
include_once( "../include/class.SQLInteger.php" );
include_once( "../include/class.SQLString.php" );
include_once( "../include/elements/data/class.SetOfRowsData.php" );
include_once( "../include/elements/data/class.HTMLDataField.php" );
include_once( "../include/elements/data/class.TextDataField.php" );
include_once( "../include/elements/data/class.LinkDataField.php" );
include_once( "../include/elements/html/class.MainPageElement.php" );

#global $DEBUG;
#$DEBUG=1;

## mysql verbindung aufbauen
db_connect($db_host, $db_user, $db_pass);
## /mysql verbindung aufbauen

## gehoert kunde dem anbieter?
$id = safe_query2( "SELECT anbieter FROM kunden WHERE kunde = ? AND anbieter = ? AND server_id='$ServerID'",
									 new SQLString( $kunde ), new SQLString( $PHP_AUTH_USER ) );
if( db_num_rows( $id ) < 1 ){
	 db_close();
	 include("statistiken_start.php");
	 exit();
	}
db_free_query( $id );
## /gehoert kunde dem anbieter?
## 20060412: $jahr should only be empty or \d{4}
if( ! ( isset( $jahr ) && is_numeric( $jahr ) && preg_match('/^[0-9]{4}$/', $jahr ) ) ){
  $jahr = '';
 }
## 20060412: $monat should only be empty or between 1 and 12
if( ! ( isset( $monat ) && is_numeric( $monat ) && $monat >= 1 && $monat <= 12 ) ){
  $monat = '';
}

## aktuelles datum
if( $jahr ){
	$jahrstr = $jahr;
 } else { 
	$jahrstr = date('Y'); 
 }

if( ! $monat ){
	$monat = date( 'n' );
	$jahr = date( 'Y' );
}

$tag = date( 'j' );

$monatstr = $lang_months[$monat];
## /aktuelles datum

## ausfhrliche stats
#$id = db_query("select web, ftp, email, tag from transfer where kunde='$kunde' ".
#	       "and anbieter='$PHP_AUTH_USER' and jahr='$jahr' and monat='$monat' ".
#	       "and geloescht = 0 order by tag");
#while ($werte = db_fetch_array($id)){

$trfk = new Traffic();
$trfk->setLog($trafficLog);
$trfk->setFields('web','ftp','email','pop');
$trfk->setUser($kunde,0);
$trfk->setGroup('tag');
$trfk->setServerID( $ServerID );
$trfk->Order(array( 'tag' => 'desc' ) );
$trfk->monthlyQuery( $monat, $jahr );
$days = $trfk->getGroups();

foreach( $days as $tag ){

  $werte =  $trfk->getTraffic( false, $tag );

	$web = $werte['web'];
	$ftp = $werte['ftp'];
	$email = $werte['email']+$werte['pop'];
	#	 $tag = $werte['tag'];
	$gesamttmp = $ftp + $web + $email;
	if( $gesamttmp > 0 ){
		 $dtftp[] = $ftp;
		 $dtweb[] = $web;
		 $dtemail[] = $email;
		 $dtjahr[] = $jahr;
		 $dtmonat[] = $monat;
		 $dttag[] = $tag;
		 $dtgesamt[] = $gesamttmp;
		 $detailsgesamtgesamt += $gesamttmp;
		 $detailsgesamtftp += $ftp;
		 $detailsgesamtweb += $web;
		 $detailsgesamtemail += $email;
		}
	}

$detailsgesamtgesamt = $detailsgesamtweb + $detailsgesamtftp + $detailsgesamtemail;

## hoechsten gesamtwert ermitteln
for( $i = 0; $i < count( $dtgesamt ); $i++ ){
	 if( $maxgesamt < $dtgesamt[$i] ){
		 $maxgesamt = $dtgesamt[$i]; 
	 }
 }
## /hoechsten gesamtwert ermitteln

if ($maxgesamt == 0) { $maxgesamt = 1; }
## breite der balken bestimmen, maximale Breite=200pixel
for( $i = 0; $i < count($dtgesamt); $i++ ){
	 $ftptmp = round(($dtftp[$i] / $maxgesamt) * 200);
	 if ($ftptmp ==0) { $dtftpp100[] = 1; } else { $dtftpp100[] = $ftptmp; }
	 $webtmp = round(($dtweb[$i] / $maxgesamt) * 200);
	 if ($webtmp == 0) { $dtwebp100[] = 1; } else { $dtwebp100[] = $webtmp; }
	 $emailtmp = round(($dtemail[$i] / $maxgesamt) * 200);
	 if ($emailtmp == 0) { $dtemailp100[] = 1; } else { $dtemailp100[] = $emailtmp; }
	}
## /breite der balken bestimmen, maximale Breite=200pixel
## /ausfuehrliche stats

##############
## alle monate
$aktmonat = date( 'n' );
$jahr = date( 'Y' );

$trfk->setGroup(array('jahr','monat'));
$trfk->setYear(false);
$trfk->setMonth(false);
$trfk->Order( array( 'jahr'=>'desc', 'monat'=>'desc'));
$trfk->Query();
$monats = $trfk->getGroups();

foreach( $monats as $ym ){
	 
	list($jahr,$monat) = $ym;
	
	$werte =  $trfk->getTraffic(false,$ym);

	$web = $werte['web'];
	$ftp = $werte['ftp'];
	$email = $werte['email']+$werte['pop'];
	$gesamttmp = $ftp + $web + $email;
	if( $gesamttmp > 0 ){
		 $amjahr[] = $jahr;
		 $ammonat[] = $monat;
		 $amweb[] = $web;
		 $amftp[] = $ftp;
		 $amemail[] = $email;
		 $amgesamt[] = $gesamttmp;
		 $allesweb += $web;
		 $allesftp += $ftp;
		 $allesemail += $email;
		}
	}

$allesgesamt = $allesweb + $allesftp + $allesemail;

## hoechsten gesamtwert ermitteln
$maxgesamt = 0;
for( $i = 0; $i < count( $amgesamt ); $i++ ){
	 if( $maxgesamt < $amgesamt[$i] ){
		 $maxgesamt = $amgesamt[$i]; 
	 }
	}
# /hoechsten gesamtwert ermitteln

if ($maxgesamt == 0) { $maxgesamt = 1; }
# breite der balken bestimmen, maximale Breite=200pixel
for ($i = 0; $i < count($amgesamt); $i++)
	{
	 $ftptmp = round(($amftp[$i] / $maxgesamt) * 200);
	 if ($ftptmp ==0) { $amftpp100[] = 1; } else { $amftpp100[] = $ftptmp; }
	 $webtmp = round(($amweb[$i] / $maxgesamt) * 200);
	 if ($webtmp == 0) { $amwebp100[] = 1; } else { $amwebp100[] = $webtmp; }
	 $emailtmp = round(($amemail[$i] / $maxgesamt) * 200);
	 if ($emailtmp == 0) { $amemailp100[] = 1; } else { $amemailp100[] = $emailtmp; }
	}
# /breite der balken bestimmen, maximale Breite=200pixel
# gesamtwerte
# /gesamtwerte
# /alle monate
###############





/* -------------------- HTML - details -------------------- */
$details = new SetOfRowsData();
$html = ltext("stdetr_cell_ftpweb");
if( $show_emailtransfer )
	$html .= ' / ' . ltext("stdetr_cell_email");
$details->AppendHeaderRow( new HTMLDataField( ltext("stdetr_cell_day") ), new HTMLDataField( $html ),
		new HTMLDataField( ltext("stdetr_cell_total") ) );
for( $i=0; $i < count($dtgesamt); $i++ ) {
	$html = '<img src="/ftptransf.gif" width="' . $dtftpp100[$i] . '" height="12"><img src="/webtransf.gif" width="' .
		$dtwebp100[$i] . '" height="12">';
	if( $show_emailtransfer )
		$html .= '<img src="/emailtransf.gif" width="' . $dtemailp100[$i] . '" height="12">';
	$html .= '<br>' . sinnv_kbwert($dtftp[$i]) . ' / ' . sinnv_kbwert($dtweb[$i]);
	$details->AppendRow( new HTMLDataField( date( $lang_format_date, strtotime("$dtmonat[$i]/$dttag[$i]/$dtjahr[$i]") ) ),
			new HTMLDataField( $html ), new HTMLDataField( sinnv_kbwert($dtgesamt[$i]) ) );
}
$html = sinnv_kbwert($detailsgesamtftp) . ' / ' . sinnv_kbwert($detailsgesamtweb);
if( $show_emailtransfer )
	$html .= ' / ' . sinnv_kbwert($detailsgesamtemail);
$details->AppendHeaderRow( new HTMLDataField( ltext("stdetr_cell_total") ), new HTMLDataField( $html ),
		new HTMLDataField( sinnv_kbwert($detailsgesamtgesamt) ) );
/* -------------------- end HTML - details -------------------- */





/* -------------------- HTML - summary -------------------- */
$summary = new SetOfRowsData();
$summary->AppendHeaderRow( new HTMLDataField( ltext("stdetr_cell_month") ),
		new HTMLDataField( ltext("stdetr_cell_ftpweb") ), new HTMLDataField( ltext("stdetr_cell_total") ) );
for( $i=0; $i < count($amgesamt); $i++ ) {
	$field = $i < 3 ? new LinkDataField( "statistiken_details_transfer.php",
			"monat=$ammonat[$i]&jahr=$amjahr[$i]&kunde=$kunde", array(), "$ammonat[$i]/$amjahr[$i]" ) :
		new HTMLDataField( "$ammonat[$i]/$amjahr[$i]" );
	$html = '<img src="/ftptransf.gif" width="' . $amftpp100[$i] . '" height="12"><img src="/webtransf.gif" width="' .
		$amwebp100[$i] . '" height="12">';
	if( $show_emailtransfer )
		$html .= '<img src="/emailtransf.gif" width="' . $amemailp100[$i] . '" height="12">';
	$html .= '<br>' . sinnv_kbwert($amftp[$i]) . ' / ' . sinnv_kbwert($amweb[$i]);
	if( $show_emailtransfer )
		$html .= ' / ' . sinnv_kbwert($amemail[$i]);
	$summary->AppendRow( $field, new HTMLDataField($html), new HTMLDataField( sinnv_kbwert($amgesamt[$i]) ) );
}
$html = sinnv_kbwert($allesftp) . ' / ' . sinnv_kbwert($allesweb);
if( $show_emailtransfer )
	$html .= ' / ' . sinnv_kbwert($allesemail);
$summary->AppendHeaderRow( new HTMLDataField( ltext("stdetr_cell_total") ), new HTMLDataField( $html ),
		new HTMLDataField( sinnv_kbwert($allesgesamt) ) );
/* -------------------- end HTML - summary -------------------- */





/* -------------------- HTML - page -------------------- */
$page = new MainPageElement( '<b>' . ltext("stdetr_title1") . ' ' . $kunde . '</b>', ltext( "stdetr_descr1", $kunde ),
		$details->GetListPresentation( array(), ltext("stdetr_title2") . " $monatstr $jahrstr" ),
		$summary->GetListPresentation( array(), ltext("stdetr_cell_total") ) );
$page->OutputHTML();
/* -------------------- end HTML - page -------------------- */
?>
