<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( "auth.php" );
include_once( "../include/elements/data/class.PagedSetOfRowsData.php" );
include_once( "../include/elements/data/class.HTMLDataField.php" );
include_once( "../include/elements/data/class.LinkDataField.php" );
include_once( "../include/elements/data/class.TextDataField.php" );
include_once( "../include/elements/data/class.CompoundDataField.php" );
include_once( "../include/elements/data/class.IconDataField.php" );
include_once( "../include/module.Database.php" );
include_once( "../include/elements/html/class.MainPageElement.php" );
include_once("../include/cron_functions.php");
include_once( "../include/class.SQLInteger.php" );
include_once( "../include/class.SQLString.php" );



define( "cc_PersonalIcon", "pics/icons/user_personal.gif" );
define( "cc_DomainsIPIcon", "pics/icons/user_domains.gif" );
define( "cc_ServicesIcon", "pics/icons/user_services.gif");
define( "cc_PasswordIcon", "pics/icons/user_password.gif" );
define( "cc_DeleteIcon", "pics/icons/user_delete.gif" );
define( "cc_LockIcon", "pics/icons/user_lock.gif" );
define( "cc_ActiveIcon", "pics/icons/user_on.gif" );
define( "cc_LockedIcon", "pics/icons/user_off.gif" );
define( "cc_StateOkIcon", "pics/icons/state_ok.gif" );
define( "cc_StateAttIcon", "pics/icons/state_att.gif" );



/* -------------------- ff_CreateActionLink & ff_CreateHelp -------------------- */
function ff_CreateActionLink( $ps_Query, $ps_Icon, $ps_Title ) {
	$lo_Link = new LinkDataField( "kunden_aendern_fwd.php", $ps_Query, array(), new IconDataField($ps_Icon) );
	$lo_Link->AppendAttributes( array( "title"=>$ps_Title ) );
	// example of context help
	//"onMouseOver"=>"top.mouse_move('l_ttsquslist_name');", "onMouseOut"=>"top.mouse_move();"
	return $lo_Link;
}

function ff_CreateHelp( $ps_Icon, $ps_Help ) {
	$lo_Image = new IconDataField( $ps_Icon );
	$lo_Element = new CompoundElement( $lo_Image->GetOutputPresentation(), $ps_Help );
	$lo_Element->SetSeparator( " " );
	return $lo_Element;
}
/* -------------------- end ff_CreateActionLink & ff_CreateHelp -------------------- */





/* -------------------- HTML -------------------- */
$go_Data = new PagedSetOfRowsData( "users_list.php", "reseller_users_list" );
$go_Data->SetDefault();
$go_Data->AppendHeaderRow( new HTMLDataField( ltext("kuaeku_cell_state") ), new HTMLDataField( ltext("kuaeku_cell_status") ), new HTMLDataField( ltext("kuaeku_cell_user") ), new HTMLDataField( ltext("kuaeku_cell_name") ),
		new HTMLDataField( ltext("kuaeku_cell_domains") ), new HTMLDataField( ltext("kuae_cell_title1") ) );

$go_DB =& get_db_connection();

$go_Total =& $go_DB->Select( "SELECT COUNT(*) AS total FROM kunden".
                            " WHERE anbieter = ".db_full_quote($PHP_AUTH_USER)." AND server_id='$ServerID'" );
$ga_Row =& $go_Total->nextrow();
$go_Data->SetTotal( $ga_Row["total"] );

$go_Query =& $go_DB->Select( "SELECT kunde, name, firstname, gesperrt FROM kunden".
                            " WHERE anbieter = " . db_full_quote($PHP_AUTH_USER)." AND server_id='$ServerID'".
		                        " ORDER BY number", $go_Data->GetStep(), (int)($go_Data->GetStart()/$go_Data->GetStep()) );

while( $ga_Row =& $go_Query->nextrow() ) {
	$gs_Name = !istleer($ga_Row["name"]) || !istleer($ga_Row["firstname"]) ? $ga_Row["firstname"] . " " . $ga_Row["name"] :
		"";
	$go_Domains =& $go_DB->Select( "SELECT domain FROM domains WHERE kunde = " . db_full_quote($ga_Row["kunde"]) .
			                          " AND richtigedomain = 1 AND server_id='$ServerID' ORDER BY domain" );
	$go_UserDomains = new CompoundDataField();
	$go_UserDomains->SetSeparator(", ");
	
	while( $ga_Domain =& $go_Domains->nextrow() ) {
		if( strlen($ga_Domain["domain"]) ) {
			$go_UserDomain = new LinkDataField( "http://".$ga_Domain["domain"], "", array(), $ga_Domain["domain"]);
			$go_UserDomain->SetAttributes(array("target"=>"_blank"));
			$go_UserDomains->AppendToContent($go_UserDomain);
		}
	}
			
	if($ga_Row["gesperrt"]) $go_Status = ff_CreateActionLink( "kunde=" . urlencode($ga_Row["kunde"]) . "&aktion=sperren", cc_LockedIcon, $lang_text["kuaeku_status_locked"] );
	else $go_Status = ff_CreateActionLink( "kunde=" . urlencode($ga_Row["kunde"]) . "&aktion=sperren", cc_ActiveIcon, $lang_text["kuaeku_status_active"] );
		
	//if(checkLimits($ga_Row["kunde"])) $go_State = new IconDataField( cc_StateAttIcon );
	/*else*/ $go_State = new IconDataField( cc_StateOkIcon );

	$go_UserLink = new LinkDataField( "userredirect.php", "type=" . USERTYPE_USER . "&user=" . urlencode($ga_Row["kunde"]),
			array(), new TextDataField( $ga_Row["kunde"] ) );
	$go_UserLink->AppendAttributes( array( "target"=>"_blank" ) );
	$go_Actions = new CompoundDataField();
	$go_Actions->AppendToContent( ff_CreateActionLink( "kunde=" . urlencode($ga_Row["kunde"]) . "&aktion=personendaten",
				cc_PersonalIcon, ltext("kuae_cell_person") ) );
	$go_Actions->AppendToContent( ff_CreateActionLink( "kunde=" . urlencode($ga_Row["kunde"]) . "&aktion=leistungen",
				cc_ServicesIcon, ltext("kuae_cell_features") ) );
	$go_Actions->AppendToContent( ff_CreateActionLink( "kunde=" . urlencode($ga_Row["kunde"]) . "&aktion=domains",
				cc_DomainsIPIcon, ltext("kuae_cell_domain") ) );
	$go_Actions->AppendToContent( ff_CreateActionLink( "kunde=" . urlencode($ga_Row["kunde"]) . "&aktion=passwort",
				cc_PasswordIcon, ltext("kuae_cell_password") ) );
	$go_Actions->AppendToContent( ff_CreateActionLink( "kunde=" . urlencode($ga_Row["kunde"]) . "&aktion=loeschen",
				cc_DeleteIcon, ltext("kuae_cell_delete") ) );
	//$go_Actions->AppendToContent( ff_CreateActionLink( "kunde=" . urlencode($ga_Row["kunde"]) . "&aktion=sperren",
	//			cc_LockIcon, ltext("kuae_cell_block") ) );
	$go_Actions->SetSeparator( "" );
	$go_Actions->SetParentAttributes( array( "nowrap"=>NULL ) );
	$go_Data->AppendRow( $go_State, $go_Status, $go_UserLink, new TextDataField( $gs_Name ), $go_UserDomains, $go_Actions );
}

$go_Help = new CompoundElement(
		ff_CreateHelp( cc_PersonalIcon, ltext("kuae_cell_person") ),
		ff_CreateHelp( cc_ServicesIcon, ltext("kuae_cell_features") ),
		ff_CreateHelp( cc_DomainsIPIcon, ltext("kuae_cell_domain") ),
		ff_CreateHelp( cc_PasswordIcon, ltext("kuae_cell_password") ),
		ff_CreateHelp( cc_DeleteIcon, ltext("kuae_cell_delete") )
		//ff_CreateHelp( cc_LockIcon, ltext("kuae_cell_block") )
		);
$go_Help->SetSeparator( "<br>" );
$go_List = $go_Data->GetOutputPresentation( ltext("mk_edituser") );
$go_List->AppendHelp( $go_Help );
$go_List->SetWidths( "3%", "3%", "12%", "25%", "45%", "12%" );
$go_Page = new MainPageElement( $go_List );
$go_Page->OutputHTML();
/* -------------------- end HTML -------------------- */

function checkLimits($user)
{

	if(!$user) return 0;

	$id = safe_query( "select * from kunden where kunde = ?  AND server_id='$ServerID'", TRUE, new SQLString( $user ) );
	$werte = db_fetch_array($id);
	$id = db_query("SELECT * FROM admin WHERE server_id='$ServerID'");
	$admin = db_fetch_array($id);
	
	$maxpop = $werte["maxpop"];
	$maxkb = $werte["maxkb"];
	$kbhomedir = $werte["kbhomedir"];
	$kbdb = $werte["kbdb"];
	$kbgesamt = $kbhomedir + $kbdb;
	$maxmysql = $werte["maxmysql"];	
	$maxemail = $werte["maxemail"];
	$maxautoresponder = $werte["maxautoresponder"];
	$maxftp = $werte["maxftp"];	
	$maxtransfer = $werte["maxtransfer"];	
	$maxsubdomains = $werte["maxsubdomains"];
	$maxcronjobs = $werte["maxcronjobs"];
	$maxmaillist = $werte['maxmaillist'];
	if ( !$admin["majordomo"] ) $maxmaillist = 0;
	
	$id = safe_query( "select count(account) as pop from pop3 where kunde = ?  AND server_id='$ServerID'", TRUE, new SQLString( $user ) );
	$werte = db_fetch_array($id);
	$pop = $werte["pop"];
	
	$id = safe_query( "select count(account) as ftp from ftp where kunde = ?  AND server_id='$ServerID'", TRUE, new SQLString( $user ) );
	$werte = db_fetch_array($id);
	$ftp = $werte["ftp"];
	
	$id = safe_query( "select count(domain) as subdomains from domains where kunde = ?  and richtigedomain = 0 AND server_id='$ServerID'", TRUE, new SQLString( $user ) );
	$werte = db_fetch_array($id);
	$subdomains = $werte["subdomains"];
	
	$id = safe_query( "select count(ident) as email from email where kunde = ?  AND server_id='$ServerID'", TRUE, new SQLString( $user ) );
	$werte = db_fetch_array($id);
	$email = $werte["email"];
	
	$id = safe_query( "select count(ident) as autoresponder from autoresponder where kunde = ?  AND server_id='$ServerID'", TRUE, new SQLString( $user ) );
	$werte = db_fetch_array($id);
	$autoresponder = $werte["autoresponder"];
	
	$id = safe_query( "select count(datenbank) as mysql from mysql_datenbanken where kunde = ?  AND server_id='$ServerID'", TRUE, new SQLString( $user ) );
	$werte = db_fetch_array($id);
	$mysql = $werte["mysql"];
	
	$id = safe_query2("SELECT COUNT(*) AS cnt FROM maillist".
    	              " INNER JOIN domains ON ( domains.id = maillist.domain_id ) AND domains.server_id=maillist.server_id".
    	              " WHERE domains.kunde = ? AND maillist.server_id='$ServerID'", new SQLString( $user ));
	$werte = db_fetch_array($id);
	$maillist = $werte["cnt"];
	
	$anzahlcronjobs = count_cron_jobs_user($user);

	if (($kbgesamt > $maxkb) && ($maxkb <> -1)) return 1;
	
	if (($maxpop != 0) || ($pop != 0)) {
		if (($pop > $maxpop) && ($maxpop <> -1)) return 2;		
	}
	
	if (($maxemail != 0) || ($email != 0)) {		
		if (($email > $maxemail) && ($maxemail <> -1)) return 3;
	}
	
	if (($maxautoresponder != 0) || ($autoresponder != 0)) {		
		if (($autoresponder > $maxautoresponder) && ($maxautoresponder <> -1)) return 4;
	}
	
	if (($maxftp != 0) || ($ftp != 0)) {
		if (($ftp > $maxftp) && ($maxftp <> -1)) return 5;
	}
	
	if (($gesamttransfer > $maxtransfer) && ($maxtransfer <> -1)) return 6;
	
	if (($maxsubdomains != 0) || ($subdomains != 0)) {
		if (($subdomains > $maxsubdomains) && ($maxsubdomains <> -1)) return 7;
	}
	
	if (($maxmysql != 0) || ($mysql != 0)) {
		if (($mysql > $maxmysql) && ($maxmysql <> -1)) return 8;
	}
	
	if($maxcronjobs != 0) {
		if (($anzahlcronjobs > $maxcronjobs) && ($maxcronjobs <> -1)) return 9;
	}
	
	if($maxmaillist != 0) {
		if (($maillist > $maxmaillist) && ($maxmaillist <> -1)) return 10;
	}
	
	return 0;
}
?>
