<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( '../include/class.SQLInteger.php' );
include_once( '../include/class.SQLString.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.OptionsDataField.php' );
include_once( '../include/elements/data/class.ButtonData.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.LongTextDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/elements/html/module.Constants.php' );

db_connect($db_host, $db_user, $db_pass);

if( istleer( $ident ) ){
	 header("Location: ./email_autoresponder.php");
	 exit();
}

$loUser = new SQLString( $PHP_AUTH_USER );

$id = safe_query2( "SELECT admin.email as email, kunden.maxemail as maxemail, kunden.maxautoresponder".
                 " FROM admin, kunden where kunden.kunde = ? AND admin.server_id=kunden.server_id AND kunden.server_id='$ServerID'", 
                  $loUser );

list( $mail, $maxemail, $maxautoresponder ) = db_fetch_array( $id, 'N' );
db_free_query( $id );

if( ( $email == 0) || $maxemail == 0  ){
	$id = safe_query2( "SELECT COUNT(kunde) AS email FROM email WHERE kunde = ?  AND server_id='$ServerID'",
										 $loUser );
	list( $email ) = db_fetch_array( $id, 'N' );
	db_free_query( $id );
	
	if( $email == 0 ){
		$id = safe_query2( "SELECT COUNT(kunde) AS pop3 FROM pop3 WHERE kunde = ?  AND server_id='$ServerID'",
											$loUser );
		list( $pop3 ) = db_fetch_array( $id, 'N' );
		db_free_query( $id );
		
		if( $pop3 == 0 ){
			db_close();
			header("Location: ./noemail.php");
			exit();
		}
	}
 }

$loIdent = new SQLInteger( $ident );

$id = safe_query2( "SELECT prefix, domain FROM email WHERE ident = ? AND kunde = ? AND server_id='$ServerID'",
									 $loIdent, $loUser );
$werte = db_fetch_array( $id, 'A' );
db_free_query( $id );
$emailadresse = $werte["prefix"]."@".$werte["domain"];
$emailadresse2 = $emailadresse;
if( $emailadresse == '@' ){
	header("Location: ./email_autoresponder.php");
	exit();
 }

if( $ausdb != 'nein' ){
	$id = safe_query2( "SELECT * FROM autoresponder WHERE ident = ? AND server_id='$ServerID'", 
	                   $loIdent );
	while( $werte = db_fetch_array( $id ) ){
		$bearbeiten = 1;
		$emailtext = $werte["emailtext"];
		$emailbetreff = $werte["emailbetreff"];
		$absenderemail = $werte["absenderemail"];
		$absendername = $werte["absendername"];
	}
	db_free_query( $id );
 }

$id = safe_query( "SELECT COUNT(ident) AS autoresponder FROM autoresponder ".
									" WHERE kunde = ? AND server_id='$ServerID'",
									$loUser );
list( $autoresponder ) = db_fetch_array($id, 'N' );
db_free_query( $id );

if( ( $bearbeiten != 1 ) && ($autoresponder >= $maxautoresponder) &&
		($maxautoresponder != -1)) { 
	$fehlertext = ltext( 'emau2_error1' );
	db_close();
	include( 'email_autoresponder.php' );
	exit();
}

/* -------------------- HTML -------------------- */
$data = new SetOfRowsData();

if ($bearbeiten == 1) {
	$header_label = new HTMLDataField( ltext("emau2_cell_title")." ".$emailadresse." ".ltext("emau2_cell_title_text1") );
}
else {
	$header_label = new HTMLDataField( ltext("emau2_cell_title")." ".$emailadresse." ".ltext("emau2_cell_title_text2") );
}
$header_label->SetColSpan("2");
$data->AppendHeaderRow( $header_label );

$subj_field = new TextDataField( htmlspecialchars($emailbetreff), "emailbetreff" );
$subj_field->SetAttributes(array("size"=>"52"));
$data->AppendRow( new HTMLDataField( ltext("emau2_cell_subject") ), $subj_field );

$text_field = new LongTextDataField( htmlspecialchars($emailtext), "emailtext" );
$text_field->SetAttributes(array("cols"=>"50","rows"=>"8"));
$data->AppendRow( new HTMLDataField( ltext("emau2_cell_text") ), $text_field );

$id = safe_query2( "SELECT prefix, domain, ident FROM email ".
									 " WHERE kunde = ? AND prefix NOT LIKE '%*%' AND server_id='$ServerID'",
                   $loUser );
$emails_list = array();                   
while( $werte = db_fetch_array( $id ) ){
	$emailadresse = $werte["prefix"]."@".$werte["domain"];
	$ident2 = $werte["ident"];
	if ($bearbeiten != 1) {
		$emails_list[$emailadresse] = $emailadresse;
		if ($ident2 == $ident) $email_selected = $emailadresse;
	} 
	else {
		$emails_list[$emailadresse] = $emailadresse;
		if ($emailadresse == $absenderemail) $email_selected = $emailadresse;
	}
}
db_free_query( $id );

if( ! $emails_list ){ 
	$fehlertext = ltext('mail_au_no_from_mail_error');
	db_close();
	include('email_autoresponder.php');
	exit();
}

$email_field = new OptionsDataField($emails_list,$email_selected,"absenderemail");
$email_cell = new CompoundDataField();
$email_cell->SetSeparator("&nbsp;");
$email_cell->AppendToContent($email_field);
$email_cell->AppendToContent(new HTMLDataField( ltext("emau2_cell_sender1") ));
$data->AppendRow( new HTMLDataField( "&nbsp;" ), $email_cell );

$name_field = new TextDataField(htmlspecialchars($absendername),"absendername");
$name_cell = new CompoundDataField();
$name_cell->SetSeparator("&nbsp;");
$name_cell->AppendToContent($name_field);
$name_cell->AppendToContent(new HTMLDataField( ltext("emau2_cell_sender2") ));
$data->AppendRow( new HTMLDataField( "&nbsp;" ), $name_cell );

$data->AppendHidden( new TextDataField( $ident, "ident" ) );
$data->AppendHidden( new TextDataField( $bearbeiten, "bearbeiten" ) );

$data->AppendRow( new HTMLDataField( "&nbsp;" ), new ButtonData(($bearbeiten == 1)?ltext("emau2_btn_save"):ltext("emau2_btn_new"),"javascript:doChange()",cc_IDOk) );

$form = $data->GetInputPresentation( array( "action"=>"email_autoresponder3.php", "method"=>"post", "name"=>"autoresp" ), ltext("alst_cell_autoresponder") );

if ($bearbeiten == 1) {
    $data = new SetOfRowsData();
    $data->AppendHeaderRow( new HTMLDataField( ltext("emau2_cell_title2", array($emailadresse2)) ) );
    $data->AppendHidden( new TextDataField( $ident, "ident" ) );
    $data->AppendRow( new ButtonData(ltext('emau2_btn_del'),"javascript:document.loeschen.submit()",cc_IDOk) );
    $form2 = $data->GetInputPresentation( array( "action"=>"email_autoresponder_loeschen.php", "method"=>"post", "name"=>"loeschen" ), ltext("alst_cell_autoresponder") );
}

$page = new MainPageElement( $form, $form2 );
$page->OutputHTML(js_f_call_help('emau2_desc1', 'emau2_desc2'));
/* -------------------- end HTML -------------------- */

db_close();
?>