#!/usr/bin/perl

########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

# last error: 006

sub register_predefined_skins_300 {
	&inst_description("Registering predefined skins"); 
	my $dbh = &inst_db_connection();
	
	my $sth = $dbh->prepare("SELECT * FROM custom_skins");
	$sth->execute;
	unless (0 == $sth->rows) {
	    &inst_finish_skipped("'custom_skins' table is already filled with data.");
	    return 1;
	}
	
	$dbh->do("INSERT INTO custom_skins(id, name, show_name, owner_type, version, path) VALUES (1, 'skin_1', 'Blue Color Scheme', 'preinstalled', 'xp30', '/skins/skin_1')")
	    or die("Error #005 in routine customs_skins_300(): $DBI::errstr\n");
	$dbh->do("INSERT INTO custom_skins(id, name, show_name, owner_type, version, path) VALUES (2, 'skin_2', 'Green Color Scheme', 'preinstalled', 'xp30', '/skins/skin_2')")
	    or die("Error #006 in routine customs_skins_300(): $DBI::errstr\n");
	$dbh->do("INSERT INTO custom_skins(id, name, show_name, owner_type, version, path) VALUES (3, 'skin_3', 'Olivegreen Color Scheme', 'preinstalled', 'xp30', '/skins/skin_3')")
	    or die("Error #007 in routine customs_skins_300(): $DBI::errstr\n");
	$dbh->do("INSERT INTO custom_skins(id, name, show_name, owner_type, version, path) VALUES (4, 'skin_4', 'Red Color Scheme', 'preinstalled', 'xp30', '/skins/skin_4')")
	    or die("Error #008 in routine customs_skins_300(): $DBI::errstr\n");
	$dbh->do("INSERT INTO custom_skins(id, name, show_name, owner_type, version, path) VALUES (5, 'skin_5', 'Silver Color Scheme', 'preinstalled', 'xp30', '/skins/skin_5')")
	    or die("Error #009 in routine customs_skins_300(): $DBI::errstr\n");
		
	$dbh->do("INSERT INTO custom_skins(id, name, show_name, owner_type, version, path) VALUES (6, 'default', 'Confixx 2.0 Grey Color Scheme', 'preinstalled', 'classic20', 'skins/default')")
	    or die("Error #001 in routine customs_skins_300(): $DBI::errstr\n");
	$dbh->do("INSERT INTO custom_skins(id, name, show_name, owner_type, version, path) VALUES (7, 'skinblue', 'Confixx 2.0 Blue Color Scheme', 'preinstalled', 'classic20', 'skins/skinblue')")
	    or die("Error #002 in routine customs_skins_300(): $DBI::errstr\n");
	$dbh->do("INSERT INTO custom_skins(id, name, show_name, owner_type, version, path) VALUES (8, 'skingreen', 'Confixx 2.0 Green Color Scheme', 'preinstalled', 'classic20', 'skins/skingreen')")
	    or die("Error #003 in routine customs_skins_300(): $DBI::errstr\n");
	$dbh->do("INSERT INTO custom_skins(id, name, show_name, owner_type, version, path) VALUES (9, 'skinred', 'Confixx 2.0 Red Color Scheme', 'preinstalled', 'classic20', 'skins/skinred')")
	    or die("Error #004 in routine customs_skins_300(): $DBI::errstr\n");

	$dbh->do("INSERT INTO custom_skins(id, name, show_name, owner_type, version, path) VALUES (10, 'mskin_1', 'Modern Blue Color Scheme', 'preinstalled', 'powp', '/skins/mskin_1')")
	    or die("Error #005 in routine customs_skins_300(): $DBI::errstr\n");
	$dbh->do("INSERT INTO custom_skins(id, name, show_name, owner_type, version, path) VALUES (11, 'mskin_2', 'Modern Green Color Scheme', 'preinstalled', 'powp', '/skins/mskin_2')")
	    or die("Error #006 in routine customs_skins_300(): $DBI::errstr\n");
	$dbh->do("INSERT INTO custom_skins(id, name, show_name, owner_type, version, path) VALUES (12, 'mskin_3', 'Modern Olivegreen Color Scheme', 'preinstalled', 'powp', '/skins/mskin_3')")
	    or die("Error #007 in routine customs_skins_300(): $DBI::errstr\n");
	$dbh->do("INSERT INTO custom_skins(id, name, show_name, owner_type, version, path) VALUES (13, 'mskin_4', 'Modern Red Color Scheme', 'preinstalled', 'powp', '/skins/mskin_4')")
	    or die("Error #008 in routine customs_skins_300(): $DBI::errstr\n");
	$dbh->do("INSERT INTO custom_skins(id, name, show_name, owner_type, version, path) VALUES (14, 'mskin_5', 'Modern Silver Color Scheme', 'preinstalled', 'powp', '/skins/mskin_5')")
	    or die("Error #009 in routine customs_skins_300(): $DBI::errstr\n");

	if( $dbType eq 'Pg' ){
		$dbh->do( "SELECT SETVAL('custom_skins_id_seq', 15, false)" );
	}

	my $sth = $dbh->prepare( "SELECT MIN(id) FROM custom_skins ".
													 " WHERE version='powp' AND owner_type='preinstalled'" );
	if($sth->execute()){
		my( $id ) = $sth->fetchrow();
		$sth->finish();

		$sth = $dbh->prepare( "SELECT COUNT(*) FROM skins WHERE cuser='admin'");
		$sth->execute();
		my ($cnt) = $sth->fetchrow();
		if( $liCnt > 1 ){
			$dbh->do( "DELETE FROM skins WHERE cuser='admin'");
		}
		if( $liCnt == 1 ){
			$dbh->do( "UPDATE skins SET skin_id=$id WHERE cuser='admin'");
		} else {
			$dbh->do( "INSERT INTO skins (cuser, skin_id) VALUES ('admin',$id)");
		}
	}

	&inst_finish_ok();
	return 1;
}

sub upgrade_skins_300 {
	&inst_description("Upgrading skins"); 
	my $dbh = &inst_db_connection();
	
	$dbh->do("DELETE FROM skins")
	    or die("Error #006 in routine customs_skins_300(): $DBI::errstr\n");
	
	&inst_finish_ok();
}

1;
