package Modules::AWstats;

########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

BEGIN {
  use FindBin qw($Bin);
	use File::Basename;

	use lib $Bin=~s%(?<=.)/$%%?$Bin:$Bin, dirname($Bin);
	use lib dirname($Bin).'/admin/subs', dirname(dirname($Bin)).'/subs';
}

use Exporter ();
use File::Path;

use vars qw/@ISA @EXPORT/;

@ISA = qw(Exporter);
@EXPORT = qw(&changeAWstatsConf &removeAWstats);

use strict "vars";

use Modules::ConfixxLog qw(&soft_error &hard_error);
use lib_module_common qw(&ltext);
use Modules::File::SafeFile;
use File::Path;

# changeAWstatsConf(string user) create new awstats.user.conf
# @return void
# creates/updates a new awstats.user.conf for a given user
# or delete it if user is locked
sub changeAWstatsConf{
  my( $user ) = @_;
  if($::scriptdebug){
    my $subname = (caller(0))[3];
    print "SUB: $subname ($user)\n";
  }
  my $sth = $::dbh->prepare("SELECT uid,gesperrt,awstats FROM kunden WHERE kunde='$user' and server_id='$::ServerID'");
	$sth->execute or &soft_error("#2103: $DBI::errstr");

	my ($gid,$gesperrt,$user_awstats) = $sth->fetchrow();
	$sth->finish();
	
	my $configFile="$::awstats_conf_dir/awstats.$user.conf";
	
	if (($gesperrt || !$user_awstats) && -e $configFile){
		unless(unlink($configFile)){
			&soft_error("mlf||scripts_file_del||#1104||$configFile");
			return;
		}
		return 1;
	}								
  unless(-d "$::confixx_homeDir/awstats/$user"){
    unless( mkdir("$::confixx_homeDir/awstats/$user", 0755) ){
      &soft_error("mlf||scripts_dir_create||#1106||$::confixx_homeDir/awstats/$user");
			return;
		}
		chown("$::confixx_homeDir/awstats/$user",$::confixx_uid,$::confixx_gid);
  }

	# skip config writing if .lock file exists
	my $lockFile = "$::awstats_conf_dir/awstats.$user.lock";
	if (-e $lockFile){
		return;
	}
	
  $sth = $::dbh->prepare("SELECT domain,richtigedomain FROM domains WHERE kunde='$user' AND richtigedomain != 7 AND server_id='$::ServerID'");
  $sth->execute or &soft_error("#2232: $DBI::errstr");
	my @domains = ();
	my ($domain,$richtigedomain);
	my $i = 0;
	while(($domain,$richtigedomain) = $sth->fetchrow){
		#process wildcard subdomains
		if ($richtigedomain == 0 && $domain =~ /^\*\./g){
			$domain =~ s/^\*//g;
			$domain =~ s/\./\\\./g;
			$domain ="REGEX[.*$domain\$]";
		}
		$domains[$i++] = "$domain";
	}
	$sth->finish();
	my $user_domains = join (' ',@domains);
#
#copy awstats template and replace tokens
#
		my $template = "$::installDir/awstats.template.conf";
		unless (open(TMPL,$template)){
			&soft_error("mlf||scripts_file_open_read||#1192||$template");
			return;
		}
		my $conf = Modules::File::SafeFile->new($configFile,'w',0640,$::confixx_uid,$::gidapache);
		my $fh = $conf->IO_File();

		unless( $fh ){
			&soft_error("mlf||scripts_file_open_write||#1192||".$conf->File());
		  return;
		}
												
		while (<TMPL>){
			s/##user##/$user/g;
			s/##user_domains##/$user_domains/g;
			s/##user_home_dir##/$::user_homeDir/g;
			s/##confixx_home_dir##/$::confixx_homeDir/g;
			print $fh $_;
		}
		close(TMPL);
		$conf->closeFile();
#
#/copy awstats template and replace tokens
#
		return 1;
}


# remove user AWstats file  
sub removeAWstats{
  my($user,$keep_files) = @_;
	if($::scriptdebug){
	my $subname = (caller(0))[3];
	  print "SUB: $subname ($user)\n";
  }
  if(-d "$::confixx_homeDir/awstats/$user" && !$keep_files){
  unless(rmtree("$::confixx_homeDir/awstats/$user")){
      &soft_error("mlf||scripts_dir_del_rec||#1005||$::confixx_homeDir/awstats/$user");
			return;
		}
  }

  my $configFile="$::awstats_conf_dir/awstats.$user.conf";
	if (-e $configFile){
  	unless(unlink($configFile)){
    	&soft_error("mlf||scripts_file_del||#1104||$configFile");
    	return;
  	}
	}
	
	#remove .lock file
  my $lockFile = "$::awstats_conf_dir/awstats.$user.lock";
	if (-e $lockFile){
    unless(unlink($lockFile)){
      &soft_error("mlf||scripts_file_del||#1104||$lockFile");
      return;
    }
	}
					
	return 1;
}

## get descriptor for temporary file
return 1;

END {}
