package Modules::Apache::Config::Redirect;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

# $id: Redirect.pm, v 1.0 2003/11/7 $


use Modules::Apache::Config::DomainSet;
use Modules::Apache::Config::DomainSet ();

my $class = "Modules::Apache::Config::Redirect";


use strict('vars');

sub new {
  my $class = shift;
  my $self = {};

  bless($self, $class);

  my %args = (
	      'ip' => '127.0.0.1',
	      'url' => '',
	      'domain' => '',
	      'kunde' => '',
	      'level' => 0,
	      @_
	     );

  $self->{'_ip'}    = $args{'ip'};
  $self->{'_url'}   = $args{'url'};
  $self->{'_level'} = $args{'level'};
  $self->{'_kunde'} = $args{'kunde'};

  $self->{'_domainset'} = Modules::Apache::Config::DomainSet->new($args{'domain'});

  return $self;
}

sub setattr {
  my $self = shift;
  if ( @_){
    my %args = (
	      @_
	     );

    $self->{'_ip'}    =$args{'ip'}     if exists($args{'ip'});
    $self->{'_url'}   =$args{'url'}    if exists($args{'url'});
    $self->{'_level'} =$args{'level'}  if exists($args{'level'});
    $self->{'_kunde'} =$args{'kunde'}  if exists($args{'kunde'});

    if ( ref($self->{'_domainset'}) && exists($args{'domain'}) ){
      $self->{'_domainset'}->domain($args{'domain'});
    }
  }
}

sub copyfrom {
  my $self = shift;
  if ( @_){
    my $src = shift;
    if (ref($src) =~ /$class/){
      $self->{'_ip'} = $src->ip;
      $self->{'_url'} = $src->url;
      $self->{'_level'} = $src->level;
      $self->{'_kunde'} = $src->kunde;
      if ( defined($self->{'_domainset'} ) ) {
				$self->{'_domainset'}->copyfrom( $src->domainset );
      }
    }
  }
}


sub clone {
  my $class = shift;
  my $self = {};

  if ( @_){
    my $src=shift;
    if (ref($src) =~ /$class/){
      bless($self, $class);
      $self->copyfrom($src);
      return $self;
    }
  }
}


sub ip {
  my $self = shift;
  if (@_) {
    $self->{'_ip'}=shift;
  }
  return $self->{'_ip'};
}

sub url {
  my $self = shift;
  if (@_) {
    $self->{'_url'}=shift;
  }
  return $self->{'_url'};
}


sub level {
  my $self = shift;
  if (@_) {
    $self->{'_level'}=shift;
  }
  return $self->{'_level'};
}
sub kunde {
  my $self = shift;
  if (@_) {
    $self->{'_kunde'}=shift;
  }
  return $self->{'_kunde'};
}


sub domain {
  my $self = shift;
  if (defined($self->{'_domainset'})) {
    return $self->{'_domainset'}->domain(@_);
  }
  return undef;
}


sub isequiv {
  my $self = shift;
  my $ret;
  if (@_){
    my $pattern = shift;
    if (ref($pattern) =~ /$class/){
      $ret = $self->{'_ip'}       eq $pattern->ip   &&
	     $self->{'_url'}     eq $pattern->url &&
	     $self->{'_level'}    == $pattern->level &&
	     $self->{'_kunde'} == $pattern->kunde;

#	     $self->{'_domain'}     == $pattern->domain &&

    }
  }
  return $ret;
}

sub totext {
  my $self = shift;
  my $prefix =shift||'';
  my $ret='';
  my ($key,$val,$rec,$ref,$cnt,$i,$vkey,$vval);
  while (($key,$val)=(each %$self)){
    if ($key eq '_domainset' && defined($val) ){
      $ret.="$prefix$key:\t(".ref($val).")\n";
      $ret.=$val->totext("$prefix\t");
    }else{
      $ref = ref($val);
      if ($ref eq 'ARRAY'){
				$cnt = @$val;
				$ret .= "$prefix$key (array) $cnt:\n";
				for ($i = 0; $i < $cnt; $i++){
					$ret .= "$prefix\t[$i]:\t".$val->[$i]."\n";
				}

      } elsif ( $ref eq 'HASH' ) {
				$cnt = scalar(keys %$val);
				$ret .= "$prefix$key (hash) $cnt:\n";
				while ( ( $vkey,$vval ) = ( each %$val ) ) {
					$ret .= "$prefix\t$vkey\t=>\t$vval\n";
				}
      }
      else {
				if (defined ( $val ) ) {
					$ret.="$prefix$key\t=\t$val\n";
				}else{
					$ret.="$prefix$key\t=\tundef\n";
				}
      }
    }
  }
  return $ret;
}

sub indomains {
  my $self = shift;
  if (defined( $self->{_domainset})){
    return $self->{_domainset}->has(@_);
  }else{
    return 0;
  }
}

sub cntdomains {
  my $self = shift;
  if (defined( $self->{_domainset})){
    return $self->{_domainset}->count;
  }else{
    return 0;
  }
}

sub domainset {
  my $self = shift;
  return $self->{_domainset};
}

1;
