package Modules::Backup::Section;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

BEGIN {
  use Exporter;
  @ISA = qw(Exporter);
  @EXPORT_OK = qw(&new &Name &Base &Each  &Attribute
		  &Dirs &Files &addDir &addFile
		  &getPrepared &prepareEach &FileAttribute 
		  &checkIf &orAttributes &dirNames
		  );
#
#                &DirAttribute
#
}

use strict;
#no strict "vars";
no strict "refs";

use Modules::Backup::Dir;

sub new {
  my $classname = shift;
  my $args = {
							'name' => '',
							'base' => '',
							'each' => undef,
							@_
						 };

  my $this = {
							'name' => $args->{'name'},
							'base' => $args->{'base'},
							'dirs' => [],
							'files' => [],
							'files_attrs' => {},
							'dirs_attrs' => {},
							'attrs' => {},
							'each' => undef,
							're_each' => undef
						 };

  bless( $this, $classname );

	$this->Each( $args->{'each'} );

  return $this;
}

sub Name {
  my $this=shift;
  if (@_){
    $this->{'name'}=shift;
  }
  return $this->{'name'};
}

sub Base{
  my $this=shift;
  if (@_){
    $this->{'base'}=shift;
  }
  return $this->{'base'};
}

sub Each{
  my $this = shift;
  if( @_ ){
    my $each = shift;
		if( ref( $each ) =~ /Regexp/i ){
			$this->{'re_each'} = $each;
		}else{
			$this->{'each'} = $each;
			$this->{'re_each'} = qr/\Q$each\E/;
		}
  }
  return $this->{'each'};
}

sub Attribute{
  my $this = shift;
  my $name = shift;
  if (@_){
    $this->{'attrs'}->{$name} = shift;
  }
  return $this->{'attrs'}->{$name};
}

sub orAttributes{
  my $this = shift;
  my(@keys) = @_;
  my $ret = 0;
  foreach my $key (@keys){
    if ($this->{'attrs'}->{$key}){
      $ret=1;
      last;
    }
  }
  return $ret;
}

sub Dirs {
  my $this=shift;
  if (@_){
    @{$this->{'dirs'}}=@_;
  }
  return $this->{'dirs'};
}

sub dirNames {
  my $this=shift;
  my (@ret,$dir,$path);
  foreach  $dir (@{$this->{'dirs'}}){
    next unless (ref($dir)=~/Dir/);
    if($path=$dir->Path){
      push @ret, $path;
    }
  }
  return \@ret;
}

sub Files {
  my $this=shift;
  if (@_){
    @{$this->{'files'}}=@_;
  }
  return $this->{'files'};
}

sub addDir{
  my $this=shift;
  my $path=shift;
  my ($dir);
  if ($path){
    if($dir= Modules::Backup::Dir->new('path'=>$path)){
      push @{$this->{'dirs'}},$dir;
      $this->{'dirs_attrs'}->{$path}=$dir;
    }
  }
  return $dir;
}

sub addFile{
  my $this=shift;
  my $file=shift;
  if ($file){
    push @{$this->{'files'}},$file;
    $this->{'files_attrs'}->{$file}->{'name'}=$file;
  }
  return $file;
}

sub getPrepared {
  my $this = shift;
  my $arg = shift;
  my( $ret, $prefix, $suffix, $var );
  $suffix = $arg;
  $ret = '';
  while( $suffix ){
    ( $prefix, $var, $suffix ) = split(/\$/,$suffix,3);
    $ret .= $prefix;
    if( $var ){
      $var = "main::$var";
      if( defined( $$var ) ){
				$ret .= $$var;
      }else{
				return undef;
      }
    }
  }
  $ret .= $suffix;
  return $ret;
}

sub prepareEach ($$){
  my $this = shift;
  my $arg = shift;
  my $eachVal = shift;
  my $eachTmpl = shift || $this->{'re_each'};
  my $ret;
  
  if( ref( $arg ) =~ /Dir/ ){
    $ret = $arg->Path;
  }else{
    $ret = $arg;
  }
	if( ref( $eachTmpl ) =~ /Regexp/i ){
		$ret =~ s/$eachTmpl/$eachVal/g;
	}elsif( $eachTmpl ){
		$ret =~ s/\Q$eachTmpl\E/$eachVal/g;
	}
  return $ret;
}

sub FileAttribute {
  my $this=shift;
  my $file=shift;
  return undef unless (exists($this->{'files_attrs'}->{$file}));
  my $name=shift;
  if (@_){
    $this->{'files_attrs'}->{$file}->{$name}=shift;
  }
  return $this->{'files_attrs'}->{$file}->{$name};
}

sub DirAttribute {
  my $this=shift;
  my $path=shift;
  return undef unless (exists($this->{'dirs_attrs'}->{$path}));
  my $dir = $this->{'dirs_attrs'}->{$path};
  return unless (ref($dir)=~/Dir/);

  my $name=shift;
  if (@_){
    $dir->Attribute($name,shift);
  }
  return $dir->Attribute($name);
}

sub checkIf {
  my $this=shift;
  my $if=shift || $this->{'attrs'}->{if};
  return 1 unless $if;
  my ($left,$right,$var,$ret,$op,$lastRet);
  my ($tail,$head);

  my @chunks = split(/\s*(and|or)\s*/i,$if);
  foreach my $chunk (@chunks){
    if( $chunk=~/(\S+)\s+(like|\!?=)\s+(.+)/i){
      $left=$1;
      $op=$2;
      $right=$3;
      if ($left=~/^\$(\S+)\$$/){
	$var="main::$1";
	$left=$$var;
      }
      $right=~s/^\s*//;
      $right=~s/\s*$//;
      if($right=~/^\'(.*)\'$/){
	$right=$1;
      }elsif($right=~/^\"(.*)\"$/){
	$right=$1;
      }
      if($op =~/like/i){
	if ($right=~/^%(.+)/){
	  $right=$1;
	  $tail=1;
	}
	if ($right=~/(.+)%$/){
	  $right=$1;
	  $head=1;
	}
	if($tail){
	  if($head){
	    $lastRet = ($left=~/$right/);
	  }else{
	    $lastRet = ($left=~/$right$/);
	  }
	}else{
	  if($head){
	    $lastRet = ($left=~/^$right/);
	  }else{
	    $lastRet = ($left eq $right);
	  }
	}
      }elsif($op=~/=/){
	$lastRet = ($left eq $right);
      }elsif($op=~/\!=/){
	$lastRet = ($left ne $right);
      }
    }
    if($chunk=~/or/i){
      if ($ret || $lastRet){
	$ret = 1;
	last;
      }else{
	$ret ||= $lastRet;
      }
    }elsif($chunk=~/and/i){
      unless ($ret && $lastRet){
	$ret = 0;
	last;
      }else{
	$ret &&= $lastRet;
      }
    }else{
      $ret = $lastRet;
    }
  }
  $ret = 1 unless defined($ret);  ## default value TRUE
  return $ret;
}

return 1;
