package Modules::Backup::Task;

use URI;
use strict;

sub new {
	my $class = shift;
	my %args = ( 'id' => undef,
							 'user' => undef,
							 'src' => undef,
							 'dst' => undef,
							 'pass' => undef,
							 @_
						 );
	my $this = { 'user' => $args{'user'} || $args{'kunde'},
							 'src' => $args{'src'},
							 'dst' => $args{'dst'},
							 'pass' => $args{'pass'} || $args{'paswd'}
						 };
	if($args{'id'}){
		$this->{'id'} = $args{'id'};
	}

	bless ( $this, $class );

	return $this;
}

sub addId {
	my ( $this, $id ) = @_;
	if( $id ){
		if( exists $this->{'id'} ) {
			if ( ref($this->{'id'}) =~ /ARRAY/ ){
				push @{$this->{'id'}}, $id;
			} else {
				$this->{'id'} = [$this->{'id'},$id];
			}
		} else {
			$this->{'id'} = $id;
		}
	}
	return $id;
}

sub Id {
	my $this = shift;
	if( @_ ){
		$this->{'id'} = shift;
	}
	return $this->{'id'};
}

sub getArrayOfId {
	my $this = shift;
	my $ret = [];
	if( exists $this->{'id'}){
		if( ref($this->{'id'}) =~ /ARRAY/){
			$ret = $this->{'id'};
		} else {
			$ret = [$this->{'id'}];
		}
	}
	return $ret;
}

sub Src {
	my $this = shift;
	if(@_){
		$this->{'src'} = shift;
	}
	return $this->{'src'};
}

sub Dst {
	my $this = shift;
	if(@_){
		$this->{'dst'} = shift;
	}
	return $this->{'dst'};
}

sub Pass {
	my $this = shift;
	if(@_){
		$this->{'pass'} = shift;
	}
	return $this->{'pass'};
}

sub isFtp {
	my $this = shift;
	my $uri = URI->new( shift );
	return ( $uri->scheme eq 'ftp' && $uri->host && $uri->user );
}

sub getFtpSettings {
	my $this = shift;
	my $uri = URI->new( shift );

	return( $uri->host, $uri->user, $uri->password, $uri->path);
}

1;
