package Modules::Restore::Tables::Table_htaccess;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

BEGIN {
  use Exporter;
  @ISA = qw(Exporter);
  @EXPORT = qw( &post_restore_tab($$$$) &pre_restore_tab($$$$) );	
}

use XML::DOM;
use XML::DOM::NodeList;

use strict;

use Modules::Restore::Map;
use Modules::Restore::Table;
use Modules::Restore::DumpConfXML;
use Modules::Restore::DumpDoc;

use Modules::Restore::Tables::Common;
use Modules::Restore::Tables::Table_kunden;

my $maxPwschutzID;
my $maxFehlermeldungedID;

sub pre_restore_tab($$$$) {
  my ($table_name, $ptrConfXML,$clean,$xmlTable) = @_;
  unless ($table_name && ref($ptrConfXML)=~/DumpConfXML/){
    print STDERR "Table_htaccess::pre_restore_tab : wrong arguments ($table_name,..)\n";
    return 1;
  }

  my ($table,$tblName,$tbl);
  return 1 unless $table=$ptrConfXML->getTable($table_name);
  return 1 unless (ref($table)=~/Table/);


  $maxPwschutzID = calcMaxID('pwschutz',$ptrConfXML);
  $maxFehlermeldungedID = calcMaxID('fehlermeldunged',$ptrConfXML);

  return 1;
}


sub calcMaxID {
  my ($tableName,$ptrConfXML) = shift;
  my ($sql,$sth,$where,$newUser0,$maxID,$fldID);

  my $table=$ptrConfXML->getTable($tableName);
  return -1 unless(ref($table)=~/Table/); 

  unless ($main::map->get_rule("reseller(*).default")==$ASSIGN_CURRENT){
    $where = "(anbieter != 'res0')";
  }
  if ($newUser0 = $Modules::Restore::Tables::Table_kunden::newUser0){
    unless ($main::map->get_rule("user(*).default")==$ASSIGN_CURRENT){
      $where .= 'and' if $where;
      $where .= "(kunde != '$newUser0')";
    }
  }
  
  $maxID = $table->MaxID;
  $fldID = $table->AttrID;
  if ($fldID && ($where || ($maxID!~/\d+/))){
    $sql = "SELECT MAX($fldID) FROM $tableName" . ($where?" WHERE server_id='$::ServerID' AND $where":'');
    $sth = $::dbh->prepare($sql);
    if( $sth->execute ){
      ($maxID) = $sth->fetchrow;
      $sth->finish;
    }
    $maxID ||= 0;
  }
  return $maxID;
}

sub post_restore_tab($$$$) {
  my ($tblName,$ptrConfXML,$clean,$xmlTable)=@_;

  print "post restore table '$tblName'\n" if $::DEBUG;

  unless ($tblName && ref($ptrConfXML)=~/DumpConfXML/){
    print STDERR "Table_htaccess::post_restore_tab : wrong arguments ($tblName,..)\n";
    return 1;
  }

  my ($table,$sth,$sql,$user,$path,$sqlInsert,$sthInsert);
  unless (($table=$ptrConfXML->getTable($tblName)) && (ref($table)=~/Table/)){
    if($::DEBUG){
      print STDERR "Warning: Table_htaccess::post_restore_row: Table '$tblName' not found\n";
    }
    return 1;
  }

  my (%users,$ptrDirs,$dir);

  &selectUsers(\%users,'pwschutz',$ptrConfXML);
  &selectUsers(\%users,'fehlermeldungen',$ptrConfXML);

  $sqlInsert="insert into htaccess (kunde,pfad) values(?,?)";
  if ($sthInsert=$::dbh->prepare($sqlInsert)){

    while ( ($user,$ptrDirs) = each(%users)){
      foreach  $dir (keys %{$ptrDirs}){
				$sthInsert->execute($user,$dir);
      }
    }
  }else{
    print STDERR "Error: Table_htaccess: Can't prepare request: '$sqlInsert' - $DBI::errstr\n";
  }

  return 1;
}

sub selectUsers {
  my ($ptrUsers,$tableName,$ptrConfXML)=@_;
  unless(ref($ptrUsers)=~/HASH/){
    print STDERR "Error: Table_htaccess::selectUsers: malformed parameters\n";
    return 0;
  }
  my $table=$ptrConfXML->getTable($tableName);
  return 0 unless(ref($table)=~/Table/);

  my ($where,$sth,$sql,$newUser0,$user,$dir);

  if ($main::map->get_rule("reseller(*).default")==$ASSIGN_CURRENT){
    $where = "(anbieter != 'res0')";
  }
  if ($newUser0 = $Modules::Restore::Tables::Table_kunden::newUser0){
    if ($main::map->get_rule("user(*).default")==$ASSIGN_CURRENT){
      $where .= ' AND ' if $where;
      $where .= "(kunde != '$newUser0')";
    }
  }  

  $sql = "SELECT kunde,pfad FROM $tableName WHERE server_id='$::ServerID'";
  if( $where ){
    $sql .= " AND $where";
  }

  $sth=$main::dbh->prepare($sql);
  if($sth->execute){
    while (($user,$dir) = $sth->fetchrow){
      unless (exists($ptrUsers->{$user})){
	$ptrUsers->{$user}={$dir=>1};
      }else{
	$ptrUsers->{$user}->{$dir}=1;
      }
    }
  }else{
    print STDERR "Error: Table_htaccess::selectUsers: can not execute sql-request: $sql\n$DBI::errstr\n";
    return 0;
  }
  return 1;
}

1;

