package Modules::Restore::Tables::Table_skins;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

use DBI;

use XML::DOM;
use XML::DOM::NodeList;

use Modules::Restore::Map;
use Modules::Restore::Table;
use Modules::Restore::DumpConfXML;
use Modules::Restore::DumpDoc;

use Modules::Restore::Tables::Common;
use Modules::Restore::Tables::Common qw(&update_query &insert_query);

use strict;

sub clean_tab($$){
  my ($table_name, $ptrConfXML) = @_;
  unless ($table_name && ref($ptrConfXML)=~/DumpConfXML/){
    print STDERR "Table_skins::clean_tab : wrong arguments ($table_name,..)\n";
    return 1;
  }
  my ($table);

  unless($table=$ptrConfXML->getTable($table_name)){
    print STDERR "Table_skins::clean_tab : table '$table->StateClean' is  found\n";
    return 1;
  }

  return 0 if $table->StateClean;

  my $sql = "DELETE FROM $table_name WHERE server_id='$::ServerID' AND NOT (cuser IN ('res0','admin'))";
  if( $main::dbh->do( $sql ) ){
    $table->StateClean( 1 );
  }else{
    print STDERR "Table_skins::clean_tab : sql-error $main::dbh->errstr\n";
  }
  
  return 0;
}

sub restore_row($$$){
  my ($table_name, $ptrRow, $ptrTable) = @_;

  return 1 unless (ref($ptrTable)=~/Table/);
  my ($key,$newID,$cnt,$sql,$sth);

  my $clean = $::objDumpDoc->AttrClean;
  my $insert = 1;

  my $defaultRule = $main::map->get_rule("$table_name(*).default");

#
# map field 'cuser'
#
  my $ID = $ptrRow->{'cuser'};
  if( $ID =~ /^res(\d+)$/ ){
    if( $1 > 0 ){ ## real reseller
      $key = "reseller($ID).name";
      if( $newID = $main::map->get_attr( $key ) ){
				$ID = $newID;
				$ptrRow->{'cuser'} = $newID;
      }
    }else{
      if($::map->get_rule('reseller(*).default') == $ASSIGN_CURRENT ){
				return 0; # skip for build-in reseller
      }
    }
  }
  my $where = "cuser='$ID'";

#
# map field 'skin_id'
#
  if( $ID = $ptrRow->{'skin_id'} ){
    $key = "custom_skins($ID).id";
    $newID = $main::map->get_attr( $key );
    if( $newID =~ /^\d+$/ ){
      $ptrRow->{'skin_id'} = $newID; ## has mapping
    }else{
#
# check existing of skin
#
      $sql = "SELECT id FROM custom_skins WHERE server_id='$::ServerID' AND id=$ID";
      $sth = $main::dbh->prepare( $sql );
      if( $sth->execute() ){
				unless ($sth->rows){
					$ptrRow->{'skin_id'} = 0; ## default skin;
				}
				$sth->finish;
      }else{
				print STDERR "Tables_skins::restore_row : sql-error $sth->errstr\n";
      }
    }
  }
#
# check dublicate
#
  $sql = "SELECT COUNT(cuser) FROM $table_name WHERE server_id='$::ServerID' AND $where";
  $sth = $main::dbh->prepare( $sql );
  if( $sth->execute && $sth->rows ){
    ($cnt) = $sth->fetchrow;
    $sth->finish;
  }
  if( $cnt ){
    if( $defaultRule==$ASSIGN_CURRENT ){
      return 0;  ## skip if exists
    }else{
      $insert=0;  ## update
    }
  }

  if($insert){

    &Modules::Restore::Tables::Common::insert_query($table_name, $ptrRow);
    $ptrTable->StateClean(0);

  }else{

    delete($ptrRow->{'cuser'});
    &Modules::Restore::Tables::Common::update_query($table_name, $ptrRow, $where);

  }

  return 0;
}


1;
