#!/usr/bin/perl 

########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

$db_address = 'DBI:mysql:confixx1:localhost;mysql_socket=/var/lib/mysql/mysql.sock';
$dbUser = 'confixx';
$dbPw = 'confixx';
$ServerID = '';

use Getopt::Long;
use DBI;
use Pod::Usage;

sub printHelp {
  use File::Basename;
  my $script = &basename($0);
  print << "HELP";
usage:
	$script [<options>]

options:
  -ot|--object-type <number>      id of object type
  -oi|--object-id <number>        id of object
  -op|--object-prop <string>      property of object
  -et|--event-type <number>       id of event type
  -c |--count <count>               count of events (default 1)
  -e |--event <number>            event code
  -ep|--event-prop <string>       property of event
  -d |--debug <debug-level>        default 0
  -h |--help

HELP
  exit 0;
}

Getopt::Long::Configure('prefix_pattern=--|-','ignore_case');
my @args_config = (
  'object-type|ot=i',
  'object-id|oi=i',
  'object-prop|op=s',
  'event-type|et=i',
  'count|c=i',
  'event|e=i',
  'event-prop|ep=s',		
  'debug|d=i',
  'version|v',
  'help',
  'h'
);


unless( &GetOptions(\%args, @args_config) ){
  pod2usage({ -msg => "$0: Errors in the command line found",
	-exitval => 1} );
}

if ( $args{'h'} ){
  pod2usage( -exitval => 0);
}

if ( $args{'version'} ){
  print "\confixx_event.pl Confixx v.3.00\n";
  exit 0;
}

if ($args{'help'}){
  pod2usage( -verbose => 2, -exitval => 0);
}


my $obj_type=$args{'object-type'};

unless (defined($obj_type) && ($obj_type=~/^\d+$/)){
   pod2usage( {-msg => "\n$0: Error: no type of object given\n", 
	-exitval => 2} );
}
my $where="server_id='$ServerID' AND object_type=$obj_type ";

my $obj_id=$args{'object-id'};
my $obj_prop=$args{'object-prop'};
unless ($obj_id=~/^\d+$/||defined($obj_prop)){
   pod2usage( {-msg => "\n$0: Error: no object given\n", 
	-exitval => 2} );
}
if ($obj_id=~/^\d+$/){
  $where.=" AND object_id=$obj_id ";
}else{
  $where.=" AND object_prop='$obj_prop' ";
}

my $event_type = $args{'event-type'};
unless (defined($event_type) && ($event_type=~/^\d+$/)){
   pod2usage( {-msg => "\n$0: Error: no type of event given\n", 
	-exitval => 2} );
}
$where.=" AND event_type=$event_type";

my $count=$args{'count'}||1;
my $event=$args{'event'};
my $event_prop=$args{'event-prop'};

my $sql="SELECT id FROM events WHERE $where";

$dbh = DBI->connect($db_address, $dbUser, $dbPw)
  or die("Can't connect to database\n$DBI::errstr\n");

my $sth=$dbh->prepare($sql);
$sth->execute;
if ($sth->rows){
  $sql = "UPDATE events SET count=count+$count ";
  
  if (defined($event)){
    $sql.=", event=$event";
  }
  if  (defined($event_prop) ){
    $sql.=", event_prop='$event_prop'";
  }
  $sql.=" where $where";

}else{
  $sql = "INSERT INTO events (server_id,object_type, event_type, count";
  if (defined($obj_id)){
    $sql.=", object_id";
  }else{
    $sql.=", object_prop";
  }
  if (defined($event)){
    $sql.=", event";
  }
  if (defined($event_prop)){
    $sql.=", event_prop";
  }
  $sql.=") values ('$ServerID',$obj_type,$event_type,$count";
  if (defined($obj_id)){
    $sql.=", $obj_id";
  }else{
    $sql.=", '$obj_prop'";
  }
  if (defined($event)){
    $sql.=", $event";
  }
  if (defined($event_prop)){
    $sql.=", '$event_prop'";
  }
  $sql.=")";
}
$sth->finish;
$dbh->do($sql) or die "$0: Error of sql-executing\n$DBI::errstr\n";
$dbh->disconnect;

__END__

=head1 NAME

confixx_event.pl - the tool of Confixx. Version 3.00

=head1 SYNOPSIS

confixx_event.pl [options]

options: --object-type E<lt>numberE<gt>
         [--object-id E<lt>numberE<gt> | --object-prop E<lt>stringE<gt>]
         --event-type E<lt>numberE<gt>
         --count E<lt>countE<gt>
         --event E<lt>numberE<gt>
         --event-prop E<lt>stringE<gt>
         --help
         --debug

=head1 OPTIONS

=over 4

=item B<-ot | --object-type>

the ident number  of type of object

=item B<-oi | --object-id>

the ident number  of object

=item B<-op | --object-prop>

the property  of object

=item B<-et | --event-type>

the ident number of type of event

=item B<-c | --count>

count of events. Defaul 1.

=item B<-e | --event>

the event code.

=item B<-ep | --event-prop>

the property  of event

=item B<-d|--debug>

the debug level. Default 0

=item B<--help>

full documentation

=back

=head1 USAGE

in F<aliases>:

<e-mail>: "|/usr/bin/confixxevent.pl [options]"

=cut
