BEGIN {
	use FindBin;
	use File::Basename;

	use lib $FindBin::Bin=~s%(?<=.)/$%%?$FindBin::Bin:$FindBin::Bin;
	use lib dirname( dirname( $FindBin::Bin )); # = $installDir 
}

package lib_module_master;

use Exporter;
use Cwd;
use File::Copy;

use DBI;

use lib_module_common;
use lib_module_common 'loadConfFile';

use lib_module_db;
use lib_module_events;
use Modules::System;

use strict;
use vars qw(@ISA @EXPORT @EXPORT_OK);


@ISA = qw( Exporter );

@EXPORT = qw/ &installMasterConfixx &updateMasterConfig 
							&createMasterDB &createMasterUser &updateMasterConfig
							&readMasterConfig &writeMasterConfig &writeMasterPhpConfig
							&connectToMaster &rewriteScripts &getFieldsInfo
							&backupMaster &initConnection &initDisconnection
							&disconnectFromMaster /;

my( $DEBUG );

sub checkLicence{
	my $server_id = shift || $::ServerID;
	my $sth = $::dbh->prepare("SELECT version FROM register WHERE server_id = '$server_id'" );
	my( $ver,$ret_ver );
	if( $sth->execute ){
		while (($ver) = $sth->fetchrow){
			$ret_ver = $ver unless $ver =~ /add/;
			if( $ver =~ /dc/ ){
				$sth->finish;
				return 1;
			}
		}
	}
	$sth->finish;
	return ( undef, $ret_ver );
}

sub initDisconnection{
	unless( $::master_confixx ){
		warn "The local Confixx is not in a datacenter\n";
		return;
	}

	unless( &checkLicence() ){
		warn "The Conifxx has not a valid licence\n";
	}

	my %args = ( 'dbh' => $::dbh,
							 'object_type' => $::OBJECT_SERVER,
							 'object_prop' => $::ServerID,
							 'event_type' => $::EVENT_DISCONNECT
						 );

	if( &lib_module_events::eventAdd( %args )  ){
		$::master_confixx = 1;
	}else{
		$::master_confixx = 0;
		&soft_error( "Error add event to init disconnection from datacenter" );
	}
	
}

sub initConnection{
	if( $::master_confixx == 1 ){
		warn "The local Confixx is already in a datacenter\n";
		return;
	}
	
	if( $::db_master_dsn eq $::db_address ){
		warn "The local Confixx is already in the dataceneter\n";
		return;
	}

	unless( $::master_confixx  ){
		warn "The datacenter is not activated\n";
		return;
	}

	unless( &checkLicence() ){
		warn "The Conifxx has not a valid licence\n";
	}

	my $masterDbh = DBI->connect( $::db_master_dsn,
																$::dbMasterUser,
																$::dbMasterPw ) or
																	die "Error of database's connection: DBI::errstr\n";

	my $sth = $masterDbh->prepare("SELECT server_id FROM admin WHERE server_id='$::ServerID'");
	if( $sth->execute && $sth->rows ){
		$masterDbh->do( "DELETE FROM admin WHERE server_id='$::ServerID'" );
	}
	$sth->finish;

	my $localDbh = DBI->connect( $::db_local_dsn,
															 $::dbLocalUser,
															 $::dbLocalPw ) or
																 die "Error of database's connection: DBI::errstr\n";

	$sth = $localDbh->prepare( "SELECT * FROM admin WHERE server_id='$::ServerID'" );
	my( $confixx_domain );
	if( $sth->execute && $sth->rows ){
		my $ptrRow = $sth->fetchrow_hashref();
		$confixx_domain = $ptrRow->{'confixx_domain'};
		$confixx_domain = $ptrRow->{'standarddomain'} unless $confixx_domain;
		$ptrRow = &prepareRow( $ptrRow, $sth );
		my( $flds, $vals ) = &makeSqlInsert( $ptrRow );
		
		my $sql = "INSERT INTO admin ( $flds ) VALUES ( $vals )";

		unless( $masterDbh->do( $sql ) ){
			warn "Error sql query: $DBI::errstr\n";
			return;
		}
	}
	$sth->finish;

	my($cnt,$sql);
	
	$sth = $masterDbh->prepare( "SELECT COUNT(*) FROM server WHERE server_id='$::ServerID'");
	if( $sth->execute ){
		($cnt) = $sth->fetchrow();
		$sth->finish;
	}
	if( $cnt ){
		$sql = "UPDATE server SET status=1 WHERE server_id='$::ServerID'";

	}else{
		$confixx_domain =~ s/\..*$//; ## keep the first word
		$sql = "INSERT INTO server(name,status,server_id) VALUES('$confixx_domain',1,'$::ServerID')";
	}

	$masterDbh->do( $sql );

	$masterDbh->disconnect;

	my $data = "dsn=$::db_master_dsn;user=$::dbMasterUser;pass=$::dbMasterPw";


	my %args = ( 'dbh' => $localDbh,
							 'object_type' => $::OBJECT_SERVER,
							 'object_prop' => $::masterServerID,
							 'event_type' => $::EVENT_CONNECT,
							 'data' => $data,
						 );

	unless( &lib_module_events::eventAdd( %args )  ){
		warn "Error add event to init connection to datacenter\n";
	}

	$localDbh->disconnect;
}


sub getFieldsInfo{
	my $currTable = shift;
	my $dbh = shift;
	unless( ref($dbh)=~/DBI/){
		unshift @_, $dbh;
		$dbh = $::dbh;
	}

	my $sth = $dbh->prepare( "SHOW FIELDS FROM $currTable" );
	unless( $sth->execute ){
		warn "DBI::errstr\n";
		return;
	}
	my %fields = ();
	my @prim = ();
	my( $type, $currField );
	while( my $row = $sth->fetchrow_hashref ){

		if( $row->{'Type'} =~ /char|blob|text|enum/i ){
			$type = 'C';

		}elsif($row->{'Type'} =~ /time|date/i ){
			$type = 'T';

		}elsif($row->{'Type'} =~ /int/i ){
			$type = 'I';

		}else{
			$type = undef;
		}
		$currField = lc( $row->{'Field'} );
		$fields{ $currField } = $type;
		if( $row->{'Key'} =~ /^PRI$/i  ){
			push @prim,$currField;
		}
	}

	my($primKey);
	if( @prim ){
		$primKey = [sort @prim];
	}
	$sth->finish;

	return ( \%fields, $primKey );

}

sub installMasterConfixx {

	my $dbh = $::dbh;

	&::safe_do( "$::installDir/admin/subs/subs_include_modules.pl" );
	&::safe_do( "$::installDir/admin/subs/subs_include_questions.pl" );

	&::checkAndInstallPkgs( 'DBD::mysql' );

	my($ret,$errmsg) = &::useModule('DBD::mysql');
	unless( $ret ) {
		die( $errmsg."\n".
				 &ltext('install_question_module_load', 'DBD::mysql') );
	}

	$::mysqlMasterServer = &::ServerQuestion( &ltext('install_question_master_server') , $::mysqlUserServer || $::dbServer );

	if( $::mysqlMasterServer eq $::mysqlUserServer ){
		$::mysqlMasterAdmin = $::mysqlUserUser;
		$::mysqlMasterAdminPw = $::mysqlUserPw;	
		$::mysqlMasterPort = $::mysqlUserPort;
		$::mysqlMasterHost = $::mysqlUserHost;
		$::mysqlMasterVersion = $::mysqlUserVersion;

	}else{
		# request for 'root' credentials on another box

		( $::mysqlMasterServer,
			$::mysqlMasterAdmin,
			$::mysqlMasterAdminPw,
			$::mysqlMasterPort ) = &::configRootDbAccess( 'mysql', $::mysqlMasterServer);
		my ($ptrHash, $errstr);

		($ptrHash, $errstr) = &::getMysqlInfo( { 'user' => $::mysqlMasterAdmin,
																						 'server' => $::mysqlMasterServer,
																						 'password' => $::mysqlMasterAdminPw,
																						 'port' => $::mysqlMasterPort
																					 } );
		if ( $ptrHash ) {
			if( $::mysqlMasterServer =~ /localhost|127\.0\.0\.1/ ){
				$::mysqlMasterHost = $::mysqlMasterServer;
			}else{
				( undef, $::mysqlMasterHost ) = split( /@/, $ptrHash->{'current user'});
			}			
			$::mysqlMasterVersion = $ptrHash->{'server version'};
		} else {
			print STDERR "Error: unable to connect to database: $errstr\n";
		}

		unless ( $::mysqlMasterHost ) {
			if( $::mysqlMasterServer =~ /localhost|127\.0\.0\.1/ ){
				$::mysqlMasterHost = $::mysqlMasterServer;
			} else {
				$::mysqlMasterHost = $::hostname;
			}
		}
	}

	$::dbMasterDB = &::Question( &ltext('install_question_master_mysqldb'),  'confixx_master' );
	$::dbMasterUser = &::Question( &ltext('install_question_mysqluser', $::dbMasterDB) , 'confixx_master' );
	$::dbMasterPw = &::createRandPw();
	$::dbMasterServer = $::mysqlMasterServer;
	$::dbMasterPort = $::mysqlMasterPort;

	my $hostInfo = ($::mysqlMasterServer =~ /localhost|127\.0\.0\.1/) ?
		$::hostname :
		$::mysqlMasterServer;

	$hostInfo .= ':'.$::mysqlMasterPort if $::mysqlMasterPort =~ /^\d+$/;

	$::masterServerID = &Modules::System::generateServerID( 'Master',
																													$hostInfo );

	my( $server_id, $login, $longpw) = &createMasterDB();

	my $newMaster = 1;

	if( $server_id ){
		if( $login && $longpw ){
			$::masterServerID = $server_id;
			$newMaster = 0;
		}
	}
	if( &createMasterUser() ){

		my( $sth, $confixx_admin_user, $confixx_admin_pw_crypt, $ptrAdmin, $ptrRes0,
				$master_admin_user, $master_admin_pw_crypt, $master_admin_pw );

		$sth = $dbh->prepare( "SELECT * FROM admin WHERE server_id='$::ServerID'");
		if( $sth->execute() ){
			$ptrAdmin = $sth->fetchrow_hashref();
			$confixx_admin_user = $ptrAdmin->{'login'};
			$confixx_admin_pw_crypt = $ptrAdmin->{'longpw'};
			$sth->finish();
		}

		$sth = $dbh->prepare( "SELECT * FROM anbieter WHERE anbieter='res0' ".
													" AND server_id='$::ServerID'" );
		if( $sth->execute() ){
			$ptrRes0 = $sth->fetchrow_hashref();
			$sth->finish();
		}

		if( $login && $longpw ){
			$confixx_admin_user = $login;
			$confixx_admin_pw_crypt = $longpw;
		}

    $master_admin_user = &::Question( &ltext('install_question_master_adminuser'), 
																		'Master' );
		if( $master_admin_user eq $confixx_admin_user  &&
				$confixx_admin_pw_crypt eq $ptrAdmin->{'longpw'} ){

			$master_admin_pw_crypt = $confixx_admin_pw_crypt;

		}else{
			$master_admin_pw = &::PassQuestion( &ltext('install_question_adminpass', $master_admin_user) , ' ');
			my $salt = join '', map{('.', '/', 0..9, 'A'..'Z', 'a'..'z')[rand 68]}(1..2);
			$master_admin_pw_crypt = crypt($master_admin_pw, $salt);
		}

		$::db_master_dsn ||= &makeDSN( 'mysql',
																	 $::mysqlMasterServer,
																	 $::dbMasterDB,
																	 $::mysqlMasterPort );
		
		my $dbhMaster = DBI->connect( $::db_master_dsn,
																	$::dbMasterUser,
																	$::dbMasterPw
																) or
																	die &ltext('db_connect', '#2001', $DBI::errstr);

		
		unless( $newMaster ){
			$dbhMaster->do( "UPDATE admin SET longpw='$master_admin_pw_crypt', master=1 ".
											" WHERE server_id='$::masterServerID'" ) or
												warn "DBI::errstr\n";
		}else{
			my($fields, $values, $sql, $persInfoID, $ptrRow, $key);

			if( $ptrAdmin->{'personalinfoid'} ){
				$sth = $dbh->prepare( "SELECT * FROM personalinfo WHERE server_id='$::ServerID' AND id=".$ptrAdmin->{'personalinfoid'} );
				if( $sth->execute() ){
					if( $ptrRow = $sth->fetchrow_hashref() ){
						delete $ptrRow->{'id'};
						$ptrRow->{'server_id'} = $::masterServerID;
						$ptrRow = &prepareRow( $ptrRow, $sth );
						$sth->finish();
						
						( $fields, $values ) = &makeSqlInsert( $ptrRow );
						$sql = "INSERT INTO personalinfo ( $fields ) VALUES ( $values )";
						if( $dbhMaster->do( $sql ) ){
							$sth = $dbhMaster->prepare( "SELECT LAST_INSERT_ID()" );
							if( $sth->execute ){
								($persInfoID) = $sth->fetchrow();
							}
						}
					}
				}
			}

			$dbhMaster->do("INSERT INTO server(server_id,name) ".
										 " VALUES('$::masterServerID', 'Datacenter')" ) or
											 warn "DBI::errstr\n";
			
			my %admin = ( 'login' => [$master_admin_user, 'C'],
										'longpw' => [$master_admin_pw_crypt,'C'],
										'server_id' => [$::masterServerID, 'C'],
										'hostname' => [$ptrAdmin->{'hostname'},'C'],
										'language' => [$ptrAdmin->{'language'},'C'],
										'postconf' => $ptrAdmin->{'postconf'},
										'business' => $ptrAdmin->{'business'},
										'checkupdates' => $ptrAdmin->{'checkupdates'},
										'confixx_ip' => [$ptrAdmin->{'confixx_ip'},'C'],
										'confixx_domain' => [$ptrAdmin->{'confixx_domain'},'C'],
										'dnstemplate' => [$ptrAdmin->{'dnstemplate'},'C'],
										'autoresponder' => 1,
										'stdcgi' => 1,
										'stddomain' => 1,
										'asp' => 1,
										'wap' => 1,
										'coldfusion' => 1,
										'dirlist' => 1,
										'phpupload' => 1,
										'dns' => 1,
										'dnr' => 1,
										'spamfilter' => 1,
										'checkupdates' => 1,
										'cronjobs' => 1,
										'majordomo' => 1,
										'idn' => 1,
										'scponly' => 1,
										'oldskins' => 0,
										'backup' => 2,
										'master' => 1
									);
			if( $persInfoID ){
				$admin{'personalinfoid'} = $persInfoID;
			}
			
			( $fields, $values ) = &makeSqlInsert( \%admin );
			$sql = "INSERT INTO admin ( $fields ) VALUES ( $values )";
			
			$dbhMaster->do( $sql ) or
				die ("#2010: $DBI::errstr\n");

			$ptrRow = undef;
			$sql = "SELECT s.*, c.version FROM skins s, custom_skins c".
				" WHERE s.skin_id = c.id AND s.server_id = c.server_id ".
					" AND s.server_id='$::ServerID' AND s.cuser='admin'";
			$sth = $dbh->prepare( $sql );

			if( $sth->execute() && $sth->rows ){
				$ptrRow = $sth->fetchrow_hashref;
				$sth->finish;

				if( $ptrRow->{'version'} eq 'powp' ){
					$ptrRow->{'server_id'} = $::masterServerID;
					map{ $ptrRow->{$_} = [ $ptrRow->{$_}, 'C' ] } qw/cuser skin server_id/;
					delete $ptrRow->{'version'};
				}else{
					$ptrRow = undef;
				}
			}

			unless( $ptrRow ){ ## assign a power skin
				$sql = "SELECT id FROM custom_skins WHERE server_id='$::ServerID'".
					" AND version='powp' AND owner_type = 'preinstalled' ".
						" ORDER BY id";
				$sth = $dbh->prepare( $sql );
				if( $sth->execute ){
					my($id) = $sth->fetchrow;
					$sth->finish();
					if( $id ){
						$ptrRow = { 'cuser' => [ 'admin', 'C' ],
												'skin' => [ '', 'C' ],
												'server_id' => [ $::masterServerID, 'C' ],
												'skin_id' => $id
											};
					}
				}
			}
			
			if( $ptrRow ){
				( $fields, $values ) = &makeSqlInsert( $ptrRow );
				$sql = "INSERT INTO skins ( $fields ) VALUES ( $values )";
				$dbhMaster->do( $sql ) or
					warn ("#2010: $DBI::errstr\n");

			}else{
				warn "Admin has not any power skin\n";
			}

			$sth = $dbh->prepare( "SELECT * FROM custom_skins ".
														" WHERE owner_type='preinstalled' AND server_id='$::ServerID'" );
			if( $sth->execute() ){
				my @fields = qw/name show_name owner_type anbieter version path server_id/;
				while( $ptrRow = $sth->fetchrow_hashref() ){
					$ptrRow->{'server_id'} = $::masterServerID;
					map{ $ptrRow->{$_} = [ $ptrRow->{$_}, 'C' ] } @fields;
					
					( $fields, $values ) = &makeSqlInsert( $ptrRow );
					$sql = "INSERT INTO custom_skins ( $fields ) VALUES ( $values )";
					$dbhMaster->do( $sql ) or
						warn ("#2010: $DBI::errstr\n");

				}
				$sth->finish();
			}
		
			my %res0 = ( 'anbieter' => ['res0', 'C' ],
									 'number' => 0,
									 'server_id' => [$::masterServerID, 'C'],
									 'longpw' => [$master_admin_pw_crypt,'C'],
									 'maxkunden' => -1,
									 'maxkundenlimit' => 0,
									 'maxpop' => -1,
									 'maxpoplimit' => 0,
									 'maxkb' => -1,
									 'maxkblimit' => 0,
									 'maxmysql' => -1,
									 'maxmysqllimit' => 0,
									 'maxemail' => -1,
									 'maxemaillimit' => 0,
									 'maxftp' => -1,
									 'maxftplimit' => 0,
									 'maxtransfer' => -1,
									 'maxsubdomains' => -1,
									 'maxsubdomainslimit' => 0,
									 'maxwildcards' => -1,
									 'maxwildcardslimit' => 0,
									 'maxatdomains' => -1,
									 'maxatdomainslimit' => 0,
									 'maxcronjobs' => -1,
									 'maxcronjobslimit' => 0,
									 'php' => 1,
									 'perl' => 1,
									 'modpython' => 1,
									 'ssi' => 1,
									 'cssl' => 1,
									 'shell' => 1,
									 'statistik' => 1,
									 'pwschutz' => 1,
									 'fehlerseiten' => 1,
									 'webftp' => 1,
									 'webmail' => 1,
									 'frontpage' => 1,
									 'stdcgi' =>  1,
									 'personendatenangeben' => 1,
									 'kundendatenanzeigen' => 0,
									 'kundendatenbeikundenanzeigen' => 1,
									 'maxautoresponder' => -1,
									 'maxautoresponderlimit' => 0,
									 'ftp' => 1,
									 'gesperrt' => 0,
									 'maxdomains' => -1,
									 'maxdomainslimit' => 0,
									 'language' => [$ptrAdmin->{'language'},'C'],
									 'asp' => 1,
									 'wap' => 1,
									 'coldfusion' => 1,
									 'dirlist' => 1,
									 'logcopy' => 1,
									 'phpupload' => 1,
									 'dbext' => 1,
									 'dns' => 1,
									 'dnr' => 1,
									 'spamfilter' => 1,
									 'maxidn' => -1,
									 'maxidnlimit' => 0,
									 'maxmaillist' => -1,
									 'maxmaillistlimit' => 0,
									 'scponly' => 1,
									 'custom_skins' => 1,
									 'backup' => 2,
									 'dnsspezial' => [($ptrRes0->{'dnsspezial'}?
																		 $ptrRes0->{'dnsspezial'}:
																		 $ptrAdmin->{'dnstemplate'}),'C']
								 );

			( $fields, $values ) = &makeSqlInsert( \%res0 );
			$sql = "INSERT INTO anbieter ( $fields ) VALUES ( $values )";

			$dbhMaster->do( $sql ) or
				die ("#2010: $DBI::errstr\n");

			foreach my $table (qw/register zeiten allgemein/){

				my( $ptrFields, $ptrPrim ) = &lib_module_master::getFieldsInfo( $table, $dbhMaster );


				$sth = $dbh->prepare( "SELECT * FROM $table WHERE server_id='$::ServerID'");
				$sth->execute() or next;

				if( $ptrRow = $sth->fetchrow_hashref() ){
					$ptrRow->{'server_id'} = $::masterServerID;

					if( $ptrFields ){
						map{ delete $ptrRow->{$_} unless exists $ptrFields->{$_} } keys %{$ptrRow};
					}

					$ptrRow = &prepareRow( $ptrRow, $sth );

					( $fields, $values ) = &makeSqlInsert( $ptrRow );
					$sql = "INSERT INTO $table ( $fields ) VALUES ( $values )";
					
					$dbhMaster->do( $sql ) or
						warn "Error SQL-query '$sql': $!\n";
				}
				$sth->finish();
			}
		}

		$dbhMaster->disconnect();

		$::dbLocalType = $::dbType;
		$::dbLocalServer = $::dbServer || 'localhost';
		$::dbLocalPort = $::dbPort;
		$::dbLocalUser = $::dbUser;
		$::dbLocalPw = $::dbPw;
		$::dbLocalDB = $::dbDB;

		$::master_confixx = 2;
		return $::masterServerID;

	} else {
		$::master_confixx = 0;
		return undef;
	}

	
}

sub createMasterDB{

  print &ltext('install_db_db_create', $::dbMasterDB),"\n";

  my $dbaddress = &makeDSN( 'mysql',
														$::mysqlMasterServer,
														'mysql',
														$::mysqlMasterPort );

  my $dbh = DBI->connect( $dbaddress, 
													$::mysqlMasterAdmin, 
													$::mysqlMasterAdminPw ) or
		die( &ltext('db_connect', '#2018', $DBI::errstr) );


	$::bin_mysql ||= $::bin{'mysql'} || 'mysql';

	my $cmdPrefix = "$::bin_mysql -v ";
	$cmdPrefix .= &makeCmdLine( { 'server' => $::mysqlMasterServer, 
																'port' => $::mysqlMasterPort,
																'user' => $::mysqlMasterAdmin,
																'password' => $::mysqlMasterAdminPw}
														);
	
	my $cmd = "$cmdPrefix -e 'use $::dbMasterDB' 2>&1";

	my $out = `$cmd`;
	chomp $out;
	unless( $out ) {
    if ( &::YesNoQuestion (&ltext('install_db_mysql_db_exists', $::dbMasterDB ) ) ) {
      $dbh->do( "DROP DATABASE $::dbMasterDB" ) 
				or die("#2017: $DBI::errstr\n");
    }else{

			my $dbaddress = &makeDSN( 'mysql',
																$::mysqlMasterHost,
																$::dbMasterDB,
																$::mysqlMasterPort );

			my $dbh = DBI->connect( $dbaddress, 
															$::mysqlMasterAdmin, 
															$::mysqlMasterAdminPw ) or
																die( &ltext('db_connect', '#2018', $DBI::errstr) );
			

			my $sth = $dbh->prepare( "SELECT a.server_id,a.login,a.longpw,a.hostname ".
															 " FROM admin a, anbieter r ".
															 " WHERE a.server_id = r.server_id AND r.anbieter='res0'" );
			my (@ret);
			if( $sth->execute() ){
				my $cnt = $sth->rows();
				if( $cnt == 1 ){
					my($master_id,$login,$longpw,$hostname) = $sth->fetchrow();
					$sth->finish;
					@ret = ($master_id,$login,$longpw);

				}elsif( $cnt > 1 ){
					my( @items,$ind,$item,$hostname,$master_id,$login,$index,$tickbox,$longpw );
					while( my @row = $sth->fetchrow() ){
						push @items, [@row];
					}
					$sth->finish;
					my $lastItem = @items;
					my $selected = -1;
					$~ = "RADIO";

					while( $selected ){
						system( 'clear' );
						&header2( &ltext('admin_sub_head', &ltext( 'admin_master_server' ) ) );
						print &ltext('admin_radio_promt', "1..$lastItem", '0'),"\n";

						$index = 'Ind';
						$master_id = 'ServerID';
						$hostname = 'Host name';
						$tickbox = '';
						write;

						$ind = 0;
						foreach $item ( @items ){
							$ind++;
							$index = "($ind)";
							($master_id,$login,$longpw,$hostname) = @{$item};
							$tickbox = ( $selected == $ind )? '(*)': '( )';
							write;
						}

						print &ltext('admin_select_promt',&ltext('admin_select_continue'));
						$ind = <STDIN>;
						chop( $ind );
						if( $ind =~ /^\d+$/ ){
							if( $ind  ){
								if( $ind <= $lastItem ){
									$selected = $ind;
								}
							}else{
								if( $selected >= 0 ){
									@ret = @{$items[$selected-1]};
								}
								$selected = 0;
							}
						}
					}
format RADIO =
 @>>> @<<<<<<<<<<<<<<<<< @<<<<<<<<<<<<<<<< @<<
$index, $master_id, $hostname, $tickbox
.
				}
			}else{
				warn "$DBI::errstr\n"
			}
			$dbh->disconnect;
			if( @ret ){
				return @ret;	
			}
		}

  }


  $dbh->do( "CREATE DATABASE $::dbMasterDB" ) or
		die("#2017: $DBI::errstr\n");

  $dbh->disconnect;

	$cmd = "$cmdPrefix $::dbMasterDB <$::installDir/admin/subs/mysqltables";
	
  if( system( $cmd ) ) {
		&hard_error ( &ltext('update_db_table_add_err', $::dbMasterDB) );
	}

	return 1;

}

sub createMasterUser {

  my $dbaddress = &makeDSN( 'mysql',
														$::mysqlMasterServer,
														'mysql',
														$::mysqlMasterPort
													);

  my $dbh = DBI->connect( $dbaddress,
													$::mysqlMasterAdmin,
													$::mysqlMasterAdminPw
												) or
													die( &ltext('db_connect', '#2018', $DBI::errstr) );

	my $sthUser = $dbh->prepare( "SELECT User FROM user WHERE User=? AND Host=?" );
	my $sthDb = $dbh->prepare( "SELECT Host, Db, User FROM db WHERE User=? AND ".
														 "Host=? AND db='$::dbMasterDB'" );

	my $weiter = 1;
	my $grant = 0;
	my( $exists );

	while( $weiter ){
		$weiter = 0;
		$grant = 0;

		$sthUser->execute( $::dbMasterUser, $::mysqlMasterHost );

		$exists = $sthUser->rows;
		if( $exists ) {
			if( &::YesNoQuestion( &ltext('install_db_mysql_user_exists', 
																 $::dbMasterUser,
																 $::mysqlMasterHost
																)
												)
				){
				
				$::dbMasterUser = &::Question( &ltext('install_question_mysqluser', $::dbMasterDB) , 'confixx');
				$::dbMasterPw = &::PassQuestion( &ltext('install_question_mysqlpass', $::dbMasterUser, $::dbMasterDB), '');
				$weiter = 1;
					
			}else{
				$grant = 1;
			}
		}else{

			print &ltext('install_db_mysql_user_add', $::dbMasterUser);

			$grant = 1;
		}

		$sthUser->finish;
  
		unless( $weiter ){
			print &ltext('install_db_mysql_db_perms', $::dbMasterDB);
	
			$sthDb->execute( $::dbMasterUser, $::mysqlMasterHost );
			unless ( $sthDb->rows ){
				$grant = 1;
			}
			$sthDb->finish();
		}

		if( $grant ){

#
# default access from '%'
#
			my $cnt = 0;
			my $sth = $dbh->prepare( "SELECT COUNT(*) FROM user WHERE host='%' AND ".
															 " user='$::dbMasterUser'");
			if( $sth->execute ){
				($cnt) = $sth->fetchrow;
				$sth->finish;
			}
			unless( $cnt ){
				$dbh->do( "INSERT INTO user (user,host) VALUES ('$::dbMasterUser','%')" )	or
					die( "$DBI::errstr\n" );
			}

			$sth = $dbh->prepare( "SELECT COUNT(*) FROM db WHERE host='%' AND ".
														" user='$::dbMasterUser' AND db='$::dbMasterDB'");
			if( $sth->execute ){
				($cnt) = $sth->fetchrow;
				$sth->finish;
			}
			if( $cnt ){
				$dbh->do( "DELETE FROM db WHERE host='%' AND ".
									" user='$::dbMasterUser' AND db='$::dbMasterDB'");
			}

#
# end default access from '%'
#

			$dbh->do( "FLUSH PRIVILEGES " )or
				die( "$DBI::errstr\n" );

			$dbh->do( "GRANT ALL PRIVILEGES ON $::dbMasterDB.* ".
							  " TO '$::dbMasterUser'\@'$::mysqlMasterHost' ".
								" IDENTIFIED BY '$::dbMasterPw'"
							)	or
								die("$DBI::errstr\n");

#
# paranoya
#

			$dbh->do( "FLUSH PRIVILEGES " )or
				die( "$DBI::errstr\n" );

			$dbh->do( "GRANT ALL PRIVILEGES ON $::dbMasterDB.* ".
							  " TO '$::dbMasterUser'\@'%' ".
								" IDENTIFIED BY '$::dbMasterPw'"
							)	or
								die("$DBI::errstr\n");
#
# end paranoya
#

			$dbh->do( "UPDATE user SET password=password('$::dbMasterPw') ".
								" WHERE user='$::dbMasterUser'" ) or
								die( "$DBI::errstr\n" );

			$dbh->do( "FLUSH PRIVILEGES" ) or
				die( "#2016: $DBI::errstr\n" );
		}
	}		
	return 1;
}

sub updateMasterConfig {
	&readMasterConfig();
	&writeMasterConfig();
	&writeMasterPhpConfig();
}

sub readMasterConfig{
	if( $::master_confixx && ! $::masterServerID ){
		&loadConfFile( "$::installDir/confixx_master.conf" );
	}
}

sub writeMasterConfig{

	my $dstPath = "$::installDir/confixx_master.conf";
	unless( open( FILE, '>', $dstPath ) ){
		die "Error: can't open file '$dstPath': $!\n";
	}

  print FILE << "CONFIG";

\$use_resellers = 0;

\$masterServerID = '$::masterServerID';

\$mysqlMasterAdmin = '$::mysqlMasterAdmin';
\$mysqlMasterAdminPw = '$::mysqlMasterAdminPw';
\$mysqlMasterPort = '$::mysqlMasterPort';
\$mysqlMasterServer = '$::mysqlMasterServer';
\$mysqlMasterHost = '$::mysqlMasterHost';
\$mysqlMasterVersion = '$::mysqlMasterVersion';


\$dbMasterServer = '$::dbMasterServer';
\$dbMasterPort = '$::dbMasterPort';
\$dbMasterDB = '$::dbMasterDB';
\$dbMasterUser = '$::dbMasterUser';
\$dbMasterPw = '$::dbMasterPw';

\$dbLocalType = '$::dbLocalType';
\$dbLocalServer = '$::dbLocalServer';
\$dbLocalPort = '$::dbLocalPort';
\$dbLocalUser = '$::dbLocalUser';
\$dbLocalPw = '$::dbLocalPw';
\$dbLocalDB = '$::dbLocalDB';

CONFIG

	$::db_local_dsn ||= &makeDSN( $::dbLocalType, $::dbLocalServer, $::dbLocalDB, $::dbLocalPort );
	print FILE "# DSN\n\$db_local_dsn = '$::db_local_dsn';\n";

	$::db_master_dsn ||= &makeDSN( 'mysql', $::mysqlMasterServer, $::dbMasterDB, $::dbMasterPort );
	print FILE "# DSN\n\$db_master_dsn = '$::db_master_dsn';\n";

  close( FILE );
  chown( 0, 0, $dstPath );
  chmod( 0400, $dstPath );

	return 1;
}

sub writeMasterPhpConfig{

	my $dstPath = "$::confixx_homeDir/master.inc.php";
	unless( open( FILE, '>', $dstPath ) ){
		die "Error: can't open file '$dstPath': $!\n";
	}

  print FILE << "CONFIG";
<?

\$masterServerID = '$::masterServerID';

\$mysqlMasterAdmin = '$::mysqlMasterAdmin';
\$mysqlMasterAdminPw = '$::mysqlMasterAdminPw';
\$mysqlMasterPort = '$::mysqlMasterPort';
\$mysqlMasterServer = '$::mysqlMasterServer';
\$mysqlMasterHost = '$::mysqlMasterHost';
\$mysqlMasterVersion = '$::mysqlMasterVersion';

\$dbMasterDB = '$::dbMasterDB';
\$dbMasterUser = '$::dbMasterUser';
\$dbMasterPw = '$::dbMasterPw';

\$dbLocalType = '$::dbLocalType';
\$dbLocalServer = '$::dbLocalServer';
\$dbLocalPort = '$::dbLocalPort';
\$dbLocalUser = '$::dbLocalUser';
\$dbLocalPw = '$::dbLocalPw';
\$dbLocalDB = '$::dbLocalDB';

CONFIG

	print FILE "\n?>";

	close( FILE );
  $::apacheGID = getgrnam ( $::apacheGroup );
  chown ( $::confixx_uid, $::apacheGID, $dstPath );
  chmod (0440, $dstPath );

  unless( $::confixx_htmlDir eq $::confixx_homeDir ){
		$dstPath = "$::confixx_htmlDir/master.inc.php";
    print &ltext( 'install_do_file_create', $dstPath );
    open( FILE, '>', $dstPath );

    print FILE <<"CONFIG_PHP";
<?
include("$::confixx_homeDir/master.inc.php");
CONFIG_PHP

		print FILE "\n?>";

    close (FILE);

    chown ( $::confixx_uid, $::confixx_gid, $dstPath );
    chmod ( 0444, $dstPath );
	}
}

package main;

sub createRandPw {

#
# 28 + 28 + 10 = 66
#
  my $pw = join '', map{(0..9, 'A'..'Z', 'a'..'z')[rand 65]}(1..8);

  return $pw;
}

sub connectToMaster {

	my $dbh = shift;
	unless( ref($dbh)=~/DBI/){
		unshift @_, $dbh;
		$dbh = $::dbh;
	}
	$DEBUG = shift;

	my @dont_copy = qw/server/; ## list of tables to skip

	my @first_tables = qw/events/; ## to prepare as first

	my $ptrCnts = &getEventsCount( $::OBJECT_SERVER, $::EVENT_CONNECT );

	my $sth =	$dbh->prepare( "SELECT data,object_prop FROM events WHERE id=? ".
													 " AND server_id='$::ServerID'" );

	my ($data,%opts,$key,$value, $dsn,$user, $pass, $cnt, $list, $server_id);

	my @need = qw/dsn user pass/;

	foreach my $eventId ( keys %{$ptrCnts} ){

		$ptrCnts->{$eventId} = '';

		if( !$cnt && $sth->execute( $eventId ) ){
			($data,$server_id) = $sth->fetchrow;
			$sth->finish;
			%opts = ();
			while( $data =~ s/^\s*(\w+)\s*=\s*// ){ ## get name of parameter
				$key = $1;

				if( $data =~ s/^('|")(.*?)\1\s*(;|$)// ){ ## get value of parameter
					$value = $2;
				}elsif( $data =~ s/([^;]*)(;|$)// ){
					$value = $1;
				}else{
					$value = undef;
				}
				$opts{lc($key)} = $value;
			}
			$opts{'server_id'} = $server_id;
			$cnt = 0;
			map{ $cnt++ } grep{ $opts{$_} } @need;
			unless( $cnt == @need ){
				$cnt = 0;
			}
		}
	}
	&cleanEvents( $ptrCnts );
	
	unless( $cnt ){ ## nothing to do
		return;
	}
	$opts{'dsn'} .= ';mysql_socket='.$opts{'mysql_socket'} if $opts{'mysql_socket'};
	$opts{'dsn'} .= ';port='.$opts{'port'} if $opts{'port'};

	my $dbhMaster = DBI->connect( $opts{'dsn'}, $opts{'user'}, $opts{'pass'} );
	unless( $dbhMaster ){
		&soft_error( "mlf||db_connect||#2232||$DBI::errstr" );
		return;
	}

	$sth = $dbh->prepare( "SELECT version FROM register WHERE server_id='$::ServerID'" );
	if( $sth->execute() ){
		my $ver;
		while(($ver) = $sth->fetchrow){
		  if( $ver =~ /dc/ ){
			  $sth->finish;
			  last;
		  }
		}
		unless ($ver =~/dc/){
			&soft_error( "mlf||licence_dc||#2231||$ver" );

			$dbhMaster->do( "UPDATE server SET status=-1 WHERE server_id='$::ServerID'" );

			$dbhMaster->disconnect;

			return;
		}
	}


	if( $DEBUG ){
		print "start copy the local database to the master database ...\n";
	}

#
# lock the confixx server
#
	&eventAdd( $dbh, 
						 'obj_type' => $::OBJECT_SERVER,
						 'obj_prop' => $::ServerID,
						 'event_type' => $::EVENT_LOCK );


	my $ptrTables = &getTablesList( $::installDir.'/admin/subs/mysqltables', $dbhMaster );

	my($row,$cleanMode,$primKey,@row,
		 %keys,%where,%row,$updateMode,$sql,$ptrFields,$ptrPrim);

	my %first_tables = map{ $_ => 1} @first_tables;
	map{ delete $ptrTables->{$_} } @dont_copy;
	my @list = grep{ ! exists $first_tables{$_} } keys %{$ptrTables};

	my $sthDomain = $dbhMaster->prepare( "SELECT richtigedomain,server_id ".
																			 " FROM domains WHERE domain=?" ) or
																				warn "DBI::errstr\n";

	
	foreach my $currTable ( @first_tables, @list ){ ## prepare list of tables. 'events is first'
	
		if( $DEBUG ){
			print "Copy table '$currTable' ... \n";
		}

		if( $currTable eq 'domains' ){
			$primKey = ['domain'];
		}else{		
			$primKey = $ptrTables->{$currTable};
		}

#
# get field's info of the destination table
#
		( $ptrFields, $ptrPrim ) = &lib_module_master::getFieldsInfo( $currTable, $dbhMaster );
		next unless $ptrFields;
		if( $currTable ne 'domains' && $ptrPrim ){
			$primKey = $ptrPrim;
		}

#
# lock source & destination (MySQL) tables
#

		unless( $DEBUG ){ ## don't lock in DEBUG mode

			$dbhMaster->do("LOCK TABLES $currTable WRITE") or
				warn "$DBI::errstr\n";

			if( $::dbType eq 'Pg' ){
				#			$dbh->do( "BEGIN WORK" );
				$dbh->do( "LOCK $currTable IN EXCLUSIVE MODE" ) or
					warn "$DBI::errstr\n";
				
			}else{
				$dbh->do("LOCK TABLES $currTable WRITE") or
					warn "$DBI::errstr\n";
			}
		}

		$cleanMode = 1;
		%keys = ();

#
# get list of primary keys
#
		if( $currTable =~ /^(domains|bin)$/ ){
			$cleanMode = 1;

		}else{
			if( ref( $primKey ) ){
				$sql = 'SELECT '.join(',',@{$primKey})." FROM $currTable WHERE server_id='$::ServerID'";
				$sth = $dbhMaster->prepare( $sql );
				if( $sth->execute ){
					$cleanMode = 0;
					while( @row = $sth->fetchrow ){
						$key = join( ';;', @row );
						if( exists $keys{$key} ){
							warn "key '$key' exists already\n";
						}else{
							$keys{$key} = [@row];
						}
					}
					$sth->finish;
				}else{
					warn "$DBI::errstr\n";
				}
			}
		}

#
# clean the destination table ( MySQL )
#
		if( $cleanMode ){
			$dbhMaster->do( "DELETE FROM $currTable WHERE server_id='$::ServerID'" ) or
				warn "$DBI::errstr\n";
		}


#
# copy the table contnet
#
		if( $currTable eq 'domains' ){
			$sql = "SELECT * FROM $currTable WHERE server_id='$::ServerID' OR richtigedomain=5";
		}else{
			$sql = "SELECT * FROM $currTable WHERE server_id='$::ServerID'";
		}
		$sth = $dbh->prepare( $sql );
		unless( $sth->execute ){
			warn "DBI::errstr\n";

#
# unlock the table
#
			if( $::dbType eq 'Pg' ){
#				$dbh->do( "COMMIT WORK" ) or
#					warn "$DBI::errstr\n";
			}else{
				$dbh->do( "UNLOCK TABLES" ) or
					warn "$DBI::errstr\n";
			}
			next;
		}

#
# loop by rows
#
		while( $row = $sth->fetchrow_hashref ){

			if( $currTable eq 'domains' ){

				if( $sthDomain->execute( $row->{'domain'} ) ){
					if( $sthDomain->rows ){
						my( $type, $sid ) = $sthDomain->fetchrow();
						if( $type == 5 ){
							$sthDomain->finish();
							next; ## skip blacklist;
						}
						if( $sid ne $ServerID ){
							$sthDomain->finish();
							warn "Error: domain '".$row->{'domain'}."' exists already in the cluster. Skiped\n";
							next;
						}
						$updateMode = 1;
					}else{
						$updateMode = 0;
					}
					$sthDomain->finish();
				}else{
					warn "DBI::errstr\n";
					next;
				}
	
			}else{
				if( $cleanMode ){
					$updateMode = 0;
				}else{
					$key = join( ';;', map { $row->{$_} } @{$primKey} );

					$updateMode = $keys{ $key }? 1: 0;
				}
			}

#
# make a sql query to insert/update
#
			if( $updateMode ){
				%where = map{ $_ => [ $row->{$_}, $ptrFields->{$_} ] } @{$primKey};
				if( $currTable eq 'domains' ){
					map{ delete $row->{$_} }  @{$primKey};
					$row->{'server_id'} = ( $row->{'richtigedomain'} == 5 )?'':$ServerID;
				}else{
					$where{'server_id'} = [ $::ServerID, 'C' ]; ## paranoia
					map{ delete $row->{$_} } ( 'server_id', ## paranoia
																		 @{$primKey} );
					delete $keys{ $key };
				}


				%row = map{ $_ => [ $row->{$_}, $ptrFields->{$_} ] }
					grep{ defined $row->{$_} } ## skip null
					grep{ exists $row->{$_} } keys %{$ptrFields};

				$sql = "UPDATE $currTable SET ".&makeSqlUpdate( \%row )." WHERE ".&makeSqlWhere( \%where );

			} else {
				%row = map{ $_ => [ $row->{$_}, $ptrFields->{$_} ] }
					grep{ defined $row->{$_} } ## skip null
					grep{ exists $row->{$_} } keys %{$ptrFields};
				$row{'server_id'} = [ $::ServerID, 'C' ]; ## paranoia
				if( $currTable eq 'bin' ){
					delete $row{'id'};
				}

				my($fields,$vals) = &makeSqlInsert( \%row );

				$sql = "INSERT INTO $currTable ($fields) VALUES ($vals)";
			}

#
# insert/update the row
#
			$dbhMaster->do( $sql ) or
				warn "$DBI::errstr\n$sql\n";
		}
		$sth->finish;
#
# end loop by rows
#

#
# clean deleted rows
#
		if( ( ! $cleanMode ) && keys %keys){
			foreach $row (values %keys){
				%where = map{ $_ => [ shift @{$row}, $ptrFields->{$_} ] } @{$primKey};
				$where{'server_id'} = [ $::ServerID, 'C' ]; ## paranoia

				$dbhMaster->do( "DELETE FROM $currTable WHERE ".
												&makeSqlWhere( \%where )
											) or
												warn "$DBI::errstr\n";
			}
		}

#
# unlock tables
#
		if( $::dbType eq 'Pg' ){
#			$dbh->do("COMMIT WORK") or
#				warn "$DBI::errstr\n";

		}else{
			$dbh->do("UNLOCK TABLES") or
				warn "$DBI::errstr\n";
		}

		$dbhMaster->do( "UNLOCK TABLES" ) or
			warn "$DBI::errstr\n";
	}
#
# end of loop by tables
#

	$dbhMaster->do( "UPDATE server SET status=2 WHERE server_id='$::ServerID'") or
		warn "DBI::errstr\n";

#
# unlock the confixx server
#
	$dbhMaster->do( "DELETE FROM events WHERE server_id='$::ServerID' ".
									" AND object_type=$::OBJECT_SERVER AND event_type=$::EVENT_LOCK" ) or
		warn "$DBI::errstr\n";

	my($dbtype,$host,$dbname,$port) = parseDSN( $opts{'dsn'} );
	if( $dbtype eq 'mysql' ){ ## the master database is MySQL

		if( $::master_confixx == 2 ){
			unless( $::dbMasterDB == $dbname ){
				warn "Error: master options confilict. Names of the master database are not same ('$::dbMasterDB' - '$dbname')\n";
				return;
			}
		} else {

			$::master_confixx = 1;

			$::masterServerID = $opts{'server_id'};

			$::dbMasterServer = $host;
			$::dbMasterPort = $port;
			$::dbMasterDB = $dbname;
			$::dbMasterUser = $opts{'user'};
			$::dbMasterPw = $opts{'pass'};
			$::db_master_dsn = $opts{'dsn'};
		
			$::dbLocalType = $::dbType;
			$::dbLocalServer = $::dbServer;
			$::dbLocalPort = $::dbPort;
			$::dbLocalUser = $::dbUser;
			$::dbLocalPw = $::dbPw;
			$::dbLocalDB = $::dbDB;
			$::db_local_dsn = $::db_address;
			
			&lib_module_master::writeMasterConfig();
			&lib_module_master::writeMasterPhpConfig();

		}

		copy( "$::installDir/confixx_main.conf",
					"$::installDir/confixx_main.conf.master_bak" );

		$::db_address = $opts{'dsn'};
		$::dbType = 'mysql';
		$::dbServer = $host;
		$::dbPort = $port;
		$::dbDB = $dbname;
		$::dbUser = $opts{'user'};
		$::dbPw = $opts{'pass'};

#
# remake skripts
#
		&rewriteScripts();

	}else{
		warn "Error parsing of master DSN: $opts{'dsn'}. Type of the master databse must be 'mysql'\n";
		return;
	}

	return $dbhMaster;

}

sub getTablesList{
	my $sqlList = shift;
	my $dbh = shift;
	unless( ref($dbh)=~/DBI/){
		unshift @_, $dbh;
		$dbh = $::dbh;
	}

	my %tables = ();
	my $currTable = '';
	my($sth,$list);
	if( -f $sqlList ){
		if( open( LIST, $sqlList )){
			while( <LIST> ){

				if( /(?:^|;)\s*CREATE\s+TABLE\s+(\w+)\s*\(/i ){ ## get name of table
					$currTable = lc($1);
					$tables{$currTable} = undef;

				}elsif( /(?:^|,)\s*PRIMARY\s+KEY\s+\(\s*([^)]+)\s*\)/i ){ ## get list of primary key
					$list = $1;
					$list =~ s/\s+$//;
					$tables{$currTable} = [ sort split( /\s*,\s*/, $list ) ];
				}
			}
			close( LIST );
		}else{
			&soft_error( "mlf||scripts_file_open_read||#2233||$sqlList" );
		}
	}else{
		$sth = $dbh->prepare( "SHOW TABLES" );
		if( $sth->execute ){
			while( ($currTable) = $sth->fetchrow ){
				$tables{$currTable} = undef;
			}
			$sth->finish;
		}else{
			warn "$DBI::errstr\n";
		}
	}
	return \%tables;
}


sub rewriteScripts{

	&::safe_do( "$::installDir/admin/subs/subs_include_writeConfig.pl" );

	&WriteMainConfigFile;

	unless($::dns_server == 2 || $::mail_server == 2){  ## launch only on primary server
		&WritePHPConfigFile;
	}
	if($::mail_server){ ## launch only on mail serevr
			# spamassassin depends on db configuration
		&::safe_do( "$::installDir/admin/subs/subs_includes_spamassassin.pl" );
	}

	$::wDir = $::installDir;
	$::confixxState = 'remake';

	&safe_do( "$::installDir/admin/subs/scripts_install.pl" );
#	&installFTPTraffik;
	&installHTTPDTraffik;
	&installWebalizer;

	if( $::mail_server>=1 && $::mta ) {
		&installAutoresponder( 'autoresponder.pl' );
		&installAutoresponder( 'confixxevent.pl', ($mta eq 'qmail')?'alias':undef);
	}

#	&installNewsletter();

	&safe_do( "$::installDir/admin/subs/webPages_install.pl" );
	&installScripts();

}

sub copyToLocal {
	my( $dbh, $dbhLocal, $cleanSource,
			$ptrResWords, $ptrFirstTbls, $ptrDontCopy, $ptrToCopy  ) = @_;

	my( $list,$sth, $key );
	my( $row,$ptrFields,$cleanMode,$primKey,@row,
		 % keys,%where,%row,$updateMode,$sql,$ptrPrim );

	my( %reserved_words, %first_tables );
	if( ref( $ptrResWords ) =~ /ARRAY/ ){
		%reserved_words = map{ $_ => 1} @{$ptrResWords};
	}

	if( ref( $ptrFirstTbls ) =~ /ARRAY/ ){
		%first_tables = map{ $_ => 1} @{$ptrFirstTbls};
	}else{
		$ptrFirstTbls = [];
	}

	my $ptrTables = &getTablesList( $::installDir.'/admin/subs/mysqltables', 
																	$dbh );

	if( ref( $ptrDontCopy ) =~ /ARRAY/ ){
		map{ delete $ptrTables->{$_} } @{$ptrDontCopy};
	}
	if( ref( $ptrToCopy ) =~ /ARRAY/ && @{$ptrToCopy} ){
		my %toCopy = map{ $_ => 1 } @{$ptrToCopy};
		map{ delete $ptrTables->{$_} unless $toCopy{$_} } keys %{$ptrTables};
	}

	my @list = grep{ ! exists $first_tables{$_} } keys %{$ptrTables};

	my $sthDomain = $dbhLocal->prepare( "SELECT id,richtigedomain ".
																			" FROM domains WHERE domain=? AND server_id='$ServerID'" ) or
																				warn "DBI::errstr\n";
	
	foreach my $currTable ( @{$ptrFirstTbls}, @list ){ ## prepare list of tables. 'events is first'
		if( $DEBUG ){
			print "Copy table '$currTable' ... \n";
		}

		$primKey = $ptrTables->{$currTable};

#
# get field's info of the destination table
#
		( $ptrFields, $ptrPrim ) = &lib_module_master::getFieldsInfo( $currTable, $dbhLocal );
		next unless $ptrFields;
		$primKey = $ptrPrim if $ptrPrim;


#
# lock source & destination (MySQL) tables
#

		unless( $DEBUG ){ ## don't lock in DEBUG mode

			$dbh->do("LOCK TABLES $currTable WRITE") or
				warn "$DBI::errstr\n";

			if( $::dbLocalType eq 'Pg' ){
				#			$dbh->do( "BEGIN WORK" );
				$dbhLocal->do( "LOCK $currTable IN EXCLUSIVE MODE" ) or
					warn "$DBI::errstr\n";
				
			}else{
				$dbhLocal->do("LOCK TABLES $currTable WRITE") or
					warn "$DBI::errstr\n";
			}
		}

		$cleanMode = 1;
		%keys = ();

#
# get list of primary keys
#
		if( ref( $primKey ) ){
			$sql = 'SELECT '.join(',',@{$primKey})." FROM $currTable WHERE server_id='$::ServerID'";
			$sth = $dbhLocal->prepare( $sql );
			if( $sth->execute ){
				$cleanMode = 0;
				while( @row = $sth->fetchrow ){
					$key = join( ';;', @row );
					if( exists $keys{$key} ){
						warn "key '$key' exists already\n";
					}else{
						$keys{$key} = [@row];
					}
				}
				$sth->finish;
			}else{
				warn "$DBI::errstr\n";
			}
		}


#
# clean the destination table 
#
		if( $cleanMode ){
			$dbhLocal->do( "DELETE FROM $currTable WHERE server_id='$::ServerID'" ) or
				warn "$DBI::errstr\n";
		}


#
# copy the table contnet
#
		$sth = $dbh->prepare( "SELECT * FROM $currTable WHERE server_id='$::ServerID'" );
		unless( $sth->execute ){
			warn "DBI::errstr\n";

#
# unlock the table
#
			$dbh->do( "UNLOCK TABLES" ) or
				warn "$DBI::errstr\n";
			next;
		}

#
# loop by rows
#
		while( $row = $sth->fetchrow_hashref ){

			unless( $cleanMode ){
				$key = join( ';;', map { $row->{$_} } @{$primKey} );

				$updateMode = $keys{ $key }? 1: 0;
			}else{
				$updateMode = 0;
			}
#
# make a sql query to insert/update
#
			if( $updateMode ){
				%where = map{ $_ => [ $row->{$_}, $ptrFields->{$_} ] } @{$primKey};
				$where{'server_id'} = [ $::ServerID, 'C' ]; ## paranoia
				delete $keys{ $key };

				map{ delete $row->{$_} } ( 'server_id', ## paranoia
																	 @{$primKey} );

				if( $::dbLocalType eq 'Pg' ){
					%row = map{ ($reserved_words{$_}?"\"$_\"":$_) => [ $row->{$_}, $ptrFields->{$_} ] }
						grep{ defined $row->{$_} }
						grep{ exists $row->{$_} } keys %{$ptrFields};
					
				}else{
					%row = map{ $_ => [ $row->{$_}, $ptrFields->{$_} ] }
						grep{ defined $row->{$_} }
						grep{ exists $row->{$_} } keys %{$ptrFields};
				}

				$sql = "UPDATE $currTable SET ".&makeSqlUpdate( \%row )." WHERE ".&makeSqlWhere( \%where );

			} else {
				%row = map{ $_ => [ $row->{$_}, $ptrFields->{$_} ] }
					grep{ defined $row->{$_} }
					grep{ exists $row->{$_} } keys %{$ptrFields};
				$row{'server_id'} = [ $::ServerID, 'C' ]; ## paranoia

				my($fields,$vals) = &makeSqlInsert( \%row );

				$sql = "INSERT INTO $currTable ($fields) VALUES ($vals)";
			}

#
# insert/update the row
#
			$dbhLocal->do( $sql ) or
				warn "$DBI::errstr\n";
		}
		$sth->finish;
#
# end loop by rows
#

#
# add blacklist of domains
#
		if( $currTable eq 'domains' ){

			$sth = $dbh->prepare( "SELECT * FROM domains WHERE richtigedomain=5" );
			if( $sth->execute ){
#
# loop by rows
#
				while( $row = $sth->fetchrow_hashref ){
					unless( $sthDomain->execute( $row->{'domain'}) ){
						warn "DBI::errstr\n";
						next;
					}
					unless( $sthDomain->rows() ){
						%row = map{ $_ => [ $row->{$_}, $ptrFields->{$_} ] }
							grep{ defined $row->{$_} }
							grep{ exists $row->{$_} } keys %{$ptrFields};
						$row{'server_id'} = [ $::ServerID, 'C' ]; 

						delete $row{'id'}; ## get by auto_increment

						my($fields,$vals) = &makeSqlInsert( \%row );
						
						$sql = "INSERT INTO domains ($fields) VALUES ($vals)";
						$dbhLocal->do( $sql ) or
							warn "$DBI::errstr\n";
					}
					$sthDomain->finish();
					
				}
			}else{
				warn "DBI::errstr\n";
			}
		}
#
# /add blacklist of domains
#


#
# clean deleted rows
#
		if( ( ! $cleanMode ) && keys %keys){
			foreach $row (values %keys){
				%where = map{ $_ => [ shift @{$row}, $ptrFields->{$_} ] } @{$primKey};
				$where{'server_id'} = [ $::ServerID, 'C' ]; ## paranoia

				$dbhLocal->do( "DELETE FROM $currTable WHERE ".
											 &makeSqlWhere( \%where )
										 ) or
											 warn "$DBI::errstr\n";
			}
		}

#
# clean the source table ( MySQL )
#
		if( $cleanSource ){
			$dbh->do( "DELETE FROM $currTable WHERE server_id='$::ServerID'" ) or
				warn "$DBI::errstr\n";
		}


#
# unlock tables
#
		if( $::dbLocalType eq 'Pg' ){
#			$dbhLocal->do("COMMIT WORK") or
#				warn "$DBI::errstr\n";

		}else{
			$dbhLocal->do("UNLOCK TABLES") or
				warn "$DBI::errstr\n";
		}

		$dbh->do( "UNLOCK TABLES" ) or
			warn "$DBI::errstr\n";

	}
#
# end of loop by tables
#
}

sub disconnectFromMaster {

	my $dbh = shift;
	unless( ref($dbh)=~/DBI/){
		unshift @_, $dbh;
		$dbh = $::dbh;
	}

	$DEBUG = shift;

	unless( $::master_confixx ){
		return;
	}

	my $ptrCnts = &getEventsCount( $::OBJECT_SERVER, $::EVENT_DISCONNECT );
	
	unless( ref($ptrCnts)=~/HASH/ && keys %{$ptrCnts} ){ ## nothing to do
		return undef;
	}

	&lib_module_master::readMasterConfig();
	if( ($::dbServer eq $::dbLocalServer) && ($::dbUser eq $::dbLocalUser ) && ($::dbPw eq $::dbLocalPw) && ($::dbDB eq $::dbLocalDB)){
		&cleanEvents( $ptrCnts );
		$::master_confixx = 0;
		&soft_error( "The local database's connect is same as the current connect. Disconnect is not possible" );
		return;
	}

	my $dbhLocal = DBI->connect( $::db_local_dsn, $::dbLocalUser, $::dbLocalPw );

	unless( $dbhLocal ){
		&soft_error( "mlf||db_connect||#2232||$DBI::errstr" );
		return;
	}

	if( $DEBUG ){
		print "start copy the master database to the local database ...\n";
	}

#
# lock server
#	

	&eventAdd( $dbh, 
						 'obj_type' => $::OBJECT_SERVER,
						 'obj_prop' => $::ServerID,
						 'event_type' => $::EVENT_LOCK );

	&cleanEvents( $ptrCnts );

#
# copy data
#	

	my @first_tables = qw/admin events/;
	my @dont_copy = qw/server/;
	my @reserved_words = qw/new/;

	&copyToLocal( $dbh, $dbhLocal,
								'clean_source',
								\@reserved_words,
								\@first_tables,
								\@dont_copy
							);

#
# end copy data
#

#
# change status of the server
#
	$dbh->do( "UPDATE server SET status=0 WHERE server_id='$::ServerID'" ) or
		warn "DBI::errstr";

#
# unlock the confixx server
#
	$dbhLocal->do( "DELETE FROM events WHERE server_id='$::ServerID' ".
								 " AND object_type=$::OBJECT_SERVER AND event_type=$::EVENT_LOCK" ) or
		warn "$DBI::errstr\n";

	copy( "$::installDir/confixx_main.conf",
				"$::installDir/confixx_main.conf.local_bak" );

	$::db_address = $::db_local_dsn;
	$::dbType = $::dbLocalType;
	$::dbServer = $::dbLocalServer;
	$::dbPort = $::dbLocalPort;
	$::dbDB = $::dbLocalDB;
	$::dbUser = $::dbLocalUser;
	$::dbPw = $::dbLocalPw;
	$::master_confixx = 0 unless $::master_confixx == 2;

	&rewriteScripts();

	return $dbhLocal;
}

sub backupMaster {

	my $dbh = shift;
	unless( ref($dbh)=~/DBI/){
		unshift @_, $dbh;
		$dbh = $::dbh;
	}

	$DEBUG = shift;
	my @tableToCopy = @_;

	unless( $::master_confixx ){
		return;
	}

	&lib_module_master::readMasterConfig();
	if( ($::dbServer eq $::dbLocalServer) && ($::dbUser eq $::dbLocalUser ) && ($::dbPw eq $::dbLocalPw) && ($::dbDB eq $::dbLocalDB) ){
#
# nothing to copy
#
		return;
	}

	my $dbhLocal = DBI->connect( $::db_local_dsn, $::dbLocalUser, $::dbLocalPw );

	unless( $dbhLocal ){
		&soft_error( "mlf||db_connect||#2232||$DBI::errstr" );
		return;
	}

	if( $DEBUG ){
		print "start copy the master database to the local database ...\n";
	}


#
# mark the last run time ( minutes )
#
	my $last = int( time / 60 );
	$dbh->do( "UPDATE zeiten SET backuplast=$last WHERE server_id='$::ServerID'" );

	my @first_tables = ();
	my @dont_copy = qw/server events/;
	my @reserved_words = qw/new/;

	&copyToLocal( $dbh, $dbhLocal,
								0, ## don't clean source
								\@reserved_words,
								\@first_tables,
								\@dont_copy,
								\@tableToCopy
							);

	$dbhLocal->disconnect;

}


1;
