#!/usr/bin/perl

########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

use vars qw/ $majordomo_home $majordomo_wrapper $majordomo_config 
						 $majordomo_ldir $majordomo_user/;
use strict;

sub configureMajordomo {

	my $dist = shift || &getDistrib();

	my $defHome = '/usr/local/majordomo';
	unless( -d $defHome ){
		$defHome = '/var/lib/majordomo';
	}
	my %paths = ( 'homedir' => $majordomo_home || $defHome,
								'listdir' => $majordomo_home || $defHome );

	my ($mainConfig);

	$majordomo_config = '/etc/majordomo.cf';
	
	&getPaths( $majordomo_config, \%paths );

	$paths{'listdir'} = $majordomo_ldir if ($majordomo_ldir);

	$majordomo_home = &PathQuestion( &ltext('install_question_majordomohome') , 
																	 $paths{'homedir'});
	$majordomo_wrapper = "$majordomo_home/wrapper";

	my $loop = 1;
	unless (-d $majordomo_home && -x $majordomo_wrapper){
		while ( $loop){
			if (&YesNoQuestion(  &ltext("install_question_majonohome",$majordomo_home)."\n"
													 . &ltext('install_question_majordomo') 
												)
				 ){
				$majordomo_home = &PathQuestion( &ltext('install_question_majordomohome') ,
																				 $majordomo_home);

				$majordomo_config = $majordomo_home.'/majordomo.cf' unless ( -T $majordomo_config );
				
				unless ( -T $majordomo_config ) {
					$majordomo_config = &FileQuestion( &ltext('install_question_majordomoconf'),
																					 $majordomo_config );
				}

				$majordomo_wrapper = "$majordomo_home/wrapper";
				if (-d $majordomo_home && -x $majordomo_wrapper){
					$loop=0
				}
			}else{
				$loop=0;
				$majordomo_wrapper='';
				$majordomo_home='';
			}
		}
	}
	if ($majordomo_home && -d $majordomo_home){
		$majordomo_wrapper = &getBin('wrapper',1,
																 ($majordomo_home,'/sbin','/usr/sbin','/usr/local/sbin'))
			|| "$majordomo_home/wrapper";
		unless (-x $majordomo_wrapper){
			$majordomo_wrapper = &BinQuestion( &ltext('install_question_majordomowrapper') ,
																				 "$majordomo_wrapper");
		}

		if ( -x $majordomo_wrapper ) {
			$majordomo_ldir = &PathQuestion( &ltext('install_question_majordomolists') ,
																			 $paths{'listdir'});
			my $defaultUser = ($dist =~ /suse/i)? 'mdom':'majordomo';
			$majordomo_user = &UGQuestion( &ltext('install_question_majordomouser'), $defaultUser, 0, 'user');
		}
	}
}


sub installMajordomo {

	unless ( $majordomo_home && -d $majordomo_home ) {
		return 0;
	}

	&RecCreateDir("$ENV{'DESTDIR'}$majordomo_ldir",0755) unless ($ENV{'NOFILES'});
 	my ( $majordomo_uid,$majordomo_gid ) = ( getpwnam( $majordomo_user ) )[2,3]; 
	if ($majordomo_uid && $majordomo_gid){
		chown ($majordomo_uid, $majordomo_gid, "$ENV{'DESTDIR'}$majordomo_ldir") unless ($ENV{'NOFILES'});
	}
unless ($ENV{'ONLYFILES'}){
	my @smrshDirs = ('/etc/smrsh', '/etc/mail/smrsh');
	my $dir = "";
	foreach $dir (@smrshDirs) {
	    if (-d $dir && ( $majordomo_wrapper =~ /\/wrapper$/ ) && ( -x $majordomo_wrapper ) ) {
		my $smrshWrapper = $dir.'/wrapper';
		if ( -l $smrshWrapper ) {
			my $smrshLink = readlink($smrshWrapper);
			unless ( $smrshLink eq $majordomo_wrapper ){
				unlink $smrshLink;
			}
		}
		unless ( -l $smrshWrapper ){
			symlink $majordomo_wrapper, $smrshWrapper or
				warn "Error: unable to create symlink '$smrshWrapper': $!\n";
		}
	    }
	}

#
# check main config
#
	my $majoConfig = $majordomo_home.'/majordomo.cf';
	if ( !( -T $majoConfig ) && ( -T $majordomo_config ) ) {
		if ( -l $majoConfig ) {
			unlink $majoConfig;
		}
		symlink $majordomo_config, $majoConfig or
			warn "Error: unable to create symlink '$majordomo_config': $!\n";
	}
}
#
# end check main config
#
}

sub getDistrib {
	my ($dist);

  if ( -e "/etc/redhat-release" ) {
    $dist = 'redhat';
 
  } elsif ( -e "/etc/mandrake-release" ) {
    $dist = 'mandrake';

  } elsif ( -e "/etc/SuSE-release" ) {
    $dist = 'suse';

  } elsif ( -e "/etc/debian_version" ) {
    $dist = 'debian';
  }

	return $dist;
}

sub getPaths {
	my ($file,$ptrHash,@keys) = @_;
	unless ( -T $file ) {
		return 0;
	}
	unless ( open(CONF,"<$file") ) {
		warn "error: unable to open file: '$file': $!\n";
		return 0;
	}
	my ($name,$value);
	while ( <CONF> ) {
		chomp;
		next unless $_;
		next if /^#/;
		if ( /^\s*\$([\d\w_]+)\s*=\s*([^;]+);/ ) {
			$name = $1;
			$value = $2;
			next unless exists( $ptrHash->{$name} );
			$value =~ s/\s+$//;
			if ( $value =~ /("|')(.+)\1/ ) {
				$value = $2;
			}
			if ( -e $value ) {
				$ptrHash->{$name} = $value;
			}
		}
	}

	close (CONF);
}

1;
