#!/usr/bin/perl

########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####


BEGIN {
  use FindBin;
  use lib "$FindBin::Bin/subs";
  use lib "$FindBin::Bin/scripts";
}

use lib_module_common;

my @mtas = ('sendmail', 'postfix', 'qmail');

sub configureMta {
	my $typeMta = shift || $mta;
	my $force = shift;
	my $pt = join('|',@mtas);
	
	unless ( $typeMta =~ /$pt/ ){
		$typeMta = &SelectQuestion( &ltext('install_question_mta') , @mtas);
	}
	unless ( $mta eq $typeMta ) {
		$mta = $typeMta; ## $mta is changed
		$force ||= 1;
	}

	if ( $typeMta eq 'postfix' ) {
		&configurePostfix( $force );

	} elsif ( $typeMta eq 'qmail' ) {
		&configureQmail( $force );

	} elsif ( $typeMta eq 'sendmail' ) {
		&configureSendmail( $force );

	}

	&configureMaildrop($typeMta);

	&configureMtaUidGid();

}

sub configureMaildrop {

	my $typeMta = shift || $mta;

  my $default_emailHomeDir = "/home/email";
  my $default_mailSpool = "/var/spool/mail";
  my @maildrops = qw| /var/spool/mail/USER
											HOMEDIR/Mailbox
											HOMEDIR/Maildir/
											|;

	my $default_maildrop = ($typeMta eq 'qmail')?	'HOMEDIR/Maildir/':	'/var/spool/mail/USER';

	if( -f '/etc/procmailrc' ){
		if( open( IN, '<', '/etc/procmailrc' ) ){
			
			while( my $line = <IN>){
				chomp $line;
				$line =~ s/^\s+//;
				$line =~ s/#.*$//;
				unless($line){
					next;
				}
				if( $line =~ /DEFAULT\s*=\s*(\S+)/ ){
					if( $1 =~ /\/$/ ){
						$default_maildrop = 'HOMEDIR/Maildir/';
					}
					last;
				}
			}
			close IN;
		}
	}

  print "\n";
	if ( $force || !$maildrop ) {
		$maildrop = &SelectQuestion( &ltext('install_question_maildrop') , \@maildrops, $default_maildrop);
	}

  if( $maildrop eq '/var/spool/mail/USER' ) {
		if ( $force || !($mailSpool && -d $mailSpool ) ) {
			$mailSpool = &DirQuestion( &ltext('install_question_mailspool') , $default_mailSpool);
		}

  } elsif ( $maildrop eq 'HOMEDIR/Mailbox' ) {
		if ( $force || !( $mailBoxName ) ) {
			$mailBoxName = &Question( &ltext('install_question_mailboxname') , 'Mailbox');
		}
		$mail_realHome = 1;

  } elsif ( $maildrop eq 'HOMEDIR/Maildir/' ) {
		if ( $force || !$mailBoxName ) {
			$mailBoxName = &Question( &ltext('install_question_maildirname') , 'Maildir');
		}
		$mail_realHome = 1;
  }

	if( $mail_realHome ){
		if ( $force || !($pop_homeDir && -d $pop_homeDir ) ) {
			$pop_homeDir = &PathQuestion( &ltext('install_question_pophomedir') , $default_emailHomeDir);
		}
	}
}


sub configurePostfix {

	my $force = shift;

  my $default_postfixConfigFile = '/etc/postfix/main.cf';
  my $default_virtUserTableDB = '/etc/postfix/confixx_virtualUsers';
  my $default_localDomainsFile = '/etc/postfix/confixx_localDomains';
  my $default_aliases = '/etc/postfix/aliases';

  if(!(-e '/etc/postfix/aliases') && (-e '/etc/aliases')){
     $default_aliases = '/etc/aliases';
  }
	if ( $force || !( $MailConfigFile && -T $MailConfigFile ) ) {
		$MailConfigFile = &FileQuestion( &ltext('install_postfix_conf') , $default_postfixConfigFile);
	}
	if ( $force || !( $aliases && -T $aliases ) ) {
		$aliases = &FileQuestion( &ltext('install_postfix_aliases') , $default_aliases);
	}
	if ( $force || !$virtUserTableDB ) {
		$virtUserTableDB = &Question( &ltext('install_postfix_virtusers') , $default_virtUserTableDB);
	}
	if ( $force || !$localDomainsFile ) {
		$localDomainsFile = &Question( &ltext('install_postfix_domains') , $default_localDomainsFile);
	}
}

#
#
#=================================================================
#
#

sub configureQmail {

	my $force = shift;


  my $default_virtUserTableDB = "/var/qmail/control/virtualdomains";
  my $default_localDomainsFile = "/var/qmail/control/rcpthosts";

	if ( $force || !( $virtUserTableDB && -T $virtUserTableDB ) ) {
		$virtUserTableDB = &FileQuestion( &ltext('install_qmail_virtusers') , $default_virtUserTableDB);
	}
	if ( $force || !( $localDomainsFile && -T $localDomainsFile ) ) {
		$localDomainsFile = &FileQuestion(  &ltext('install_qmail_domains') , $default_localDomainsFile);
	}
}

#
#
#=================================================================
#
#

sub configureSendmail{

	my $force = shift;

  my $default_sendmailConfigFile = '/etc/mail/sendmail.cf';
  if ( !(-e '/etc/mail/sendmail.cf') && (-e '/etc/sendmail.cf') ) {
    $default_sendmailConfigFile = '/etc/sendmail.cf';
  }
  my $default_virtUserTableFile = '/etc/mail/virtusertable';
  my $default_VirtUserTableDB = '/etc/mail/virtusertable';
  my $default_localDomainsFile = '/etc/mail/sendmail.cw';

  if(!(-e '/etc/mail/sendmail.cw') && (-e '/etc/sendmail.cw')){
    $default_localDomainsFile = '/etc/sendmail.cw';
  }
  if(!(-e '/etc/mail/sendmail.cw') && !(-e '/etc/sendmail.cw') && (-e '/etc/mail/local-host-names')){
    $default_localDomainsFile = '/etc/mail/local-host-names';
  }
  my $default_aliases = '/etc/mail/aliases';
  if(!(-e '/etc/mail/aliases') && (-e '/etc/aliases')){
    $default_aliases = '/etc/aliases';
  }
	if ( $force || !($MailConfigFile && -T $MailConfigFile) ) {
		$MailConfigFile = &FileQuestion( &ltext('install_sendmail_conf') , $default_sendmailConfigFile, 1 );
	}
	if ( $force || !( $aliases && -T $aliases ) ) {
		$aliases = &FileQuestion( &ltext('install_sendmail_aliases') , $default_aliases, 1, 1 );
	}

	if ( $force ) {
		if (&YesNoQuestion( &ltext('install_sendmail_virtusers_old'), "j")){
			$virtUserTableFile = &FileQuestion( &ltext('install_sendmail_virtusers_old_file') , $default_virtUserTableFile);
			if ( $installDir && -d $installDir ) {
				&BackUpFile($virtUserTableFile, "$installDir/safe/virtusertable_header");
			}
		} else {
			$virtUserTableFile = '';
		}
	}

	if ( $force || !$virtUserTableDB){
		$virtUserTableDB = &Question( &ltext('install_sendmail_virtusers') , $default_VirtUserTableDB);
	}

	if ( $force ) {
		if (&YesNoQuestion( &ltext('install_sendmail_domains_old'), "j")){
			if ( $force || !($localDomainsFile && -T $localDomainsFile ) ) {
				$localDomainsFile = &FileQuestion( &ltext('install_sendmail_domains_old_file'), 
																					 $default_localDomainsFile );
			}
			if ( $installDir && -d $installDir ) {
				&BackUpFile($localDomainsFile, "$installDir/safe/sendmail_header.cw");
			}
			print "\n";
		} else {
			$localDomainsFile = &Question(&ltext('install_sendmail_domains') , $default_localDomainsFile);
		}
  }
}

sub configureMtaUidGid {

  unless( $mta_uid =~ /^\d+$/ && $mta_gid =~ /^\d+$/ ) {

		my ($default_uid);

		if( ( -e '/etc/redhat-release' ) ||
				( -e '/etc/mandrake-release' ) ||
			  ( -e '/etc/debian_version' )
			) {
			$default_uid = 8;

		}	elsif ( -e '/etc/SuSE-release' ) {
			$default_uid = 2;

		}	else {
			$default_uid = 0;
		}

    if ( $mta eq 'qmail' ) {
      $mta_uid = 0;
			$mta_gid = 0;
    }

    while($mta_uid !~ /^\d+$/){
      $mta_uid = &Question( &ltext('install_mtauid'), $default_uid);
    }
    while($mta_gid !~ /^\d+$/){
      $mta_gid = &Question( &ltext('install_mtagid'), '0');
    }
  }
}

1;
