#!/usr/bin/perl

########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####


BEGIN {
  use FindBin;
  use lib $FindBin::Bin;
  use lib $FindBin::Bin.'/../scripts';
	use lib $FindBin::Bin.'/subs';
}

use File::Basename;

use lib_module_common;
use lib_module_db;

use vars qw/$wDir/;

use strict;

## einige Variablen
my @need_binaries_sendmail = ('makemap', 'newaliases', 'sendmail');
## /einige Variablen

&initConfig;

## Pre-Main

$wDir ||= &getCanonPath( dirname($0) );

my ($installMode);

if ( $confixxState=~/install/ ) {
	$installMode = 1;
}

if ( $0 =~ /sendmail_install/ ) { ## call a single script
	safe_do "$wDir/subs_include_questions.pl";
	safe_do "wDir/subs_include_files.pl";
	safe_do "$wDir/subs_include_writeConfig.pl";
	safe_do "$wDir/mta_config.pl";

	$installMode ||= (-T "$wDir/../.config")? 1: 0;

} else {
	if ( -d "$wDir/subs" ){ ## configure & install
		safe_do "$wDir/subs/subs_include_questions.pl";
		safe_do "$wDir/subs/mta_config.pl";

	} elsif ( -d "$wDir/../subs" ) { ## update
		safe_do "$wDir/../subs/subs_include_questions.pl";
		safe_do "$wDir/../subs/mta_config.pl";
	}

	$installMode ||= (-T "$wDir/.config")? 1: 0;
}


&header2( &ltext('install_header_email', 'Sendmail') );
foreach my $binary ( @need_binaries_sendmail ) {
  $bin{$binary} ||= &getBin($binary);
}
## /Pre-Main

## Main
&configureMta( 'sendmail' );


if ( $virtUserTableFile && -T $virtUserTableFile ) {
  &BackUpFile($virtUserTableFile, "$installDir/backup/sendmail/virtusertable");
	&BackUpFile($virtUserTableFile, "$installDir/safe/virtusertable_header");
}

if ( $virtUserTableDB && -T $virtUserTableDB ) {
  &BackUpFile($virtUserTableDB, "$installDir/backup/sendmail/virtusertable.db");
}
if ( $localDomainsFile && -T $virtUserTableDB ) {
  &BackUpFile( $localDomainsFile, "$installDir/backup/sendmail/sendmail.cw" );
	&BackUpFile( $localDomainsFile, "$installDir/safe/sendmail_header.cw" );
}
if ( $aliases && -T $aliases ) {
  &BackUpFile($aliases, "$installDir/backup/sendmail/aliases");
  &BackUpFile($aliases, "$installDir/safe/aliases_header");
}
if ( $MailConfigFile && -T $MailConfigFile ) {
  &BackUpFile($MailConfigFile, "$installDir/backup/sendmail/sendmail.cf");
}
&ReadMainConfigFile;
print &ltext('install_do_file_create', $localDomainsFile);
print &ltext('install_do_file_create', $virtUserTableDB);
&ChangeConfigFile;
&UpdateMainConfig;
## /Main

## UNTERPROGRAMME

sub ChangeConfigFile {
  my $add_fw = 1;
  my $add_kv = 1;
  my (@SendmailConfig, $i);
  &BackUpFile($MailConfigFile, "$installDir/backup/sendmail/sendmail.cf");
  open(FILE, "$MailConfigFile");
  print ("Editiere: \"$MailConfigFile\"\n");
  $i = 0;
  while (<FILE>){
    if($_ !~ /^Fw$localDomainsFile\n$/){
      $_ =~ s/^Fw/#Fw/i;
    }
    else{
      $add_fw = 0;
    }
    if($_ !~ /^Kvirtuser hash $virtUserTableDB\n$/){
      $_ =~ s/^Kvirtuser/#Kvirtuser/i;
    }
    else{
      $add_kv = 0;
    }
    $SendmailConfig[$i++] = $_;
  }
  close (FILE);
  if($add_kv || $add_fw){
    $SendmailConfig[$i++] = "\n### CONFIXX SENDMAIL ENTRY ###\n\n";
    if($add_fw){
      print ( "\n" . &ltext('install_do_file_line_add', "Fw$localDomainsFile", $MailConfigFile) . "\n" );
      $SendmailConfig[$i++] = "Fw$localDomainsFile\n";
    }
    if($add_kv){
      $SendmailConfig[$i++] = "Kvirtuser hash $virtUserTableDB\n";
      print ( "\n" . &ltext('install_do_file_line_add', "Kvirtuser hash $virtUserTableDB", $MailConfigFile) . "\n" );
    }
    $SendmailConfig[$i++] = "\n### /CONFIXX SENDMAIL ENTRY ###\n";
  }
  open (FILE, ">$MailConfigFile");
  print FILE (@SendmailConfig);
  close (FILE);
}

## /UNTERPROGRAMME
