#!/usr/bin/perl

########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

BEGIN {
    # help script to find its local modules 

	use Cwd;
	use FindBin qw($Bin);
	use File::Basename;

  use lib $Bin=~s%(?<=.)/$%%?$Bin:$Bin,
		$Bin.'/subs', ## configure & install & admin.pl
		$Bin.'/admin/subs', ## confixx_updatescript.pl
		dirname($Bin).'/subs'; ## updates

  use lib getcwd(), 
		getcwd().'/subs',
		getcwd().'/admin/subs',
		dirname(getcwd()).'/subs';	
}

use lib_module_common;

&initConfig;

my $pathConfig=&getConfPath();

if (-d $installDir && dirname($pathConfig) ne $installDir){
  &loadConfFile($installDir);
}

my $wDir = (defined $wDir) ? $wDir : dirname($0);
if (-e "$wDir/subs/spamassassin_wizard.pl"){
  $wDir.='/subs';
}


$subs_include_questions = "$wDir/subs_include_questions.pl";
do $subs_include_questions;
$subs_include_writeConfig = "$wDir/subs_include_writeConfig.pl";
do $subs_include_writeConfig;
$subs_include_files = "$wDir/subs_include_files.pl";
do $subs_include_files;

&header2(&ltext('install_header_spamassassin'));

# predict where the spamassassin config is located
my $default_config = '/etc/mail/spamassassin/local.cf';
unless (-e $default_config) {
    $default_config = "/etc/spamassassin/local.cf";
}
my $default_script = "/etc/init.d/spamassassin";
unless (-x $default_script) {
  $default_script = "/etc/init.d/spamd";
}
$spamassassinConfig = &FileQuestion(&ltext('install_question_spamassassin_conf'), "$default_config");
$spamassassinScript = &FileQuestion(&ltext('install_question_spamassassin_script'), $default_script);
#$pm_spamassassin_reload = &Question(&ltext('install_question_spamassassin_restart'), "$spamassassinScript restart");
#$pm_spamassassin_start = &Question(&ltext('install_question_spamassassin_start'), "$spamassassinScript start");
$pm_spamassassin_reload = "$spamassassinScript restart";
$pm_spamassassin_start = "$spamassassinScript start";

&UpdateMainConfig;
