#!/usr/bin/perl

########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

sub configureFtpd {
  my $pathToConf = shift;
  my $ptrConf;
  if($pathToConf && (-T $pathToConf)){
    $ftpConfFile = $pathToConf;
  }else{
    $ftpConfFile = &FileQuestion( &ltext('install_question_ftpconf', 'vsftpd') , [ '/etc/vsftpd.conf', '/etc/vsftpd/vsftpd.conf' ] );

  }
  $ptrConf = &parseFtpdCongif($ftpConfFile,'listen');
  unless (ref($ptrConf)=~/HASH/){
    $ptrConf = {};
  }
  $ftpdType = "inetd";
  if(exists($ptrConf->{'listen'}) && ($ptrConf->{'listen'}=~/y/i)){

    $ftpdType = "standalone";

	unless($pm_ftpd_noscript){  ## get $pm_ftpd_noscript
	  if( &YesNoQuestion(&ltext('install_ftpd_use_script','vsftpd'),'j')){
		$pm_ftpd_noscript = 'no';
	  }else{
		$pm_ftpd_noscript = 'yes';
	  }
	}
	
	unless($pm_ftpd_noscript=~/y/i){  
	  my $ftpdScript;
      if($pm_ftpd_reload=~/^\s*(\S+)\s+/){
		$ftpdScript = $1;
	  }
	  unless(-x $ftpdScript){
		$ftpdScript = &FileQuestion(&ltext('install_question_ftpd_script','vsftpd'),'/etc/init.d/vsftpd' );
	  }	
	  if (-x $ftpdScript){
  		my $restart = &getRestart($ftpdScript)||'restart';
	  
    	$pm_ftpd_reload = "$ftpdScript $restart";
    	$pm_ftpd_start  = "$ftpdScript start";
  	  }else{
    	warn "$ftpdScript is not executable\n";
	  }
	}
  }
}


sub parseFtpdCongif {
  my $pathToConfig = shift; 
  my @keys = @_;
  my (%ret,%pats,$pat,$key,$i);
  
  return undef unless(@keys);

  if((-T $pathToConfig) && open(CONFIG,$pathToConfig)){
    foreach $key (@keys){
      $pats{$key} = qr/^\s*\Q$key\E\s*=\s*(\S+)/i;
    }
    while(<CONFIG>){
      next if /^#/;   ## commentary
      next if /^\s*$/; ## blank line
      while(($key,$pat)=each(%pats)){  ## loop by patterns
	if (/$pat/){
	  $ret{$key}=$1;        ## found
	  delete($pats{$key});
	  last;
	}
      }
      last unless (keys %pats);  ## no more patterns
    }
    close (CONFIG);
  }
  return \%ret;
}

sub restartFtpd {
  unless ($ftpdType =~ /inetd|standalone/){
    $ftpdType = &SelectQuestion( &ltext('install_question_ftpservertype'), ('inetd','standalone'));
  }
  if ($ftpdType eq 'standalone'){
  
  	my $cmd;
	
	unless($pm_ftpd_noscript){
	  if( &YesNoQuestion(&ltext('install_ftpd_use_script','vsftpd'),'j')){
		$pm_ftpd_noscript = 'no';
	  }else{
		$pm_ftpd_noscript = 'yes';
	  }
	}
	
	if($pm_ftpd_noscript=~/y/i){
	
	  my $pid=`ps -A|grep vsftpd`;  ## get pid of vsftpd
	  
	  if($pid=~/^(\d+)\s/){
		$cmd ="kill -s SIGHUP $1";   ## send signal to vsftpd
	  }
	
	}else{

  	  unless ( $pm_ftpd_reload ){
    	my $ftpdScript = &FileQuestion(&ltext('install_question_ftpd_script','vsftpd'),'/etc/init.d/vsftpd' );
    	if(-x $ftpdScript){
		  my $restart = &getRestart($ftpdScript) || 'restart';
		  $pm_ftpd_reload = "$ftpdScript $restart";
		  $pm_ftpd_start  = "$ftpdScript start";
    	}else{
		  warn "'$ftpdScript' is not executable\n";
    	}
  	  }
	  $cmd = $pm_ftpd_reload;
	}  
    if ($cmd){

      print  &ltext('reload_header_ftp', 'vsftpd'),"\n";

      system($cmd) and
		warn "Error by reload vsftpd: $!\n";
    }
  }else{
#    my ($pid);
#    $bin_grep ||= 'grep';
#    my $out = `ps -A|$bin_grep inetd`;
#    if($out=~/\s*(\d+)\s+/){
#      $pid = $1;
#      system("kill -HUP $pid") and 
#	warn "Error by reload xinetd: $!\n";
#    }
  }
}


sub getRestart {
  my $script = shift;
  my @restarts = ('reload','restart','reread');
  my @keys = &getKeys($script);
  my ($key,%inKeys);
  foreach  $key (@keys) {
	$inKeys{$key}=1;
  }
  foreach $key (@restarts) {
	if($inKeys{$key}){
	  return $key;
	}
  }
}

sub getKeys {
  my $script = shift;
  my (@keys,$key);
  if (-x $script){
    if (-T $script && open (SCRIPT,"< $script")){
      my $state;
      while (<SCRIPT>){  
	  
		if(/^\s*case\s+/){  ## begin of case-block 

		  $state=1;

		}elsif($state==1 && /^\s*([-_a-z|]+)\)/ ){  ## case value
		
		  push @keys,split(/\|/,$1);
		  
		}elsif(/^\s*esac(\s|;)/){ ## end of case-block
		
		  foreach $key (@keys){  ## find start
	  		if ($key eq 'start'){
	    	  $state++;
			  last;
	  		}
		  }
		  if($state != 2){  ## start is not found
	  		@keys=();  ## wrong case
		  }
		  $state=0;
		}
      }
      close (SCRIPT);
    }
    unless(@keys){  ## try get help string
      my $out=`$script`;
      if($out=~/(start\|[-_a-z|]+)/){  ## parse output
  		@keys = split(/\|/,$1);
      }	
    }
  }
  return @keys;
}

1;

