#!/usr/bin/perl

########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

use strict;
use File::Basename;
use File::Copy;
use Cwd;

# -------------------- installScript -------------------- #
sub installScript($$$$$;%) {
	my ($script, $uid, $gid, $mode, $dir, %options) = @_;

	my $srcDir = dirname( $0 );
	my $cwd = getcwd();
			
	$srcDir =~ s%^.(?=/|$)%$cwd%;
	
	my $from_script = "$srcDir/../scripts/$script";
	unless( -f $from_script ){
		$from_script = "$srcDir/scripts/$script";
	}
	unless( -f $from_script ){
		$from_script = "$srcDir/admin/scripts/$script";
	}

	my $to_script = "$dir/$script";
	
	unless (-e $from_script){
	  warn "Source is not found '$from_script'\n";
	}

    print &ltext('install_do_file_create', $to_script);

# read file and make replacements

		my ($param,%replace,$reParam,$re,$val,$refArr);
#
# prepare options
#
		foreach $param (keys %options) {
			if ( $param =~ /confixx_s?binDir/ ){
				$replace{$param} = [ qr/^\s*use\s+lib\s+'##\Q$param\E##'.*/,
														 "use lib '$options{$param}';"
													 ];
			} else {
				$replace{$param} = [ qr/^\s*\$\Q$param\E\s*=.*/,
														 "\$$param = \'$options{$param}\';"
													 ];
			}
		}

    my (@Script,$str);

	if( keys %options ){
#
# read source
#
  	  if ( open (FILE, '<', $from_script ) ) {
			while ( $str = <FILE> ) {
				chomp $str;
				unless ( $str =~ /^\s*(?:#|$)/ ){ ## skip blank & comment
					foreach $refArr ( values %replace ) {
						($re,$val) = @{$refArr};
						if ( $str =~ s/$re/$val/ ) {
							last; ## found
						}
					}
				}
				push @Script,$str;
			}
			close(FILE);
		} else {
			warn "Can't open file '$from_script' to read: $!\n";
		}

# save result

    if ( open(FILE, '>', "$ENV{'DESTDIR'}$to_script" ) ) {
		  	map { print FILE $_,"\n" } @Script;
			close(FILE);
		} else {
			warn "Can't open file '$to_script' to write: $!\n";
		}
	}else{
	  copy( $from_script, "$ENV{'DESTDIR'}$to_script") or
		warn "Can't copy '$to_script': $!\n";
	}
# set permissions

    chown( $uid, $gid, "$ENV{'DESTDIR'}$to_script" );
    chmod( $mode, "$ENV{'DESTDIR'}$to_script" );               # chmod should be AFTER chown to avoid loosing suid bits
}
# -------------------- end installScript -------------------- #





# -------------------- skinmng_opt -------------------- #
# input var set turning OFF state (required for unzip OFF )
sub skinmng_opt{
    my ($no_unzip) = @_;
    return (
	'confixx_binDir' => $::confixx_binDir,
	'confixx_sbinDir' => $::confixx_sbinDir,
	'confixx_htmlDir' => $::confixx_htmlDir,
	'confixx_tmpDir' => $::confixx_tmpDir,
	'confixx_user' => $::confixx_user,
	'confixx_group' => $::confixx_group,
	'confixx_gid' => $::confixx_gid,
	'bin_gzip' => $::bin_gzip||$::bin{'gzip'}||'gzip',
	'bin_tar'  => $::bin_tar||$::bin{'tar'}||'tar',
	'bin_unzip' => $::bin_unzip||$::bin{'unzip'}|| ( ($no_unzip) ? "" : 'unzip'),
	'bin_find' => $::bin_find||$::bin{'find'}||'find',
    );
}
# -------------------- end skinmng_opt -------------------- #

1;
