// ascii.hh
// This file is part of libpbe; see http://anyterm.org/
// (C) 2008 Philip Endecott

// Distributed under the Boost Software License, Version 1.0:
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

#ifndef libpbe_charset_conv_ascii_hh
#define libpbe_charset_conv_ascii_hh

#include "charset/charset_t.hh"
#include "charset/char_conv.hh"


namespace pbe {

// ASCII-to-Unicode character conversion
// --------------------------------------
//
// This file provides specialisations of char_conv to convert between ASCII
// and ucs2 and ucs4.


IDENTITY_CHAR_CONV(cs::ascii,cs::ucs4)
IDENTITY_CHAR_CONV(cs::ascii,cs::ucs2)

template <typename error_policy>
struct char_conv<cs::ucs2,cs::ascii,error_policy> {
  char8_t
  operator() ( char16_t c,
               charset_traits<cs::ucs2>::state_t&,
               charset_traits<cs::ascii>::state_t& ) {
    if (c>0x7f) {
      return error_policy::no_equivalent(c);
    }
    return c;
  }
};

template <typename error_policy>
struct char_conv<cs::ucs4,cs::ascii,error_policy> {
  char8_t
  operator() ( char32_t c,
               charset_traits<cs::ucs4>::state_t&,
               charset_traits<cs::ascii>::state_t& ) {
    if (c>0x7f) {
      return error_policy::no_equivalent(c);
    }
    return c;
  }
};


};

#endif
