// unicode.hh
// This file is part of libpbe; see http://anyterm.org/
// (C) 2008 Philip Endecott

// Distributed under the Boost Software License, Version 1.0:
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

#ifndef libpbe_charset_conv_unicode_hh
#define libpbe_charset_conv_unicode_hh

#include "charset/charset_t.hh"
#include "charset/char_conv.hh"
#include "charset/char_t.hh"


namespace pbe {

// Unicode character conversion
// ----------------------------
//
// This file provides specialisation of char_conv for the Unicode
// character types.
// Note that UTF-8 and UTF-16 characters are 32-bit characters here,
// not groups of units.
// Everything is trivial except conversion to ucs2.

// UTF16 has not been implemented yet.


IDENTITY_CHAR_CONV(cs::ucs2,cs::ucs4)
IDENTITY_CHAR_CONV(cs::ucs2,cs::utf8)
//IDENTITY_CHAR_CONV(cs::ucs2,cs::utf16)

IDENTITY_CHAR_CONV(cs::ucs4,cs::utf8)
//IDENTITY_CHAR_CONV(cs::ucs4,cs::utf16)

IDENTITY_CHAR_CONV(cs::utf8,cs::ucs4)
//IDENTITY_CHAR_CONV(cs::utf8,cs::utf16)

//IDENTITY_CHAR_CONV(cs::utf16,cs::ucs4)
//IDENTITY_CHAR_CONV(cs::utf16,cs::utf8)


#define CONV_TO_UCS2(FROM_CS)                                        \
template <typename error_policy>                                     \
struct char_conv<FROM_CS,cs::ucs2,error_policy> {                    \
  char16_t                                                           \
  operator() ( charset_traits<FROM_CS>::char_t c,                    \
               charset_traits<FROM_CS>::state_t&,                    \
               charset_traits<cs::ucs2>::state_t& ) {                \
    if (c>0xffff) {                                                  \
      return error_policy::no_equivalent(c);                         \
    }                                                                \
    return c;                                                        \
  }                                                                  \
};

CONV_TO_UCS2(cs::ucs4)
CONV_TO_UCS2(cs::utf8)
//CONV_TO_UCS2(cs::utf16)

#undef CONV_TO_UCS2


};

#endif
