#include <iostream>
#include "format.hh"

#include "Dunzipper.hh"

#include "Exception.hh"
#include "strto.hh"

#include <string>

using namespace pbe;
using namespace std;


static void dunzip(string fn, size_t start, size_t len)
{
  Dunzipper dz(fn);

  char buf[len];
  dz.read(start,len,buf);

  write(1,buf,sizeof(buf));
}


static void usage()
{
  cerr << "Usage: dunzip <fn> <start> <len>\n";
  exit(1);
}


int main(int argc, char* argv[])
{
  try { try {

    if (argc!=4) {
      usage();
    }

    string fn = argv[1];
    size_t start = strtol(argv[2]);
    size_t len = strtol(argv[3]);

    dunzip(fn,start,len);

    return 0;


  } RETHROW_MISC_EXCEPTIONS }
  catch (Exception& E) {
    E.report(cerr);
    exit(1);
  }
}

