// char_converter.hh
// This file is part of libpbe; see http://anyterm.org/
// (C) 2008 Philip Endecott

// Distributed under the Boost Software License, Version 1.0:
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

#ifndef libpbe_charset_char_converter_hh
#define libpbe_charset_char_converter_hh

#include "charset_t.hh"
#include "charset_traits.hh"
#include "char_conv.hh"
#include "error_policy.hh"


namespace pbe {

// Stateful functor for character conversion
// -----------------------------------------
//
// The function template char_conv takes state variables for the input and output,
// in case they are stateful.
// A simplified interface is provided by this functor, which keeps the state
// internally from one call to the next.

template <charset_t from_cs, charset_t to_cs, typename error_policy = default_error_policy>
class char_converter {
  typedef charset_traits<from_cs> from_traits;
  typedef charset_traits<to_cs>   to_traits;

  typename from_traits::state_t from_state;
  typename to_traits::state_t to_state;

public:
  char_conv<from_cs,to_cs,error_policy> cc;
  typename to_traits::char_t operator()(typename from_traits::char_t c) {
    return cc ( c, from_state, to_state );
  }

  // TODO flush, perhaps reset.
};

};

#endif
