// char_t.hh
// This file is part of libpbe; see http://anyterm.org/
// (C) 2007-2008 Philip Endecott

// Distributed under the Boost Software License, Version 1.0:
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

#ifndef libpbe_charset_char_t_hh
#define libpbe_charset_char_t_hh

#include <boost/integer.hpp>

namespace pbe {

// Defined-size character types
// ----------------------------
//
// The built-in types char and wchar_t have different numbers of bits on
// different platforms.  C++0x will probably have new char types of determined
// sizes; this file provides three typedefs, char8_t, char16_t and char32_t 
// that do the same sort of thing.  These map to char and wchar_t when 
// appropriate, and to an unsigned integer of the appropriate size (using 
// Boost.Integer) otherwise.
//
// The specialised template class char_t<N> provides a typedef 'type' for an
// N-bit character.


template <int bits>
struct char_t {
  typedef typename boost::uint_t<bits>::least type;
};

template <>
struct char_t<8*sizeof(char)> {
  typedef char type;
};

template <>
struct char_t<8*sizeof(wchar_t)> {
  typedef wchar_t type;
};

typedef char_t<8>::type  char8_t;
typedef char_t<16>::type char16_t;
typedef char_t<32>::type char32_t;


};

#endif
