// character_output_iterator.hh
// This file is part of libpbe; see http://anyterm.org/
// (C) 2007-2008 Philip Endecott

// Distributed under the Boost Software License, Version 1.0:
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

#ifndef libpbe_charset_character_output_iterator_hh
#define libpbe_charset_character_output_iterator_hh

#include "charset_t.hh"
#include "charset_traits.hh"

namespace pbe {

// Character Output Iterator Adapter
// ---------------------------------
//
// This iterator adapter takes an output iterator over a string's units
// and supplies an output iterator that stores characters.  This is of
// course trivial for fixed-length character sets; for variable-length
// character sets the encoding is performed by a function supplied by the
// character set's traits class.
// The supplied iterator is only an output iterator: the only permitted
// pattern of use is to alternately store characters and increment the 
// iterator.  Typically it will be used with an appending ("back insert")
// iterator:
//
// typedef std::container<char> ctr_t;
// ctr_t ctr;
// typedef std::back_insert_iterator<ctr_t> unit_iter_t;
// unit_iter_t ui(ctr);  // ui inserts units
// typedef character_output_iterator<cs::utf8, unit_iter_t> char_iter_t;
// char_iter_t ci(ui);   // ci inserts characters
// *(ci++) = 0x1234;     // some random non-ASCII character


template <charset_t cs, typename unit_iterator_t>
class character_output_iterator {
  unit_iterator_t i;

  struct assignment_proxy {
    unit_iterator_t& i;
    assignment_proxy(unit_iterator_t& i_): i(i_) {}
    void operator=(typename charset_traits<cs>::char_t c) {
      charset_traits<cs>::encode(i,c);
    }
  };

public:
  character_output_iterator() {}
  character_output_iterator(const unit_iterator_t& i_): i(i_) {}
  assignment_proxy operator*() { return assignment_proxy(i); }
  character_output_iterator& operator++() { return *this; }
  character_output_iterator& operator++(int) { return *this; }
  unit_iterator_t& base() { return i; }
};



};

#endif
