// charset_names.hh
// This file is part of libpbe; see http://anyterm.org/
// (C) 2008 Philip Endecott

// Distributed under the Boost Software License, Version 1.0:
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

#ifndef libpbe_charset_charset_names_hh
#define libpbe_charset_charset_names_hh

#include <string>

#include "charset_t.hh"

namespace pbe {

// Character Set Names
// -------------------
//
// This file provides functions for converting between character set names
// in ASCII strings and charset_t values.
//
// Several names may be recorded for each character set.  The primary 
// IANA-registered name is returned by charset_name().  charset_mime_name()
// returns the same as charset_name(), unless a different name is preferred
// for MIME purposes.  (Typically the preferred MIME name is more concise,
// while the primary name is less ambiguous.)  lookup_charset() recognises
// both of these names plus a large number of IANA-defined aliases and
// many variations in case and punctuation.


extern const char* const charset_iana_names[];

inline const char* charset_name(charset_t cs) {
  return charset_iana_names[cs];
}


extern const char* const charset_mime_names[];

inline const char* charset_mime_name(charset_t cs) {
  return charset_mime_names[cs];
}


struct NoSuchCharacterSet {};  // FIXME maybe we need a no-throw version too?

charset_t lookup_charset(const char* name);
charset_t lookup_charset(std::string name);

};

#endif
