// sequence_conv.hh
// This file is part of libpbe; see http://anyterm.org/
// (C) 2008 Philip Endecott

// Distributed under the Boost Software License, Version 1.0:
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

#ifndef libpbe_charset_sequence_conv_hh
#define libpbe_charset_sequence_conv_hh

#include "charset_t.hh"
#include "charset_traits.hh"
#include "char_conv.hh"
#include "error_policy.hh"


namespace pbe {

// Conversion of strings between character sets
// -----------------------------------------------
//
// This file provides facilites to convert sequences of characters, including
// strings and other sequences, from one character set to another.  Essentially
// this just involves repeated application of the character-at-a-time
// char_conv template, and that is the default strategy implemented below.
// However for some iterators and some character set pairs, optimised
// implementations are possible and these can be provided by specialisation
// of sequence_conv.

// Base template, with default implementation using char_conv:

template< charset_t from_cs, charset_t to_cs, typename error_policy,
          typename InputIterator, typename OutputIterator, typename Enable = void >
struct sequence_conv {
  OutputIterator
  operator() ( InputIterator first, const InputIterator& last,
               OutputIterator result,
               typename charset_traits<from_cs>::state_t& from_state,
               typename charset_traits<to_cs>::state_t& to_state)
  {
    for (; first != last; ++first) {
      *(result++) = char_conv<from_cs,to_cs,error_policy>()(*first,from_state,to_state);
    }
    return result;
  }
};




};

#endif
