// include/scoped_true.hh
// This file is part of libpbe; see http://svn.chezphil.org/libpbe/
// (C) 2008 Philip Endecott

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#ifndef pbe_scoped_true_hh
#define pbe_scoped_true_hh

// This file provides a simple class that sets a boolean to true when it
// is constructed and to false when it is destructed.


namespace pbe {

template <typename B = bool>
class scoped_true {
  B& var;
public:
  scoped_true(B& var_):
    var(var_)
  {
    var = true;
  }
  ~scoped_true() {
    var = false;
  }
};

};

#endif

