// include/voidptr_cast.hh
// This file is part of libpbe; see http://svn.chezphil.org/libpbe/
// (C) 2010 Philip Endecott

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#ifndef libpbe_voidptr_cast_hh
#define libpbe_voidptr_cast_hh

namespace pbe {

// Cast from one pointer to another via a void*.
// reinterpret_cast is often used for this, but that is less well 
// defined than a two step static cast via void*.  But the two step 
// cast is more verbose.  This fixes the verbosity.

// FIXME how do I make the const and non-const versions work right?

#if 0
template <typename T, typename S>
T voidptr_cast(S src) {
  return static_cast<T>(static_cast<void*>(src));
}
#endif

template <typename T, typename S>
const T voidptr_cast(const S src) {
  return static_cast<T>(static_cast<const void*>(src));
}

};

#endif

